/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportGraph {
    private static final NotNullLazyKey<CachedValue<MultiMap<VirtualFile, VirtualFile>>, Project> HEADER_TO_ALL_ROOTS_CACHE = NotNullLazyKey.create((String)"HEADER_TO_ALL_ROOTS_CACHE", project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
        OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(project2).getModificationTrackers();
        return new CachedValueProvider.Result((Object)new ConcurrentMultiMap(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
    }, false));
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", dom -> new ConcurrentHashMap());
    private static final NotNullLazyKey<SimpleModificationTracker, Project> MODIFICATION_TRACKER = NotNullLazyKey.create((String)"MODIFICATION_TRACKER", project2 -> new SimpleModificationTracker());
    private static final NotNullLazyKey<Cache, Project> IMPORTS_GRAPH = NotNullLazyKey.create((String)"IMPORT_GRAPH", project2 -> new Cache((Project)project2));

    @NotNull
    public static SimpleModificationTracker getModificationTracker(@NotNull Project project2) {
        return (SimpleModificationTracker)MODIFICATION_TRACKER.getValue((UserDataHolder)project2);
    }

    public static void invalidateHeaderRootsCache(@NotNull Project project2) {
        project2.putUserData(HEADER_TO_ALL_ROOTS_CACHE, null);
    }

    @NotNull
    public static Collection<VirtualFile> getAllHeaderRoots(@NotNull Project project2, @NotNull VirtualFile header) {
        MultiMap value = (MultiMap)((CachedValue)HEADER_TO_ALL_ROOTS_CACHE.getValue((UserDataHolder)project2)).getValue();
        if (!value.containsKey((Object)header)) {
            Collection<VirtualFile> roots = OCImportGraph.findAllRootsThatInclude(project2, header, true);
            assert (!roots.isEmpty());
            value.put((Object)header, roots);
        }
        return value.get((Object)header);
    }

    @Nullable
    public static Set<VirtualFile> buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, boolean isSurrogate, @Nullable ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return null;
        }
        Project project2 = configuration.getProject();
        if (!OCInclusionContextUtil.isNeedToFindRoot(rootFile, project2)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            return OCImportGraph.getAllRootHeaders(configuration, rootFile, indicator, isSurrogate);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(rootFile);
        if (psiFile instanceof OCConfigurationOwner) {
            OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, project2, false);
            OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, kind, psiFile, isSurrogate);
            context.preprocessInclude(psiFile, true);
            return context.getProcessedFiles();
        }
        return null;
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration, VirtualFile file) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).remove(file);
    }

    public static void invalidateRootHeadersCache(OCResolveConfiguration configuration) {
        ((Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration)).clear();
    }

    @NotNull
    public static Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator, boolean isSurrogate) {
        Project project2 = configuration.getProject();
        assert (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) : "Not a root file";
        Map value = (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
        Set<Object> result = (Set)value.get(root);
        if (result == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result = OCImportGraph.getAllPCHRootHeaders(psiManager, configuration, root, indicator);
                } else {
                    OCInclusionContext context = OCInclusionContext.sourceParsingContext(configuration, ((OCConfigurationOwner)rootPsi).getKind(), rootPsi, isSurrogate);
                    context.preprocessInclude(rootPsi, true);
                    result = context.getProcessedFiles();
                }
            } else {
                result = Collections.emptySet();
            }
            value.put(root, result);
        }
        return result;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        HashSet<Pair> sources = new HashSet<Pair>();
        for (VirtualFile vRoot : configuration.getSources()) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileImpl.isSourceCodeFile(vRoot.getName()) || pch.equals(vRoot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!((rootPsi = vRoot.isValid() ? psiManager.findFile(vRoot) : null) instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getKind()).supportsPrecompiledHeaders()) continue;
            sources.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result = new THashSet();
        for (Pair src : sources) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result.remove((Object)pch);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public static Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull OCFile header, @Nullable ProgressIndicator progress) {
        Project project2 = header.getProject();
        VirtualFile file = OCInclusionContextUtil.getVirtualFile(header);
        if (file == null) {
            return Collections.emptySet();
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : OCImportGraph.getAllHeaderRoots(header.getProject(), file)) {
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, file, root, ret, progress);
        }
        return Collections.unmodifiableSet(ret);
    }

    public static void fillHeaderConfigurationsForRoot(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result, @Nullable ProgressIndicator progress) {
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection<OCResolveConfiguration> configs = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project2);
        if (!OCInclusionContextUtil.isNeedToFindRoot(root, project2)) {
            for (OCResolveConfiguration config : configs) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!OCImportGraph.getAllRootHeaders(config, root, progress, false).contains(header)) continue;
                result.add(config);
            }
        } else {
            result.addAll(configs);
        }
    }

    public static boolean processIncludingFiles(@NotNull Project project2, @NotNull VirtualFile headerFile, boolean strict, boolean rootsOnly, @NotNull Processor<? super VirtualFile> processor2) {
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ProgressManager.checkCanceled();
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                ProgressManager.checkCanceled();
                if (headerHolder == null || !processed.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = OCImportGraph.findImmediateIncludingFiles(project2, headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    ProgressManager.checkCanceled();
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)project2).findFile(importHolder);
                    if (!(!(psiImportHolder instanceof OCFile) || rootsOnly && OCInclusionContextUtil.isNeedToFindRoot(psiImportHolder) || processor2.process((Object)importHolder))) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public static Collection<VirtualFile> findAllRootsThatInclude(@NotNull Project project2, @NotNull VirtualFile original, boolean strict) {
        if (!OCInclusionContextUtil.isNeedToFindRoot(original, project2)) {
            return Collections.singletonList(original);
        }
        PsiFile originalFile = PsiManager.getInstance((Project)project2).findFile(original);
        if (!(originalFile instanceof OCFile)) {
            return Collections.singletonList(original);
        }
        THashSet result = new THashSet();
        OCImportGraph.processIncludingFiles(project2, original, strict, true, (Processor<? super VirtualFile>)((Processor)virtualFile -> {
            result.add(virtualFile);
            return true;
        }));
        return result.isEmpty() ? Collections.singletonList(original) : new ArrayList(result);
    }

    @NotNull
    public static Collection<VirtualFile> findImmediateIncludingFiles(@NotNull Project project2, @NotNull VirtualFile file, boolean strict) {
        return ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).get(file, strict);
    }

    public static void addHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).add(header, includer);
    }

    public static void removeHeaderIncluder(@NotNull Project project2, @NotNull VirtualFile header, @NotNull VirtualFile includer) {
        ((Cache)IMPORTS_GRAPH.getValue((UserDataHolder)project2)).remove(header, includer);
    }

    private static class Cache {
        private static final boolean USE_STRICT = Registry.is((String)"cidr.indexer.strictImportGraph", (boolean)false);
        @NotNull
        private final Project myProject;
        @NotNull
        private final AtomicInteger isEnsuringFilesProcessed = new AtomicInteger();
        @NotNull
        private final Object myLock = new Object();
        MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders = MultiMap.createSet();
        MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders = MultiMap.createSet();

        private Cache(@NotNull Project project2) {
            this.myProject = project2;
            project2.getMessageBus().connect().subscribe(FileSymbolTableCacheListener.TOPIC, (Object)new FileSymbolTableCacheListener.Adaptor(){

                @Override
                public void onSymbolsUpToDate() {
                    this.onUpToDate();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUpToDate() {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myAddOnlyHeaderToIncluders.isEmpty()) {
                    this.myAddOnlyHeaderToIncluders.clear();
                    OCImportGraph.getModificationTracker(this.myProject).incModificationCount();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Collection<VirtualFile> get(@NotNull VirtualFile header, boolean strict) {
            boolean useStrict;
            Application app = ApplicationManager.getApplication();
            boolean bl = useStrict = USE_STRICT || app.isUnitTestMode();
            if (strict) {
                app.assertReadAccessAllowed();
                boolean sync = app.isUnitTestMode() || useStrict && !app.isDispatchThread();
                this.ensureFilesProcessed(sync);
            }
            Object object = this.myLock;
            synchronized (object) {
                Collection<VirtualFile> ns = null;
                if (!strict || !useStrict) {
                    ns = this.getInner(header, true);
                }
                Collection<VirtualFile> sr = this.getInner(header, false);
                if (ns == null || ns.isEmpty()) {
                    return sr;
                }
                if (sr.isEmpty()) {
                    return ns;
                }
                THashSet fs = new THashSet(ns);
                fs.addAll(sr);
                return fs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Contract(value="_, false -> !null")
        private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
            Object object = this.myLock;
            synchronized (object) {
                MultiMap<VirtualFile, VirtualFile> h2is;
                MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
                if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                    return null;
                }
                Collection files = h2is.get((Object)header);
                boolean allValid = true;
                for (VirtualFile file : files) {
                    if (file.isValid()) continue;
                    allValid = false;
                    break;
                }
                if (!allValid) {
                    for (VirtualFile file : files.toArray(VirtualFile.EMPTY_ARRAY)) {
                        if (file.isValid()) continue;
                        h2is.remove((Object)header, (Object)file);
                    }
                    files = h2is.get((Object)header);
                    if (!fromAddOnlyCache) {
                        OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                    }
                }
                return ContainerUtil.immutableList((Object[])files.toArray(VirtualFile.EMPTY_ARRAY));
            }
        }

        private void ensureFilesProcessed(boolean sync) {
            if (FileSymbolTablesCache.getInstance(this.myProject).isUpToDate(true)) {
                this.onUpToDate();
                return;
            }
            if (sync) {
                this.isEnsuringFilesProcessed.incrementAndGet();
                try {
                    this.ensurePendingFilesProcessed();
                    return;
                }
                finally {
                    this.isEnsuringFilesProcessed.decrementAndGet();
                }
            }
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

                public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                    try {
                        this.ensurePendingFilesProcessed();
                    }
                    finally {
                        isEnsuringFilesProcessed.decrementAndGet();
                    }
                }

                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    this.ensureFilesProcessed(false);
                }
            });
        }

        private void ensurePendingFilesProcessed() {
            if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
            cache.ensurePendingFilesProcessed(true);
            this.onUpToDate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            Object object = this.myLock;
            synchronized (object) {
                this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
                if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                OCImportGraph.getModificationTracker(this.myProject).incModificationCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                    if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                        this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                        this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                    }
                    OCImportGraph.invalidateHeaderRootsCache(this.myProject);
                    OCImportGraph.getModificationTracker(this.myProject).incModificationCount();
                }
            }
        }
    }
}

