/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.MergingCharSequence;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCCompilerMacros;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilderImpl;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextImpl
implements OCInclusionContext {
    static int DEFAULT_MAX_INCLUSION_LEVEL = 256;
    @NotNull
    private final OCLanguageKind myLanguageKind;
    private boolean myIsSurrogate;
    private final boolean myNotifyLocalDefinitions;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    @NotNull
    private final Project myProject;
    @NotNull
    private final THashMap<String, OCMacroSymbol> mySubstitutions = new THashMap();
    @NotNull
    private final Set<String> myUndefList = new THashSet();
    @NotNull
    private volatile OCParsingNameScope myNameScope;
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new THashSet();
    @Nullable
    private final OCInclusionContextImpl myParentContext;
    private final int myInclusionLevel;
    @Nullable
    private PsiFile myRootFile;
    @Nullable
    private volatile OCFile[] myPrecompiledHeaders = null;
    @Nullable
    private OCInclusionContext.SignatureBuilder mySignatureBuilder = null;
    @NotNull
    private final List<String> myCurrentNamespace;
    private Processor<OCSymbol> myProcessingListener;
    @Nullable
    private OCContextChangeBuilder myChangeBuilder;
    private final THashMap<String, OCMacroSymbol> myOverriddenSubstitutions;
    @NotNull
    private static final Object NULL_VALUE = new Object();
    @NotNull
    private final ConcurrentHashMap<OCCompilerFeatures.Type, Object> myCompilerFeatures;
    @Nullable
    private OCInclusionContext.ResolvePathListener myResolvePathListener;
    static final NotNullLazyKey<Map<FileSymbolTable, Boolean>, OCResolveConfiguration> INCLUDE_RESOLVE_CACHE = NotNullLazyKey.create((String)"INCLUDE_RESOLVE_CACHE", dom -> Collections.synchronizedMap(ContainerUtil.createWeakMap()));
    static final NotNullLazyKey<SimpleModificationTracker, Project> PROJECT_MODIFICATION_TRACKER = NotNullLazyKey.create((String)"PROJECT_MODIFICATION_TRACKER", project2 -> new SimpleModificationTracker());
    private static final Key<CachedValue<PCHCache>> PCH_CACHE_KEY = Key.create((String)"PCH_CACHE_KEY");
    static final NotNullLazyKey<InitialPlainAndPchContexts, OCResolveConfiguration> INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY = NotNullLazyKey.create((String)"INITIAL_CONTEXTS_KEY", p -> new InitialPlainAndPchContexts());
    static final NameScopeInternator NAME_SCOPE_INTERNATOR = new NameScopeInternator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PCHCache getPCHCache(@NotNull Project project2) {
        CachedValue value = (CachedValue)project2.getUserData(PCH_CACHE_KEY);
        if (value == null) {
            SimpleModificationTracker modificationTracker = (SimpleModificationTracker)PROJECT_MODIFICATION_TRACKER.getValue((UserDataHolder)project2);
            CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)new PCHCache(project2), new Object[]{modificationTracker});
            CachedValue newValue = CachedValuesManager.getManager((Project)project2).createCachedValue(provider2, false);
            value = (CachedValue)((UserDataHolderEx)project2).putUserDataIfAbsent(PCH_CACHE_KEY, (Object)newValue);
        }
        if (value.hasUpToDateValue()) {
            return (PCHCache)value.getValue();
        }
        CachedValue cachedValue = value;
        synchronized (cachedValue) {
            return (PCHCache)value.getValue();
        }
    }

    @NotNull
    static List<OCFile> getPrecompiledHeaders(@NotNull OCResolveConfiguration config, @NotNull OCLanguageKind kind, @NotNull VirtualFile sourceFile) {
        List<VirtualFile> pchs = config.getCompilerSettings(kind, sourceFile).getPrecompiledHeaders();
        if (pchs.isEmpty()) {
            return Collections.emptyList();
        }
        PsiManager psiManager = PsiManager.getInstance((Project)config.getProject());
        ArrayList<OCFile> result = new ArrayList<OCFile>(pchs.size());
        for (VirtualFile pch : pchs) {
            PsiFile pchPsi;
            if (!pch.isValid() || !((pchPsi = psiManager.findFile(pch)) instanceof OCFile)) continue;
            result.add((OCFile)pchPsi);
        }
        return result;
    }

    OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCLanguageKind languageKind) {
        assert (configuration == null || project2.equals(configuration.getProject()));
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = languageKind;
        this.myNameScope = new OCParsingNameScope();
        this.myParentContext = null;
        this.myInclusionLevel = 0;
        this.myNotifyLocalDefinitions = false;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = new THashMap();
        this.myCompilerFeatures = new ConcurrentHashMap();
    }

    private OCInclusionContextImpl(@Nullable OCResolveConfiguration configuration, @NotNull Project project2, @NotNull OCInclusionContextImpl parentContext, @NotNull PsiFile rootFile, @NotNull OCParsingNameScope nameScope, boolean notifyLocalDefinitions) {
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myLanguageKind = parentContext.myLanguageKind;
        this.myIsSurrogate = parentContext.isSurrogate();
        this.myParentContext = parentContext;
        this.myRootFile = rootFile;
        this.myNameScope = nameScope;
        this.myInclusionLevel = this.myParentContext.myInclusionLevel + 1;
        this.myNotifyLocalDefinitions = notifyLocalDefinitions;
        this.myCurrentNamespace = new ArrayList<String>();
        this.myOverriddenSubstitutions = parentContext.myOverriddenSubstitutions;
        this.myCompilerFeatures = parentContext.myCompilerFeatures;
        this.myResolvePathListener = parentContext.myResolvePathListener;
        Project configurationProject = configuration != null ? configuration.getProject() : null;
        OCLog.LOG.assertTrue(this.myInclusionLevel <= OCInclusionContext.getMaxInclusionLevel(configurationProject) + 2, (Object)"Inclusion level is too high");
    }

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        return this.myLanguageKind;
    }

    @Override
    public boolean isSurrogate() {
        return this.myIsSurrogate || this.myParentContext != null && this.myParentContext.isSurrogate();
    }

    @Override
    public void markAsSurrogate() {
        this.myIsSurrogate = true;
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.addProcessedFile(file);
        }
        this.myProcessedFiles.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkConformanceAndFillSignatures(@NotNull FileSymbolTable table) {
        this.enterConformanceCheckMode();
        boolean isCompatibleTable = false;
        try {
            ContextSignature sig = table.getSignature();
            if (sig.isCompatible(this)) {
                isCompatibleTable = this.myConfiguration == null || this.conformsToByIncludes(table);
            }
            boolean bl = isCompatibleTable;
            return bl;
        }
        finally {
            this.exitConformanceCheckMode(isCompatibleTable);
        }
    }

    @Override
    public void setProcessingListener(@Nullable Processor<OCSymbol> processingListener) {
        this.myProcessingListener = processingListener;
    }

    @Override
    public void setResolvePathListener(@Nullable OCInclusionContext.ResolvePathListener resolvePathListener) {
        this.myResolvePathListener = resolvePathListener;
    }

    @Override
    public void setChangeBuilder(@Nullable OCContextChangeBuilder changeBuilder) {
        this.myChangeBuilder = changeBuilder;
    }

    @NotNull
    static OCInclusionContext emptyWithBuiltinMacros(@Nullable OCLanguageKind kind, @NotNull PsiFile file) {
        if (kind == null) {
            kind = OCLanguageKindCalculator.calculateLanguageKindFast(file);
        }
        OCInclusionContextImpl result = (OCInclusionContextImpl)OCInclusionContext.empty(kind, file);
        result.initContext(file, null);
        return result;
    }

    @NotNull
    static OCInclusionContextImpl initialContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile == null && file instanceof OCCodeFragment) {
            return OCInclusionContextImpl.createNewContext(configuration, kind, file, true);
        }
        CompilerSettingsKey key = configuration.getCompilerSettings(kind, virtualFile).getCachingKey();
        if (key == null) {
            return OCInclusionContextImpl.createNewContext(configuration, kind, file, false);
        }
        return OCInclusionContextImpl.cacheOrGet(((InitialPlainAndPchContexts)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).switches2plainContext, key, () -> {
            OCInclusionContextImpl result = OCInclusionContextImpl.createNewContext(configuration, kind, file, true);
            result.myNameScope = NAME_SCOPE_INTERNATOR.intern(result.myNameScope);
            return result;
        });
    }

    @NotNull
    static OCInclusionContextImpl initialPCHContextWithoutRoot(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        CompilerSettingsKey key = configuration.getCompilerSettings(kind, virtualFile).getCachingKey();
        if (key == null || !kind.supportsPrecompiledHeaders() || virtualFile == null || OCInclusionContext.isPrecompiledHeader(virtualFile, configuration)) {
            return OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
        }
        return OCInclusionContextImpl.cacheOrGet(((InitialPlainAndPchContexts)OCInclusionContextImpl.INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)configuration)).switches2PCHContext, key, () -> {
            OCInclusionContextImpl initial = OCInclusionContextImpl.initialContextWithoutRoot(configuration, kind, file);
            List<OCFile> precompiledHeaders = OCInclusionContextImpl.getPrecompiledHeaders(configuration, kind, virtualFile);
            if (precompiledHeaders.isEmpty()) {
                return initial;
            }
            OCInclusionContextImpl ctx = initial.derive(file);
            for (OCFile pch : precompiledHeaders) {
                ctx.preprocessInclude(pch, true);
            }
            ctx.setRootFile(null);
            ctx.setPrecompiledHeaders(precompiledHeaders);
            ctx.myNameScope = NAME_SCOPE_INTERNATOR.intern(ctx.myNameScope);
            return ctx;
        });
    }

    @NotNull
    private static OCInclusionContextImpl createNewContext(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind, @NotNull PsiFile file, boolean initFromCompilerSettings) {
        OCInclusionContextImpl result = new OCInclusionContextImpl(configuration, configuration.getProject(), kind);
        result.initContext(file, initFromCompilerSettings ? configuration : null);
        return result;
    }

    private static <T, R> R cacheOrGet(@NotNull Map<T, R> map2, @NotNull T key, @NotNull Supplier<? extends R> mappingFunction) {
        R context = map2.get(key);
        if (context != null) {
            return context;
        }
        R newContext = mappingFunction.get();
        context = map2.putIfAbsent(key, newContext);
        return context != null ? context : newContext;
    }

    private void initContext(@NotNull PsiFile sourceFile, @Nullable OCResolveConfiguration configuration) {
        assert (this.myParentContext == null) : "initContext is supposed to be called on a root context.";
        OCLanguageKind languageKind = this.getLanguageKind();
        this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, OCCompilerMacros.PREDEFINED_MACROS));
        if (configuration != null) {
            VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(sourceFile);
            OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, vFile);
            this.mySubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, compilerSettings.getPreprocessorDefines()));
            this.myCompilerFeatures.putAll(compilerSettings.getCompilerFeatures());
        }
        this.myOverriddenSubstitutions.putAll(OCInclusionContextImpl.getSubstitutions(languageKind, sourceFile, "#define __OSX_AVAILABLE_BUT_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)           __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_BUT_DEPRECATED_MSG(_macIntro, _macDep, _iosIntro, _iosDep, _msg) __CIDR_OSX_AVAILABLE_BUT_DEPRECATED_IMPL(_macIntro, _macDep, _iosIntro, _iosDep)\n#define __OSX_AVAILABLE_STARTING(mac, ios) __CIDR_OSX_AVAILABLE_STARTING_IMPL(mac, ios)\n#define CF_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep, ...) __CIDR_OSX_DEPRECATED(_macIntro, _macDep, _iosIntro, _iosDep)\n#define CF_DEPRECATED_MAC(_macIntro, _macDep, ...)                 __CIDR_OSX_DEPRECATED(_macIntro, _macDep, NA,        NA)\n#define CF_DEPRECATED_IOS(_iosIntro, _iosDep, ...)                 __CIDR_OSX_DEPRECATED(NA,        NA,      _iosIntro, _iosDep)\n#define CF_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define CF_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define CF_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define CF_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_AVAILABLE(mac, ios)       __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_AVAILABLE_MAC(mac)        __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_AVAILABLE_IOS(ios)        __CIDR_OSX_AVAILABLE(NA,  ios)\n#define NS_CLASS_AVAILABLE(mac, ios) __CIDR_OSX_AVAILABLE(mac, ios)\n#define NS_CLASS_AVAILABLE_MAC(mac)  __CIDR_OSX_AVAILABLE(mac, NA) \n#define NS_CLASS_AVAILABLE_IOS(ios)  __CIDR_OSX_AVAILABLE(NA,  ios)\n#define __CF_NAMED_ENUM(_type, _name) __attribute__((NS_ENUM_MACRO)) enum _name : _type _name; enum __attribute__((NS_ENUM)) _name : _type\n#define __CF_ANON_ENUM(_type) enum __attribute__((NS_ENUM)) : _type\n\n#define NS_OPTIONS(_type, _name) __attribute__((NS_OPTIONS_MACRO)) enum _name : _type _name; enum __attribute__((NS_OPTIONS)) _name : _type\n"));
        this.myOverriddenSubstitutions.trimToSize();
    }

    private static Map<String, OCMacroSymbol> getSubstitutions(@NotNull OCLanguageKind languageKind, @NotNull PsiFile sourceFile, @NotNull String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Collections.emptyMap();
        }
        Project project2 = sourceFile.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        THashMap<String, OCMacroSymbol> cached = (THashMap<String, OCMacroSymbol>)cache.get(text);
        if (cached == null) {
            OCInclusionContextImpl context = (OCInclusionContextImpl)OCInclusionContext.empty(languageKind, sourceFile);
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(context, null);
            lexer.start((CharSequence)new MergingCharSequence((CharSequence)"\n", (CharSequence)text));
            while (lexer.getTokenType() != null) {
                lexer.advance();
            }
            THashMap<String, OCMacroSymbol> substitutions = context.mySubstitutions;
            substitutions.compact();
            cached = substitutions;
            cache.putIfAbsent(text, cached);
        }
        return cached;
    }

    private boolean conformsToByIncludes(@NotNull FileSymbolTable table) {
        Boolean cached;
        Map<FileSymbolTable, Boolean> resolveCache2 = this.getSymbolTablesConformingCache();
        Boolean bl = cached = resolveCache2 != null ? resolveCache2.get(table) : null;
        if (cached != null) {
            return cached;
        }
        boolean conforms = table.processIncludes((Processor<? super OCSymbol>)((Processor)symbol -> {
            if (!(symbol instanceof OCIncludeSymbol)) {
                return true;
            }
            OCIncludeSymbol includeSymbol = (OCIncludeSymbol)symbol;
            VirtualFile targetFile = includeSymbol.getTargetFile();
            if (targetFile instanceof LightVirtualFileBase) {
                return true;
            }
            VirtualFile owner2 = table.getContainingFile();
            OCIncludeSymbol.IncludePath path = includeSymbol.getIncludePath();
            VirtualFile resolved = this.resolvePath(path, owner2, includeSymbol.isNext(), false);
            return Comparing.equal((Object)targetFile, (Object)resolved);
        }));
        if (resolveCache2 != null) {
            resolveCache2.put(table, conforms);
        }
        return conforms;
    }

    @Override
    public int getInclusionLevel() {
        return this.myInclusionLevel;
    }

    @Override
    @Nullable
    public OCImmutableInclusionContext getParent() {
        return this.myParentContext;
    }

    @Override
    public void setPrecompiledHeaders(@NotNull List<OCFile> precompiledHeader) {
        this.myPrecompiledHeaders = precompiledHeader.toArray(OCFile.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public List<OCFile> getPrecompiledHeaders() {
        Object[] precompiledHeaders = this.myPrecompiledHeaders;
        if (!ArrayUtil.isEmpty((Object[])precompiledHeaders)) {
            return ContainerUtil.immutableList((Object[])precompiledHeaders);
        }
        return this.myParentContext == null ? Collections.emptyList() : this.myParentContext.getPrecompiledHeaders();
    }

    @Override
    public boolean hasRootFile() {
        return this.myRootFile != null;
    }

    @Override
    @NotNull
    public PsiFile getRootFile() {
        if (this.myRootFile == null) {
            OCLog.LOG.error("No root file");
        }
        return this.myRootFile;
    }

    @Override
    public OCInclusionContext setRootFile(@Nullable PsiFile file) {
        if (this.myRootFile != null && file != null) {
            throw new IllegalStateException("Trying to change root file for inclusion context with existing root file");
        }
        this.myRootFile = file;
        return this;
    }

    @Nullable
    static OCImmutableInclusionContext findInCachedPCHPrecompiledContexts(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header) {
        InitialPlainAndPchContexts initialContexts = (InitialPlainAndPchContexts)INITIAL_PLAIN_AND_PCH_CONTEXTS_KEY.getValue((UserDataHolder)config);
        Collection values = initialContexts.switches2PCHContext.values();
        OCImmutableInclusionContext bestContext = null;
        for (OCImmutableInclusionContext each : values) {
            OCLanguageKind eachContextLang = each.getLanguageKind();
            assert (eachContextLang.supportsPrecompiledHeaders());
            if (!each.isProcessed(header)) continue;
            assert (eachContextLang instanceof CLanguageKind);
            if (bestContext != null && bestContext.getLanguageKind() != CLanguageKind.min((CLanguageKind)eachContextLang, (CLanguageKind)bestContext.getLanguageKind())) continue;
            bestContext = each;
        }
        return bestContext;
    }

    @Nullable
    private Map<FileSymbolTable, Boolean> getSymbolTablesConformingCache() {
        if (this.myConfiguration == null) {
            return null;
        }
        return (Map)INCLUDE_RESOLVE_CACHE.getValue((UserDataHolder)this.myConfiguration);
    }

    @Override
    @Nullable
    public <T> T getCompilerFeature(@NotNull OCCompilerFeatures.Type<T> feature) {
        Object result = this.myCompilerFeatures.get(feature);
        if (result == null) {
            OCInclusionContextImpl topMost = this;
            while (topMost.myParentContext != null) {
                topMost = topMost.myParentContext;
            }
            result = feature.compute(topMost);
            if (result == null) {
                result = NULL_VALUE;
            }
            this.myCompilerFeatures.putIfAbsent(feature, result);
        }
        return (T)(result == NULL_VALUE ? null : result);
    }

    @Override
    @NotNull
    public OCParsingNameScope getNameScope() {
        return this.myNameScope;
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive() {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive(@NotNull PsiFile file) {
        if (this.myRootFile != null) {
            throw new IllegalStateException("Deriving from context with existing root file. Use 'derive()' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, file, this.myNameScope.copy(), true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl derive(@NotNull OCParsingNameScope nameScope) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, nameScope, true);
    }

    @Override
    @NotNull
    public OCInclusionContextImpl deriveButDontCopyTypes(boolean notifyLocalDefinitions) {
        if (this.myRootFile == null) {
            throw new IllegalStateException("Deriving from context without root file. Use 'derive(PsiFile)' instead");
        }
        return new OCInclusionContextImpl(this.myConfiguration, this.myProject, this, this.myRootFile, this.myNameScope, notifyLocalDefinitions);
    }

    @Override
    public void define(@NotNull OCMacroSymbol def) {
        String name2 = def.getName();
        OCMacroSymbol overridden = (OCMacroSymbol)this.myOverriddenSubstitutions.get((Object)name2);
        if (overridden != null) {
            if (def.getContainingFile() != null && ApplicationManager.getApplication().isUnitTestMode()) {
                int defNum = def.getParameterNames().size();
                int ovNum = overridden.getParameterNames().size();
                boolean defVar = def.isVararg();
                boolean ovVar = overridden.isVararg();
                OCLog.LOG.assertTrue(defNum == ovNum, (Object)(def.getName() + ": overridden with " + ovNum + " params instead of " + defNum));
                OCLog.LOG.assertTrue(defVar == ovVar, (Object)(def.getName() + ": overridden with vararg=" + ovVar + " instead of " + defVar));
            }
            def = overridden;
        }
        this.revealDefinition(name2);
        this.mySubstitutions.put((Object)name2, (Object)def);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.define(name2, def);
        }
    }

    @Override
    public void define(String def, String content) {
        this.define(new OCMacroSymbol(null, 0L, def, OCImmutableList.emptyList(), content));
    }

    @Override
    public void undef(String name2) {
        this.hideDefinition(name2);
        this.mySubstitutions.remove((Object)name2);
        if (this.myChangeBuilder != null) {
            this.myChangeBuilder.undef(name2);
        }
    }

    @Override
    public void hideDefinition(@NotNull String name2) {
        this.myUndefList.add(name2);
    }

    @Override
    public void revealDefinition(@NotNull String name2) {
        this.myUndefList.remove(name2);
    }

    @Override
    public boolean isDefined(@Nullable String name2) {
        return this.getDefinition(name2, OCImmutableInclusionContext.SignaturePart.HAS_DEFINITION) != null;
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id) {
        return this.getDefinition(id, OCImmutableInclusionContext.SignaturePart.EXACT_DEFINITION);
    }

    private void enterConformanceCheckMode() {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.enterConformanceCheckMode();
        }
        if (this.myParentContext != null) {
            this.myParentContext.enterConformanceCheckMode();
        }
    }

    private void exitConformanceCheckMode(boolean commit2) {
        if (this.mySignatureBuilder != null) {
            this.mySignatureBuilder.exitConformanceCheckMode(commit2);
        }
        if (this.myParentContext != null) {
            this.myParentContext.exitConformanceCheckMode(commit2);
        }
    }

    @Override
    @Nullable
    public OCMacroSymbol getDefinition(@Nullable String id, @NotNull OCImmutableInclusionContext.SignaturePart sp) {
        OCMacroSymbol answer;
        boolean notify;
        if (id == null) {
            return null;
        }
        boolean bl = notify = sp != OCImmutableInclusionContext.SignaturePart.NO;
        if (this.myUndefList.contains(id)) {
            answer = null;
            notify = this.myNotifyLocalDefinitions;
        } else {
            OCMacroSymbol local = (OCMacroSymbol)this.mySubstitutions.get((Object)id);
            if (local != null) {
                answer = local;
                notify = this.myNotifyLocalDefinitions;
            } else {
                OCMacroSymbol oCMacroSymbol = answer = this.myParentContext != null ? this.myParentContext.getDefinition(id, sp) : null;
            }
        }
        if (notify && this.mySignatureBuilder != null) {
            switch (sp) {
                case HAS_DEFINITION: {
                    this.mySignatureBuilder.setDefined(id, answer != null);
                    break;
                }
                case EXACT_DEFINITION: {
                    if (answer == null) break;
                    this.mySignatureBuilder.setDefinition(id, answer);
                    break;
                }
            }
        }
        return answer;
    }

    @Override
    public boolean isProcessed(@Nullable VirtualFile file) {
        return file != null && (this.myProcessedFiles.contains(file) || this.myParentContext != null && this.myParentContext.isProcessed(file));
    }

    @Override
    @NotNull
    public final Set<VirtualFile> getProcessedFiles() {
        THashSet files = new THashSet();
        this.collectProcessedFile((Set<VirtualFile>)files);
        return Collections.unmodifiableSet(files);
    }

    private void collectProcessedFile(Set<VirtualFile> result) {
        if (this.myParentContext != null) {
            this.myParentContext.collectProcessedFile(result);
        }
        result.addAll(this.myProcessedFiles);
    }

    @Override
    public void setSignatureBuilder(@Nullable OCInclusionContext.SignatureBuilder signatureBuilder) {
        this.mySignatureBuilder = signatureBuilder;
    }

    @Override
    public void enterNamespace(@NotNull String name2) {
        this.myCurrentNamespace.add(name2);
    }

    @Override
    public void exitNamespace() {
        if (!this.myCurrentNamespace.isEmpty()) {
            this.myCurrentNamespace.remove(this.myCurrentNamespace.size() - 1);
        }
    }

    @Override
    @NotNull
    public List<String> getCurrentNamespace() {
        ArrayList<String> result = new ArrayList<String>(this.myCurrentNamespace.size());
        this.gatherCurrentNamespace(result);
        return result;
    }

    private void gatherCurrentNamespace(@NotNull List<String> result) {
        if (this.myParentContext != null) {
            this.myParentContext.gatherCurrentNamespace(result);
        }
        result.addAll(this.myCurrentNamespace);
    }

    @Override
    @Nullable
    public VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull VirtualFile contextFile, boolean isIncludeNext) {
        return this.resolvePath(path, contextFile, isIncludeNext, true);
    }

    @Nullable
    private VirtualFile resolvePath(@NotNull OCIncludeSymbol.IncludePath path, @NotNull VirtualFile contextFile, boolean isIncludeNext, boolean notify) {
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(this.getRootAndConfiguration(), contextFile, (VirtualFile)(isIncludeNext ? contextFile : null), path, this.getProject(), (Ref<VirtualFile>)result);
        VirtualFile resolved = (VirtualFile)result.get();
        if (notify && this.myResolvePathListener != null) {
            this.myResolvePathListener.resolve(path, isIncludeNext, resolved);
        }
        return resolved;
    }

    @NotNull
    private OCResolveRootAndConfiguration getRootAndConfiguration() {
        return new OCResolveRootAndConfiguration(this.myConfiguration, this.myLanguageKind, OCInclusionContextUtil.getVirtualFile(this.myRootFile));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public boolean reserveInclude(@NotNull VirtualFile file, boolean once) {
        if (file.isValid()) {
            String includeId = OCInclusionContextUtil.inclusionId(file);
            if (once && this.isDefined(includeId)) {
                return false;
            }
            String pragmaOnceId = OCInclusionContextUtil.pragmaOnceId(file);
            if (this.isDefined(pragmaOnceId)) {
                return false;
            }
            this.define(OCMacroSymbol.inclusionGuard(includeId));
        }
        return true;
    }

    @Override
    public void preprocessContextOf(@Nullable PsiFile root, @Nullable VirtualFile breakOn) {
        this.preprocessInclude(root, true, breakOn, this.myInclusionLevel);
    }

    @Override
    public void preprocessInclude(@Nullable PsiFile file, boolean once) {
        this.preprocessInclude(file, once, null, this.myInclusionLevel);
    }

    @Override
    public boolean preprocessInclude(@Nullable PsiFile file, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        if (file == null) {
            return true;
        }
        VirtualFile vFile = OCInclusionContextUtil.getVirtualFile(file);
        if (vFile == null) {
            return true;
        }
        return this.preprocessInclude(vFile, once, breakOn, inclusionLevel);
    }

    public boolean preprocessInclude(@NotNull VirtualFile vFile, boolean once, @Nullable VirtualFile breakOn, int inclusionLevel) {
        if (inclusionLevel >= OCInclusionContext.getMaxInclusionLevel(null)) {
            return true;
        }
        if (!this.reserveInclude(vFile, once)) {
            return true;
        }
        this.addProcessedFile(vFile);
        FileSymbolTable table = FileSymbolTable.forFile(vFile, (OCInclusionContext)this);
        if (table != null && OCCodeInsightUtil.isPreProcessable(vFile, this.getProject())) {
            return this.preprocessFile(vFile, breakOn, inclusionLevel, -1, -1, table.getContents(), null) != null;
        }
        return true;
    }

    @Override
    @Contract(value="_, null, _, _, _, _, _ -> !null")
    public OCInclusionContext preprocessFile(@Nullable VirtualFile vFile, @Nullable VirtualFile breakOn, int inclusionLevel, int afterOffset, int beforeOffset, @NotNull List<OCSymbol> symbols, @Nullable OCContextChangeSet changeSet) {
        class Builder
        implements Processor<OCSymbol> {
            @NotNull
            private OCParsingNameScope myNameScope;
            @Nullable
            private final OCContextChangeBuilder myContextChangeBuilder;
            private boolean wasTruncated;
            final /* synthetic */ int val$afterOffset;
            final /* synthetic */ int val$beforeOffset;
            final /* synthetic */ VirtualFile val$vFile;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ int val$inclusionLevel;
            final /* synthetic */ OCContextChangeSet val$changeSet;

            Builder(@Nullable OCParsingNameScope nameScope, OCContextChangeBuilder builder) {
                this.val$afterOffset = n;
                this.val$beforeOffset = n2;
                this.val$vFile = virtualFile;
                this.val$breakOn = virtualFile2;
                this.val$inclusionLevel = n3;
                this.val$changeSet = oCContextChangeSet;
                this.myNameScope = nameScope;
                this.myContextChangeBuilder = builder;
            }

            public boolean wasTruncated() {
                return this.wasTruncated;
            }

            @NotNull
            public OCParsingNameScope getNameScope() {
                return this.myNameScope;
            }

            public boolean process(OCSymbol symbol) {
                if (OCInclusionContextImpl.this.myProcessingListener != null) {
                    OCInclusionContextImpl.this.myProcessingListener.process((Object)symbol);
                }
                OCContextChangeBuilder changeBuilder = this.myContextChangeBuilder;
                if (symbol instanceof OCModuleImportSymbol) {
                    OCModuleImportSymbol importSymbol = (OCModuleImportSymbol)symbol;
                    Processor processor2 = header -> this.processFileInclude((VirtualFile)header, true, importSymbol.getEndOffset());
                    if (!OCModuleResolver.processModuleImports(OCInclusionContextImpl.this, importSymbol.getNameParts(), (Processor<VirtualFile>)processor2)) {
                        return false;
                    }
                } else if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    VirtualFile targetFile = include.getTargetFile();
                    include.enterNamespace(OCInclusionContextImpl.this);
                    if (!this.processFileInclude(targetFile, include.isOnce(), include.getEndOffset())) {
                        return false;
                    }
                    include.exitNamespace(OCInclusionContextImpl.this);
                } else if (symbol instanceof OCMacroSymbol) {
                    OCInclusionContextImpl.this.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    OCInclusionContextImpl.this.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    OCParsingNameScope resultNameScope = this.myNameScope;
                    if (symbol instanceof OCNamespaceSymbol) {
                        OCSymbol lastMember;
                        boolean interrupted;
                        OCParsingNameScope inner;
                        OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                        List<OCSymbol> members = namespaceSymbol.getMembersList();
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                            changeBuilder = null;
                        }
                        if (this.val$afterOffset != -1 && this.val$afterOffset > symbol.getOffset()) {
                            inner = this.myNameScope;
                        } else {
                            inner = this.myNameScope.defineNamespace(symbol.getName());
                            if (symbol instanceof OCStructSymbol) {
                                for (OCTypeParameterSymbol templateParam : ((OCStructSymbol)symbol).getTemplateParameters()) {
                                    if (templateParam instanceof OCTypeParameterTypeSymbol) {
                                        inner.defineType(templateParam.getName(), true);
                                        continue;
                                    }
                                    if (!(templateParam instanceof OCTypeParameterValueSymbol)) continue;
                                    inner.defineValue(templateParam.getName(), false);
                                }
                            }
                        }
                        OCInclusionContextImpl.this.enterNamespace(namespaceSymbol.getName());
                        Builder innerProcessor = new Builder(inner, null);
                        boolean bl = interrupted = !namespaceSymbol.processMembersAndUsings(innerProcessor, this.val$afterOffset, this.val$beforeOffset);
                        if (!interrupted) {
                            OCInclusionContextImpl.this.exitNamespace();
                        }
                        OCSymbol oCSymbol = lastMember = members != null ? (OCSymbol)ContainerUtil.getLastItem(members) : null;
                        if (this.val$beforeOffset != -1 && lastMember != null && this.val$beforeOffset <= lastMember.getOffset() || innerProcessor.wasTruncated()) {
                            this.wasTruncated = true;
                            resultNameScope = innerProcessor.getNameScope();
                        } else {
                            OCParsingNameScope scope = innerProcessor.getNameScope();
                            resultNameScope = scope.getParent();
                            if (resultNameScope == null) {
                                OCLog.LOG.error("no parent scope found for '" + symbol.getName() + "' (current scope is '" + scope + "')");
                            }
                        }
                    }
                    if (symbol instanceof OCUsingSymbol) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                            this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        } else {
                            this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                        }
                    } else if (kind.isType()) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if (kind.isClass()) {
                            if (kind == OCSymbolKind.PROTOCOL) {
                                this.myNameScope.defineProtocol(symbol.getName());
                            } else {
                                this.myNameScope.defineInterface(symbol.getName());
                            }
                            if (symbol instanceof OCClassSymbol) {
                                ((OCClassSymbol)symbol).processMembers((String)null, new OCCommonProcessors.SelfAdapterProcessor(this));
                            }
                        } else if (kind.isClassOrTypedef() || OCInclusionContextImpl.this.myLanguageKind.isCpp()) {
                            boolean isTemplate = symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isTemplateSymbol();
                            boolean isFriendClass = symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isFriend();
                            this.myNameScope.defineType(symbol.getName(), isTemplate, isFriendClass);
                        }
                        if (kind == OCSymbolKind.ENUM && symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isEnumClass()) {
                            ((OCStructSymbol)symbol).processFields((Processor<? super OCDeclaratorSymbol>)((Processor)symbol1 -> {
                                this.myNameScope.defineValue(symbol1.getName(), false);
                                return true;
                            }));
                        }
                    } else if (symbol instanceof OCInstanceVariableSymbol) {
                        this.myNameScope.defineValue(symbol.getName(), false);
                    } else if (symbol instanceof OCFunctionSymbol && !symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCFunctionSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).getQualifiedName().getQualifier() == null) {
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        this.myNameScope.defineValue(symbol.getName(), ((OCDeclaratorSymbol)symbol).isTemplateSymbol());
                    } else if (symbol instanceof OCNamespaceAliasSymbol) {
                        OCSymbolReference namespace;
                        if (changeBuilder != null) {
                            changeBuilder.addSymbol(symbol);
                        }
                        if ((namespace = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference()) != null && namespace.getQualifiedName().getName() != null) {
                            this.myNameScope.defineNamespaceAlias(symbol.getName(), namespace.getQualifiedName().flatten());
                        }
                    }
                    this.myNameScope = resultNameScope;
                }
                return true;
            }

            protected boolean processFileInclude(@Nullable VirtualFile targetFile, boolean once, int endOffset) {
                assert (this.val$vFile != null);
                if (targetFile != null && targetFile.isValid() && OCCodeInsightUtil.isPreProcessable(targetFile, OCInclusionContextImpl.this.getProject())) {
                    if (targetFile.equals(this.val$breakOn)) {
                        return false;
                    }
                    if (!OCInclusionContextImpl.this.preprocessInclude(targetFile, once, this.val$breakOn, this.val$inclusionLevel + 1, endOffset, this.val$changeSet)) {
                        return false;
                    }
                    OCImportGraph.addHeaderIncluder(OCInclusionContextImpl.this.getProject(), targetFile, this.val$vFile);
                }
                return true;
            }
        }
        Builder builder = new Builder(this.myNameScope, this.myChangeBuilder);
        if (OCResolveUtil.processSymbolsFromList(builder, symbols, afterOffset, beforeOffset)) {
            this.myNameScope = builder.getNameScope();
            return this;
        }
        return null;
    }

    @Override
    public boolean preprocessInclude(@NotNull VirtualFile file, boolean once, @Nullable VirtualFile breakOn, int includeLevel, int offsetAfterInclude, @Nullable OCContextChangeSet changeSet) {
        boolean result;
        OCContextChangeBuilderImpl builder = null;
        OCContextChange change = null;
        if (changeSet != null && (change = changeSet.getChange(offsetAfterInclude)) == null) {
            builder = new OCContextChangeBuilderImpl(offsetAfterInclude);
            this.setChangeBuilder(builder);
        }
        if (change == null) {
            result = this.preprocessInclude(file, once, breakOn, includeLevel);
        } else {
            change.apply(this);
            result = true;
        }
        if (builder != null && !this.isProcessed(OCInclusionContextUtil.getVirtualFile(this.myRootFile))) {
            changeSet.setChange(offsetAfterInclude, builder);
            this.setChangeBuilder(null);
        }
        return result;
    }

    public DeepEqual.Equality<OCInclusionContextImpl> equality() {
        return new DeepEqual.Equality<OCInclusionContextImpl>(){

            @Override
            public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCInclusionContextImpl first, @NotNull OCInclusionContextImpl second) {
                if (first.myLanguageKind != second.myLanguageKind) {
                    return false;
                }
                if (first.myInclusionLevel != second.myInclusionLevel) {
                    return false;
                }
                if (!Comparing.equal((Object)first.myRootFile, (Object)second.myRootFile)) {
                    return false;
                }
                if (first.myNotifyLocalDefinitions != second.myNotifyLocalDefinitions) {
                    return false;
                }
                if (first.myConfiguration != second.myConfiguration) {
                    return false;
                }
                if (!first.myUndefList.equals(second.myUndefList)) {
                    return false;
                }
                if (!first.myProcessedFiles.equals(second.myProcessedFiles)) {
                    return false;
                }
                if (!Comparing.equal((Object)first.mySignatureBuilder, (Object)second.mySignatureBuilder)) {
                    return false;
                }
                if (!c.equalObjects(first.myParentContext, second.myParentContext)) {
                    return false;
                }
                if (!c.equalMaps((Map)first.mySubstitutions, (Map)second.mySubstitutions)) {
                    return false;
                }
                return c.equalObjects(first.myNameScope, second.myNameScope);
            }
        };
    }

    static final class NameScopeInternator {
        private final ConcurrentMap<OCParsingNameScope, OCParsingNameScope> internary = ContainerUtil.createConcurrentWeakKeyWeakValueMap(OCParsingNameScope.HASHING_STRATEGY);

        NameScopeInternator() {
        }

        @NotNull
        OCParsingNameScope intern(@NotNull OCParsingNameScope nameScope) {
            return this.internary.computeIfAbsent(nameScope, Function.identity());
        }
    }

    static final class InitialPlainAndPchContexts {
        final ConcurrentMap<CompilerSettingsKey, OCInclusionContextImpl> switches2plainContext = ContainerUtil.newConcurrentMap();
        final ConcurrentMap<CompilerSettingsKey, OCInclusionContextImpl> switches2PCHContext = ContainerUtil.newConcurrentMap();

        InitialPlainAndPchContexts() {
        }
    }

    static class PCHCache {
        private final MultiMap<VirtualFile, OCResolveConfiguration> pch2configs = new MultiMap<VirtualFile, OCResolveConfiguration>(){

            @NotNull
            protected Collection<OCResolveConfiguration> createCollection() {
                return ContainerUtil.newLinkedHashSet();
            }
        };

        PCHCache(@NotNull Project project2) {
            OCWorkspace workspace = OCWorkspace.getInstance(project2);
            for (OCResolveConfiguration config : workspace.getConfigurations()) {
                for (VirtualFile pch : config.getAllPrecompiledHeaders()) {
                    this.pch2configs.putValue((Object)pch, (Object)config);
                }
            }
        }

        public Collection<OCResolveConfiguration> getConfigurations(@NotNull VirtualFile pch) {
            return Collections.unmodifiableCollection(this.pch2configs.get((Object)pch));
        }

        public boolean isPCH(@NotNull VirtualFile file) {
            return this.pch2configs.containsKey((Object)file);
        }
    }
}

