/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.modulemap.ModuleMapModules;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInclusionContextUtil {
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> FILE_ACTIVE_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"FILE_ACTIVE_CONFIGURATION_CACHE", file -> {
        final Project project2 = file.getProject();
        return CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

            public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                if (project2.isDefault()) {
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance(project2).getModificationTrackers();
                return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker(), tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }

            private OCResolveConfiguration inferConfiguration() {
                VirtualFile virtualFile;
                if (SymbolTableProvider.isSourceFile(file) && (virtualFile = OCInclusionContextUtil.getVirtualFile(file.getOriginalFile())) != null) {
                    return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file.getProject()).getConfiguration();
                }
                return null;
            }
        }, false);
    });
    public static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", p -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static boolean ourBuildHeaderSymbolsForAllConfigurations = Boolean.parseBoolean(System.getProperty("cidr.build.header.symbols.for.all.configurations"));

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configs).first;
    }

    @Nullable
    private static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs, @Nullable Ref<Integer> scoreRef) {
        OCResolveContextSettings settings = OCResolveContextSettings.getInstance(project2);
        Pair<OCResolveConfiguration, Integer> fromSettings = settings.findPriorityConfiguration(configs);
        OCResolveConfiguration result = (OCResolveConfiguration)fromSettings.first;
        int score = (Integer)fromSettings.second;
        if (result == null) {
            ++score;
            OCResolveConfiguration selectedByRun = OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration(project2);
            if (selectedByRun != null) {
                if (configs.contains(selectedByRun)) {
                    result = selectedByRun;
                } else {
                    ++score;
                    result = OCInclusionContextUtil.findClosestConfigByVariant(selectedByRun, configs);
                }
            }
        }
        if (scoreRef != null) {
            scoreRef.set((Object)score);
        }
        return result;
    }

    @Nullable
    private static OCResolveConfiguration findClosestConfigByVariant(@NotNull OCResolveConfiguration sample, @NotNull Collection<OCResolveConfiguration> configs) {
        OCVariant variant = sample.getVariant();
        if (variant == null) {
            return null;
        }
        for (OCResolveConfiguration config : configs) {
            if (!variant.equals(config.getVariant())) continue;
            return config;
        }
        return null;
    }

    @NotNull
    private static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs) {
        OCResolveConfiguration selectedConfiguration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configs, null);
        if (selectedConfiguration != null) {
            return Pair.create((Object)selectedConfiguration, (Object)true);
        }
        return Pair.create((Object)(configs.isEmpty() ? null : Collections.min(configs)), (Object)false);
    }

    @Nullable
    @Contract(value="null -> null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile vFile = file.getOriginalFile().getVirtualFile();
        return vFile != null ? vFile : (VirtualFile)file.getUserData(IndexingDataKeys.VIRTUAL_FILE);
    }

    @Nullable
    public static PsiFile findCachedPsiFile(@NotNull VirtualFile file, @NotNull Project project2) {
        if (!file.isValid()) {
            return null;
        }
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)project2).getFileManager();
        FileViewProvider pp = fileManager.findCachedViewProvider(file);
        return pp == null ? null : fileManager.findFile(file);
    }

    public static boolean isRoot(@NotNull PsiFile file) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile == null) {
            return false;
        }
        if (OCFileImpl.isSourceCodeFile(file.getName())) {
            return !OCWorkspace.getInstance(file.getProject()).getConfigurationsForFile(virtualFile).isEmpty();
        }
        return false;
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file) {
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile == null) {
            return false;
        }
        return OCInclusionContextUtil.isNeedToFindRoot(virtualFile, file.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file, @NotNull Project project2) {
        if (OCFileImpl.isSourceCodeFile(file.getName())) {
            return OCWorkspace.getInstance(project2).getConfigurationsForFile(file).isEmpty();
        }
        return !OCInclusionContext.isPrecompiledHeader(file, project2);
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Map cache = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        OCResolveRootAndConfiguration cached = (OCResolveRootAndConfiguration)cache.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCResolveRootAndConfiguration result = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            result = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project2);
        }
        if (result == null) {
            result = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, project2), virtualFile);
        }
        cache.put(virtualFile, result);
        ((OCInclusionContextListener)project2.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result);
        return result;
    }

    @NotNull
    public static OCParsedLanguageAndConfiguration getOrCalculateParsedLanguageAndConfiguration(@NotNull PsiFile file) {
        OCParsedLanguageAndConfiguration langAndConfig;
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = langAndConfig = file instanceof OCConfigurationOwner ? ((OCConfigurationOwner)file).getParsedLanguageAndConfiguration() : null;
        if (langAndConfig != null) {
            return langAndConfig;
        }
        OCImmutableInclusionContext context = OCInclusionContextUtil.headerContext(file);
        return new OCParsedLanguageAndConfiguration(context.getConfiguration(), context.getLanguageKind());
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project2) {
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(OCImportGraph.getAllHeaderRoots(project2, virtualHeaderFile));
        Collections.sort(roots, new VirtualFileComparator(project2, headerNameWithoutExtension));
        ArrayList<Pair> rootsThatMayMatchSelectedConfiguration = new ArrayList<Pair>();
        for (VirtualFile root : roots) {
            Ref scoreRef;
            Collection<OCResolveConfiguration> configs = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project2);
            if (OCInclusionContextUtil.findPreselectedConfiguration(project2, configs, (Ref<Integer>)(scoreRef = new Ref((Object)0))) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(Pair.create((Object)root, (Object)scoreRef.get()));
        }
        Collections.sort(rootsThatMayMatchSelectedConfiguration, (o1, o2) -> Comparing.compare((Comparable)((Comparable)o1.second), (Comparable)((Comparable)o2.second)));
        OCResolveRootAndConfiguration fallBack = null;
        HashSet<VirtualFile> visitedRoots = new HashSet<VirtualFile>(rootsThatMayMatchSelectedConfiguration.size());
        for (Pair info : rootsThatMayMatchSelectedConfiguration) {
            VirtualFile rootFile = (VirtualFile)info.first;
            visitedRoots.add(rootFile);
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, virtualHeaderFile, rootFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configurations, null);
            if (configuration != null) {
                return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, configuration, rootFile);
            }
            if (fallBack != null) continue;
            Pair<OCResolveConfiguration, Boolean> c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            fallBack = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, rootFile);
        }
        for (VirtualFile rootFile : roots) {
            if (visitedRoots.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            OCImportGraph.fillHeaderConfigurationsForRoot(project2, virtualHeaderFile, rootFile, configurations, null);
            Pair<OCResolveConfiguration, Boolean> c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private static OCResolveRootAndConfiguration createResolveRootAndConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, project2, false);
        return new OCResolveRootAndConfiguration(configuration, kind, rootFile);
    }

    @Nullable
    private static OCResolveConfiguration doGetPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCInclusionContextUtil.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project2)).first;
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project2);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project2);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map2, @Nullable K key) {
        if (key == null) {
            map2.clear();
        } else {
            map2.keySet().retainAll(Collections.singleton(key));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project2) {
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project2);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file) {
        OCImmutableInclusionContext cached;
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(null, file);
        }
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache = null;
        if (virtualFile != null && (cached = (OCImmutableInclusionContext)(cache = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2)).get(virtualFile)) != null) {
            return cached;
        }
        OCInclusionContext result = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        if (virtualFile != null) {
            cache.put(virtualFile, result);
        }
        return result;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file, @Nullable OCLanguageKind languageKind) {
        PsiFile original = OCInclusionContextUtil.getOriginalFile(file);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    public static PsiFile getOriginalFile(@Nullable PsiFile file) {
        PsiFile psiFile;
        PsiFile physical;
        if (file == null) {
            return null;
        }
        PsiFile original = file.getOriginalFile();
        if (!(original instanceof OCFile)) {
            return null;
        }
        if (original.isPhysical()) {
            return file;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        PsiFile psiFile2 = psiFile = physical != null ? physical.getContainingFile() : null;
        if (psiFile != null) {
            return psiFile;
        }
        return null;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        OCResolveConfiguration config;
        OCResolveRootAndConfiguration rootAndConfiguration;
        VirtualFile rootFile;
        OCFile importHolder;
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (virtualFile != null && OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2) && (importHolder = (OCFile)ObjectUtils.tryCast((rootFile = (rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2)).getRootFile()) != null && rootFile.isValid() ? PsiManager.getInstance((Project)project2).findFile(rootFile) : null, OCFile.class)) != null && !rootFile.equals(virtualFile) && (config = rootAndConfiguration.getConfiguration()) != null) {
            OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
            if (precompiledContext == null) {
                precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolder.getKind(), importHolder);
            } else {
                precompiledContext = precompiledContext.getParent();
                assert (precompiledContext != null && precompiledContext.getParent() == null);
            }
            OCInclusionContext result = precompiledContext.derive(importHolder);
            result.preprocessContextOf(importHolder, virtualFile);
            return result;
        }
        return OCInclusionContextUtil.sourceFileContext((OCFile)original, kind);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull OCFile file, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        VirtualFile virtualFile;
        if (kindOrNullForDefault == null) {
            kindOrNullForDefault = file.getKind();
        }
        if ((virtualFile = OCInclusionContextUtil.getVirtualFile(file)) != null && (config = OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, file.getProject())) != null) {
            return OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file);
        }
        return OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file);
    }

    public static void resetUserSelectedConfigurations(@NotNull Project project2) {
        OCResolveContextSettings.getInstance(project2).resetConfigurationPriorities();
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        PsiFile contextFile;
        Project project2 = psiFile.getProject();
        if (config != null) {
            OCResolveContextSettings.getInstance(project2).setSelectedConfiguration(config);
        }
        if ((contextFile = FileContextUtil.getContextFile((PsiElement)psiFile)) != null) {
            psiFile = contextFile;
        }
        psiFile.putUserData(FILE_ACTIVE_CONFIGURATION_CACHE, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project2);
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            FileContentUtil.reparseFiles((Project)project2, Collections.singletonList(file), (boolean)false);
        }
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile contextFile = FileContextUtil.getContextFile((PsiElement)element);
        return contextFile == null ? null : (OCResolveConfiguration)((CachedValue)FILE_ACTIVE_CONFIGURATION_CACHE.getValue((UserDataHolder)contextFile)).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file, @NotNull Project project2) {
        return OCInclusionContextUtil.getActiveConfiguration(file == null ? null : PsiManager.getInstance((Project)project2).findFile(file));
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        VirtualFile root = OCInclusionContextUtil.getVirtualFile(file);
        if (root != null && file instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file)) {
            return OCImportGraph.getAllHeaderConfigurations((OCFile)file, progress);
        }
        return OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, file.getProject());
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> configOfPch = OCInclusionContext.getBuildConfigurationByPchFile(virtualFile, project2);
        if (!configOfPch.isEmpty()) {
            return configOfPch;
        }
        return OCWorkspace.getInstance(project2).getConfigurationsForFile(virtualFile);
    }

    @ApiStatus.Experimental
    public static void setBuildHeaderSymbolsForAllConfigurations(boolean buildHeaderSymbolsForAllConfigurations) {
        ourBuildHeaderSymbolsForAllConfigurations = buildHeaderSymbolsForAllConfigurations;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> result = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2);
        if (!result.isEmpty()) {
            return result;
        }
        Collection<OCResolveConfiguration> configurations = null;
        if (virtualFile != null) {
            configurations = OCInclusionContextUtil.getConfigurationsToIndexForHeaderFile(project2, virtualFile);
            if (ourBuildHeaderSymbolsForAllConfigurations && !configurations.isEmpty()) {
                return configurations;
            }
        }
        if (ContainerUtil.isEmpty(configurations)) {
            configurations = OCWorkspace.getInstance(project2).getConfigurations();
        }
        OCResolveConfiguration preselected = (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configurations).first;
        return ContainerUtil.createMaybeSingletonList((Object)preselected);
    }

    @NotNull
    public static Collection<VirtualFile> getHeaderFilesToBuildSymbols(@NotNull Project project2) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).keySet();
    }

    @NotNull
    private static Collection<OCResolveConfiguration> getConfigurationsToIndexForHeaderFile(@NotNull Project project2, @NotNull VirtualFile file) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).get((Object)file);
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    private static String fileGuard(VirtualFile vFile, String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project2)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2)).get(virtualFile);
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project2, String headerNameWithoutExtension) {
            this.myProject = project2;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result = Comparing.compare((boolean)OCInclusionContext.isPrecompiledHeader(root1, this.myProject), (boolean)OCInclusionContext.isPrecompiledHeader(root2, this.myProject));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile(root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile(root2.getName()));
            if (result != 0) {
                return -result;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result != 0) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }
    }

    private static class HeaderFilesToBuildSymbolsProvider
    implements CachedValueProvider<MultiMap<VirtualFile, OCResolveConfiguration>> {
        @NotNull
        private static final Key<CachedValue<MultiMap<VirtualFile, OCResolveConfiguration>>> KEY = Key.create((String)"LIBRARY_FILES_KEY");
        @NotNull
        private final Project myProject;

        private HeaderFilesToBuildSymbolsProvider(@NotNull Project project2) {
            this.myProject = project2;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<VirtualFile, OCResolveConfiguration>> compute() {
            boolean skipFrameworks = !PlatformUtils.isAppCode();
            MultiMap headerConfigs = MultiMap.createSet();
            THashMap scannedRootHeaders = ContainerUtil.newTroveMap();
            THashSet alreadySeenRootInConfig = ContainerUtil.newTroveSet();
            for (OCResolveConfiguration config : OCWorkspace.getInstance(this.myProject).getConfigurations()) {
                alreadySeenRootInConfig.clear();
                ((Stream)config.getAllCompilerSettings().sequential()).forEach(arg_0 -> this.lambda$compute$1((Set)alreadySeenRootInConfig, (Map)scannedRootHeaders, headerConfigs, config, skipFrameworks, arg_0));
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(this.myProject).getModificationTrackers();
            return CachedValueProvider.Result.create((Object)(headerConfigs.isEmpty() ? MultiMap.empty() : headerConfigs), (Object[])new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }

        private void processHeadersInRoot(HeadersSearchRoot eachRoot, final Consumer<? super VirtualFile> processor2) {
            eachRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    ProgressManager.checkCanceled();
                    List<VirtualFile> publicHeadersToInclude = framework.getPublicHeadersToInclude();
                    if (publicHeadersToInclude.isEmpty()) {
                        return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                    }
                    publicHeadersToInclude.forEach(processor2);
                    return HeadersSearchRootProcessor.FrameworkResult.SKIP_CHILDREN;
                }

                @Override
                public boolean process(@NotNull VirtualFile file) {
                    ProgressManager.checkCanceled();
                    if (!file.isDirectory()) {
                        processor2.accept(file);
                    }
                    return true;
                }
            });
            ModuleMapModules modules = ModuleMapManager.getInstance(this.myProject).getModules(null, eachRoot);
            ModuleMapResolveService moduleMapResolve = ModuleMapResolveService.getInstance(this.myProject);
            for (ModuleMapModuleSymbol module2 : modules.getModules()) {
                if (!moduleMapResolve.isModuleAllowed(module2.getQualifiedName())) continue;
                ProgressManager.checkCanceled();
                moduleMapResolve.getIncludeHeaders(module2, null).forEach(processor2);
            }
        }

        static MultiMap<VirtualFile, OCResolveConfiguration> get(@NotNull Project project2) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
            return (MultiMap)cachedValuesManager.getCachedValue((UserDataHolder)project2, KEY, (CachedValueProvider)new HeaderFilesToBuildSymbolsProvider(project2), false);
        }

        private /* synthetic */ void lambda$compute$1(Set alreadySeenRootInConfig, Map scannedRootHeaders, MultiMap headerConfigs, OCResolveConfiguration config, boolean skipFrameworks, OCCompilerSettings settings) {
            if (settings.getCompilerKind() == OCCompilerKind.MSVC) {
                return;
            }
            for (HeadersSearchRoot eachRoot : settings.getHeadersSearchRoots().getAllRoots()) {
                if (!alreadySeenRootInConfig.add(eachRoot)) continue;
                if (scannedRootHeaders.containsKey((Object)eachRoot)) {
                    for (VirtualFile header : (Set)scannedRootHeaders.get((Object)eachRoot)) {
                        headerConfigs.putValue((Object)header, (Object)config);
                    }
                    continue;
                }
                if (skipFrameworks && eachRoot instanceof FrameworksSearchRoot) continue;
                THashSet headers = ContainerUtil.newTroveSet();
                this.processHeadersInRoot(eachRoot, arg_0 -> HeaderFilesToBuildSymbolsProvider.lambda$null$0((Set)headers, headerConfigs, config, arg_0));
                scannedRootHeaders.put(eachRoot, headers);
            }
        }

        private static /* synthetic */ void lambda$null$0(Set headers, MultiMap headerConfigs, OCResolveConfiguration config, VirtualFile header) {
            if (SymbolTableProvider.isSourceFile(header) && headers.add(header)) {
                headerConfigs.putValue((Object)header, (Object)config);
            }
        }
    }
}

