/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParsingNameScope
implements DeepEqual.Equality<OCParsingNameScope> {
    private static final String LOCAL_SCOPE_NAME = "$LOCAL_SCOPE$";
    public static final String GLOBAL_SCOPE_NAME = "";
    private static final int LAST_COMPONENT_INDEX = 0x3FFFFFFF;
    @NotNull
    private final String myName;
    @NotNull
    private final THashSet<String> myProtocolNames;
    @NotNull
    private final THashMap<String, Kind> myNameKinds;
    @NotNull
    private final THashMap<String, OCParsingNameScope> myInnerScopes;
    @Nullable
    private List<OCParsingNameScope> myNamespaceUsings;
    @Nullable
    private final OCParsingNameScope myParent;
    @Nullable
    private OCParsingNameScope myDelegate;
    @Nullable
    private List<TemplateTypeParameter> myTemplateTypeParameters;
    @Nullable
    private List<String> myTemplateValueParameters;
    public static final TObjectHashingStrategy<OCParsingNameScope> HASHING_STRATEGY = new TObjectHashingStrategy<OCParsingNameScope>(){

        public boolean equals(OCParsingNameScope o1, OCParsingNameScope o2) {
            return DeepEqual.equalObjects(o1, o2);
        }

        public int computeHashCode(OCParsingNameScope scope) {
            int result = scope.myName.hashCode();
            result = 31 * result + scope.myNameKinds.size();
            result = 31 * result + scope.myProtocolNames.size();
            result = 31 * result + (scope.myNamespaceUsings != null ? scope.myNamespaceUsings.size() : 0);
            result = 31 * result + (scope.myParent != null ? scope.myParent.myName.hashCode() : 0);
            result = 31 * result + scope.myInnerScopes.size();
            return result;
        }
    };

    @Nullable
    public OCParsingNameScope getDelegate() {
        return this.myDelegate;
    }

    public OCParsingNameScope() {
        this(GLOBAL_SCOPE_NAME, null);
    }

    @NotNull
    public OCParsingNameScope copy() {
        return this.delegatingCopy();
    }

    @NotNull
    public OCParsingNameScope delegatingCopy() {
        OCParsingNameScope parent = this.getParent();
        OCParsingNameScope result = this.newScope(this.getName(), parent == null ? null : parent.delegatingCopy());
        result.myDelegate = this;
        return result;
    }

    @NotNull
    protected OCParsingNameScope newScope(@NotNull String name2, @Nullable OCParsingNameScope parentCopy) {
        return new OCParsingNameScope(name2, parentCopy);
    }

    @NotNull
    public OCParsingNameScope mergeToDelegate() {
        if (this.myDelegate == null) {
            return this;
        }
        this.myDelegate.myProtocolNames.addAll(this.myProtocolNames);
        this.myDelegate.myNameKinds.putAll(this.myNameKinds);
        this.myInnerScopes.forEachEntry((name2, scope) -> {
            OCParsingNameScope delegateScope = (OCParsingNameScope)this.myDelegate.myInnerScopes.get(name2);
            if (delegateScope != null) {
                delegateScope.merge((OCParsingNameScope)scope);
            } else {
                this.myDelegate.myInnerScopes.put(name2, scope);
            }
            return true;
        });
        this.myDelegate.putAllNamespaceUsings(this.myNamespaceUsings);
        return this.myDelegate;
    }

    private void merge(@NotNull OCParsingNameScope scope) {
        this.myProtocolNames.addAll(scope.myProtocolNames);
        this.myNameKinds.putAll(scope.myNameKinds);
        this.myInnerScopes.putAll(scope.myInnerScopes);
        this.putAllNamespaceUsings(scope.myNamespaceUsings);
    }

    private void putAllNamespaceUsings(@Nullable List<OCParsingNameScope> namespaceUsings) {
        if (namespaceUsings == null) {
            return;
        }
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>(namespaceUsings);
        } else {
            this.myNamespaceUsings.addAll(namespaceUsings);
        }
    }

    @NotNull
    private String getNiceName() {
        if (this.getName() == GLOBAL_SCOPE_NAME) {
            return "::";
        }
        if (this.getName() == LOCAL_SCOPE_NAME) {
            return "<local>";
        }
        return this.getName();
    }

    protected OCParsingNameScope(@NotNull String name2, @Nullable OCParsingNameScope parent) {
        this.myName = name2;
        this.myProtocolNames = new THashSet();
        this.myNameKinds = new THashMap();
        this.myInnerScopes = new THashMap();
        this.myParent = parent;
        if (parent != null) {
            OCParsingNameScope delegate;
            parent.myInnerScopes.put((Object)name2, (Object)this);
            if (parent.myDelegate != null && (delegate = (OCParsingNameScope)parent.myDelegate.myInnerScopes.get((Object)name2)) != null) {
                this.myDelegate = delegate;
            }
        }
    }

    public static Kind getTypeKind(boolean isTemplate) {
        return isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
    }

    public static boolean isTemplate(@Nullable Kind kind) {
        return kind == Kind.TEMPLATE_TYPE || kind == Kind.TEMPLATE_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.OBJC_INTERFACE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isCppType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isValue(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_VALUE || kind == Kind.TEMPLATE_VALUE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    @Nullable
    public OCParsingNameScope getParent() {
        return this.myParent;
    }

    public OCParsingNameScope dropAndGetParent() {
        if (this.myParent != null) {
            this.myParent.myInnerScopes.remove((Object)this.myName);
        }
        return this.myParent;
    }

    @NotNull
    public Collection<OCParsingNameScope> getInnerScopes() {
        return this.myInnerScopes.values();
    }

    @NotNull
    public Collection<String> getDefinedNames() {
        return this.myNameKinds.keySet();
    }

    @Nullable
    public Kind getKind(String qualifiedName) {
        return this.getKind(Collections.singletonList(qualifiedName));
    }

    @Nullable
    public Kind getKind(List<String> qualifiedName) {
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 1 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            return this.getKindInGlobal(qualifiedName, context);
        }
        return this.getKindWithParents(qualifiedName, 0, context);
    }

    @Nullable
    private Kind getKindTerminal(@NotNull String qualifiedName, @Nullable ResolveContext context) {
        Kind result = null;
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            result = (Kind)((Object)scope.myNameKinds.get((Object)qualifiedName));
            if (result == null && scope.myNamespaceUsings != null) {
                if (context == null) {
                    context = new ResolveContext();
                }
                if (context.shouldCheckAtOffset(scope, 0x3FFFFFFF)) {
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        Kind r = using.getKindTerminal(qualifiedName, context);
                        if (!OCParsingNameScope.isType(r) && !OCParsingNameScope.isValue(r)) continue;
                        result = r;
                        break;
                    }
                }
            }
            scope = scope.myDelegate;
        }
        return result;
    }

    public boolean isProtocol(@Nullable String name2) {
        return this.isProtocol(name2, true);
    }

    protected boolean isProtocol(@Nullable String name2, boolean shouldCheckDelegates) {
        return this.myProtocolNames.contains((Object)name2) || shouldCheckDelegates && this.myDelegate != null && this.myDelegate.isProtocol(name2, true) || this.myParent != null && this.myParent.isProtocol(name2, this.myDelegate == null);
    }

    @Nullable
    protected Kind getKind(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result = OCParsingNameScope.getKindIfDecltype(qualifiedName, offset, context);
        if (result != null) {
            return result;
        }
        if (qualifiedName.size() == 1) {
            if (this.myTemplateValueParameters != null && this.myTemplateValueParameters.contains(qualifiedName.get(0))) {
                return Kind.SIMPLE_VALUE;
            }
            if (this.myTemplateTypeParameters != null) {
                for (TemplateTypeParameter pair2 : this.myTemplateTypeParameters) {
                    if (!pair2.name.equals(qualifiedName.get(0))) continue;
                    return pair2.isTemplateTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
                }
            }
        }
        String namePart = qualifiedName.get(offset);
        if (qualifiedName.size() == offset + 1) {
            result = this.getKindTerminal(namePart, context);
        } else {
            OCParsingNameScope scope = this;
            while (result == null && scope != null) {
                OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)namePart);
                if (child != null && (result = child.getKind(qualifiedName, offset + 1, context)) == null) {
                    result = Kind.UNKNOWN;
                }
                if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                    boolean foundNonType = false;
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        result = using.getKindWithParents(qualifiedName, offset, context);
                        if (result == Kind.NON_TYPE) {
                            foundNonType = true;
                            continue;
                        }
                        if (result == null) continue;
                        break;
                    }
                    if (result == null && foundNonType) {
                        result = Kind.NON_TYPE;
                    }
                }
                scope = scope.myDelegate;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindWithParents(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result = this.getKind(qualifiedName, offset, context);
        if (this.myParent != null) {
            if (result == null) {
                return this.myParent.getKindWithParents(qualifiedName, offset, context);
            }
            if (result == Kind.NON_TYPE) {
                Kind parentResult = this.myParent.getKindWithParents(qualifiedName, offset, context);
                return parentResult != null ? parentResult : Kind.NON_TYPE;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindInGlobal(List<String> qualifiedName, ResolveContext context) {
        if (this.myParent != null) {
            return this.myParent.getKindInGlobal(qualifiedName, context);
        }
        if (qualifiedName.size() > 1) {
            return this.getKind(qualifiedName, 1, context);
        }
        return Kind.TEMPLATE_TYPE;
    }

    private static Kind getKindIfDecltype(List<String> qualifiedName, int offset, ResolveContext context) {
        assert (offset >= 0 && offset < qualifiedName.size());
        String namePart = qualifiedName.get(offset);
        if (namePart != null && OCTokenTypes.DECLTYPE_CPP_KEYWORD.getName().contentEquals(namePart)) {
            return Kind.SIMPLE_TYPE;
        }
        return null;
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate) {
        this.defineType(qualifiedName, isTemplate, false);
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate, boolean isFriend) {
        Kind kind = isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isValue(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else {
            if (existing == Kind.TEMPLATE_TYPE) {
                return;
            }
            if (isFriend && this.getKind(qualifiedName) != null) {
                this.getKind(qualifiedName);
                return;
            }
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineInterface(String qualifiedName) {
        Kind kind = Kind.OBJC_INTERFACE;
        if (OCParsingNameScope.isValue(this.getKindTerminal(qualifiedName, null))) {
            kind = Kind.TYPE_AND_VALUE;
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineProtocol(String name2) {
        this.myProtocolNames.add((Object)name2);
    }

    public void defineValue(String qualifiedName, boolean isTemplate) {
        Kind kind = isTemplate ? Kind.TEMPLATE_VALUE : Kind.SIMPLE_VALUE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isType(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else if (existing == Kind.TEMPLATE_VALUE) {
            return;
        }
        this.registerKind(qualifiedName, kind);
    }

    private void registerKind(String name2, Kind kind) {
        this.myNameKinds.put((Object)name2, (Object)kind);
    }

    public OCParsingNameScope defineNamespace(@NotNull String name2) {
        OCParsingNameScope scope = (OCParsingNameScope)this.myInnerScopes.get((Object)name2);
        if (scope == null || scope.getParent() != this) {
            scope = this.newScope(name2, this);
        }
        return scope;
    }

    public OCParsingNameScope defineLocalScope() {
        return this.newScope(LOCAL_SCOPE_NAME, this);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "OCParsingNameScope{" + this.getNiceName() + "}";
    }

    public void defineNamespaceAlias(String alias, String namespaceName) {
        this.defineNamespaceAlias(alias, Collections.singletonList(namespaceName));
    }

    public void defineNamespaceAlias(String alias, List<String> namespaceName) {
        OCParsingNameScope scope = this.resolveNamespace(namespaceName);
        if (scope != null) {
            this.myInnerScopes.put((Object)alias, (Object)scope);
        }
    }

    public void defineNamespaceUsing(@NotNull List<String> qualifiedName) {
        OCParsingNameScope scope;
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>();
        }
        if ((scope = this.resolveNamespace(qualifiedName)) != null && scope != this && !this.myNamespaceUsings.contains(scope)) {
            this.myNamespaceUsings.add(scope);
        }
    }

    public void defineNamespaceUsing(@NotNull String name2) {
        this.defineNamespaceUsing(Collections.singletonList(name2));
    }

    public void defineSymbolUsing(@NotNull String name2) {
        this.defineSymbolUsing(Collections.singletonList(name2));
    }

    public void defineSymbolUsing(@NotNull List<String> qualifiedName) {
        Kind kind = this.getKind(qualifiedName);
        boolean isType = OCParsingNameScope.isType(kind);
        if (!isType && !OCParsingNameScope.isValue(kind)) {
            return;
        }
        String alias = qualifiedName.get(qualifiedName.size() - 1);
        this.registerKind(alias, kind);
        if (isType) {
            this.defineNamespaceAlias(alias, qualifiedName);
        }
    }

    @NotNull
    public List<String> getTemplateValueParameters() {
        return this.myTemplateValueParameters != null ? this.myTemplateValueParameters : Collections.emptyList();
    }

    @NotNull
    public List<TemplateTypeParameter> getTemplateTypeParameters() {
        return this.myTemplateTypeParameters != null ? this.myTemplateTypeParameters : Collections.emptyList();
    }

    public void addTemplateValueParameter(@NotNull String qualifiedName) {
        if (this.myTemplateValueParameters == null) {
            this.myTemplateValueParameters = new ArrayList<String>();
        }
        this.myTemplateValueParameters.add(qualifiedName);
    }

    public void addTemplateTypeParameter(@NotNull String qualifiedName, boolean isTemplateTemplate) {
        if (this.myTemplateTypeParameters == null) {
            this.myTemplateTypeParameters = new ArrayList<TemplateTypeParameter>();
        }
        this.myTemplateTypeParameters.add(new TemplateTypeParameter(qualifiedName, isTemplateTemplate));
    }

    public void clearTemplateParameters() {
        this.myTemplateValueParameters = null;
        this.myTemplateTypeParameters = null;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(@NotNull List<String> qualifiedName) {
        OCParsingNameScope result;
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 0 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            OCParsingNameScope global = this;
            while (global.myParent != null) {
                global = global.myParent;
            }
            result = global.resolveNamespace(qualifiedName, 1, context);
        } else {
            result = this.resolveNamespace(qualifiedName, 0, context);
        }
        return result;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(List<String> qualifiedName, int offset, ResolveContext context) {
        if (offset == qualifiedName.size()) {
            return this;
        }
        OCParsingNameScope result = null;
        String name2 = qualifiedName.get(offset);
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            OCParsingNameScope child = (OCParsingNameScope)scope.myInnerScopes.get((Object)name2);
            if (child != null) {
                result = child.resolveNamespace(qualifiedName, offset + 1, context);
            }
            if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                OCParsingNameScope using;
                Iterator<OCParsingNameScope> iterator2 = scope.myNamespaceUsings.iterator();
                while (iterator2.hasNext() && (result = (using = iterator2.next()).resolveNamespace(qualifiedName, offset, context)) == null) {
                }
            }
            scope = scope.myDelegate;
        }
        if (result == null && this.myParent != null) {
            result = this.myParent.resolveNamespace(qualifiedName, offset, context);
        }
        return result;
    }

    @Override
    public final boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCParsingNameScope first, @NotNull OCParsingNameScope second) {
        if (!first.myName.equals(second.myName)) {
            return false;
        }
        if (!first.myNameKinds.equals(second.myNameKinds)) {
            return false;
        }
        if (!first.myProtocolNames.equals(second.myProtocolNames)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateTypeParameters, second.myTemplateTypeParameters)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateValueParameters, second.myTemplateValueParameters)) {
            return false;
        }
        if (!c.equalLists(first.myNamespaceUsings, second.myNamespaceUsings)) {
            return false;
        }
        if (!c.equalObjects(first.myParent, second.myParent)) {
            return false;
        }
        return c.equalMaps((Map)first.myInnerScopes, (Map)second.myInnerScopes);
    }

    private static class ResolveContext {
        private THashMap<OCParsingNameScope, List<Integer>> myCurrentOffsets;

        private ResolveContext() {
        }

        public boolean shouldCheckAtOffset(@NotNull OCParsingNameScope scope, int positionInName) {
            List checkedPositions;
            if (this.myCurrentOffsets == null) {
                this.myCurrentOffsets = new THashMap();
                checkedPositions = null;
            } else {
                checkedPositions = (List)this.myCurrentOffsets.get((Object)scope);
            }
            if (checkedPositions == null) {
                checkedPositions = new SmartList((Object)positionInName);
                this.myCurrentOffsets.put((Object)scope, (Object)checkedPositions);
            } else if (!checkedPositions.contains(positionInName)) {
                checkedPositions.add(positionInName);
            } else {
                return false;
            }
            return true;
        }
    }

    public static final class TemplateTypeParameter {
        @NotNull
        public final String name;
        public final boolean isTemplateTemplate;

        private TemplateTypeParameter(@NotNull String name2, boolean isTemplateTemplate) {
            this.name = name2;
            this.isTemplateTemplate = isTemplateTemplate;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateTypeParameter)) {
                return false;
            }
            TemplateTypeParameter parameter = (TemplateTypeParameter)o;
            return this.isTemplateTemplate == parameter.isTemplateTemplate && this.name.equals(parameter.name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + Boolean.hashCode(this.isTemplateTemplate);
        }
    }

    public static enum Kind {
        UNKNOWN,
        SIMPLE_TYPE,
        TEMPLATE_TYPE,
        SIMPLE_VALUE,
        TEMPLATE_VALUE,
        OBJC_INTERFACE,
        TYPE_AND_VALUE,
        NON_TYPE;

    }
}

