/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArraySelectionExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCArraySelectionExpression {
    public OCArraySelectionExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        PsiElement operationSign = this.getOperationSign();
        if (index != null) {
            class OCSubscriptOperatorReference
            extends OCOperatorReference
            implements MultiRangeReference {
                OCSubscriptOperatorReference(OCElement element, PsiElement signElement, OCExpression ... params) {
                    super((PsiElement)element, "[]", OCOperatorReference.OperatorPlacement.POSTFIX, signElement, params);
                }

                @NotNull
                public List<TextRange> getRanges() {
                    PsiElement right;
                    ArrayList<TextRange> result = new ArrayList<TextRange>();
                    PsiElement left = OCArraySelectionExpressionImpl.this.findChildByType(OCTokenTypes.LBRACKET);
                    if (left != null) {
                        result.add(OCElementUtil.getRangeInParent(left));
                    }
                    if ((right = OCArraySelectionExpressionImpl.this.findChildByType(OCTokenTypes.RBRACKET)) != null) {
                        result.add(OCElementUtil.getRangeInParent(right));
                    }
                    return result;
                }

                @Override
                @NotNull
                public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
                    List<OCSymbol> subscriptMethod = this.resolveToSubscript(context);
                    if (subscriptMethod != null) {
                        return subscriptMethod;
                    }
                    return super.resolveToSymbols(context);
                }

                @Override
                @NotNull
                public List<OCSymbol> resolveToSymbols() {
                    List<OCSymbol> subscriptMethod = this.resolveToSubscript(OCResolveContext.forPsi(OCArraySelectionExpressionImpl.this));
                    if (subscriptMethod != null) {
                        return subscriptMethod;
                    }
                    return super.resolveToSymbols();
                }

                @Nullable
                protected List<OCSymbol> resolveToSubscript(@NotNull OCResolveContext context) {
                    OCMethodSymbol subscriptMethod;
                    if (OCCompilerFeatures.supportsSubscripting(OCArraySelectionExpressionImpl.this.getContainingOCFile()) && (subscriptMethod = OCArraySelectionExpressionImpl.this.getArraySubscriptMethod(context)) != null) {
                        return Collections.singletonList(subscriptMethod);
                    }
                    return null;
                }
            }
            return new OCSubscriptOperatorReference(this, operationSign, array, index);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getArrayExpression() {
        IElementType tt;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null && (tt = child.getElementType()) != OCTokenTypes.LBRACKET; child = child.getTreeNext()) {
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        assert (false);
        return null;
    }

    @Override
    public OCExpression getIndexExpression() {
        boolean ok = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCTokenTypes.LBRACKET) {
                ok = true;
                continue;
            }
            if (!ok || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Nullable
    private PsiElement getOperationSign() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt != OCTokenTypes.LBRACKET) continue;
            return child.getPsi();
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitArraySelectionExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (operator instanceof OCFunctionSymbol) {
                    return ((OCFunctionSymbol)operator).getEffectiveType(this);
                }
                if (!(operator instanceof OCMethodSymbol)) continue;
                OCMethodSymbol method = (OCMethodSymbol)operator;
                List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
                return selectors.size() == 1 ? method.getReturnType(context.getProject()) : selectors.get(0).getParameter().getType();
            }
        }
        return OCArraySelectionExpressionImpl.getArrayIndexExprType(this.getArrayExpression().getResolvedType(context), context);
    }

    public static OCType getArrayIndexExprType(@NotNull OCType arrayType, @NotNull OCResolveContext context) {
        if (arrayType instanceof OCCppReferenceType) {
            arrayType = ((OCCppReferenceType)arrayType).getRefType();
        }
        if (arrayType instanceof OCMagicType) {
            return ((OCMagicType)arrayType).getRefType();
        }
        if (arrayType.isPointerToObject() && OCCompilerFeatures.supportsSubscripting(context.getFile())) {
            return OCIdType.pointerToID();
        }
        if (arrayType instanceof OCPointerType) {
            return ((OCPointerType)arrayType).getRefType();
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getArrayExpression());
    }

    @Override
    @Nullable
    public OCMethodSymbol getArraySubscriptMethod(@NotNull OCResolveContext context) {
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        if (index == null) {
            return null;
        }
        OCType arrayType = array.getResolvedType(context);
        OCType indexType = index.getResolvedType();
        ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(this);
        String typeName = this.getDefaultTypeName(indexType);
        String accessorName = this.getArraySubscriptAccessorName(indexType, accessType);
        if (accessorName == null || typeName == null) {
            return null;
        }
        if (arrayType.isPointerToID()) {
            arrayType = OCReferenceType.resolvedFromText(typeName, this);
        } else if (arrayType.isPointerToObject()) {
            arrayType = arrayType.getTerminalType();
        } else {
            return null;
        }
        if (arrayType instanceof OCObjectType) {
            return ((OCObjectType)arrayType).findMember(accessorName, OCMethodSymbol.class);
        }
        return null;
    }

    @Nullable
    private String getDefaultTypeName(OCType indexType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return "NSMutableArray";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return "NSMutableDictionary";
        }
        return null;
    }

    public static boolean isArraySubscriptMethod(OCMethodSymbol symbol) {
        String name2 = symbol.getName();
        return "objectAtIndexedSubscript:".equals(name2) || "setObject:atIndexedSubscript:".equals(name2) || "objectForKeyedSubscript:".equals(name2) || "setObject:forKeyedSubscript:".equals(name2);
    }

    @Override
    @Nullable
    public String getArraySubscriptAccessorName(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectAtIndexedSubscript:" : "setObject:atIndexedSubscript:";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectForKeyedSubscript:" : "setObject:forKeyedSubscript:";
        }
        return null;
    }

    @Override
    @Nullable
    public String getArraySubscriptMethodSignature(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectAtIndexedSubscript:(NSInteger)idx" : "- (void)setObject:(id)obj atIndexedSubscript:(NSInteger)idx";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectForKeyedSubscript:(id)key" : "- (void)setObject:(id)obj forKeyedSubscript:(id <NSCopying>)key";
        }
        return null;
    }
}

