/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCCallExpression {
    public OCCallExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected OCOperatorReference createReference() {
        return this.createReference(this.getFunctionReferenceExpression(), null);
    }

    public OCOperatorReference createReference(OCExpression function, @Nullable OCType functionType) {
        List<OCType> types = functionType != null ? Collections.singletonList(functionType) : null;
        ArrayList<OCExpression> exprs = new ArrayList<OCExpression>();
        exprs.add(function);
        exprs.addAll(this.getArguments());
        class OCCallOperatorReference
        extends OCOperatorReference
        implements MultiRangeReference {
            OCCallOperatorReference(OCElement element, List<OCExpression> arguments, List<OCType> paramTypes) {
                super((PsiElement)element, "()", OCOperatorReference.OperatorPlacement.POSTFIX, null, arguments, paramTypes);
            }

            @Override
            public boolean isValid() {
                return super.isValid() && this.myArguments.size() == OCCallExpressionImpl.this.getArguments().size() + 1;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                Iterator<TextRange> ranges = this.getRanges().iterator();
                if (!ranges.hasNext()) {
                    return super.getRangeInElement();
                }
                TextRange left = ranges.next();
                if (!ranges.hasNext()) {
                    return super.getRangeInElement();
                }
                return left;
            }

            @NotNull
            public List<TextRange> getRanges() {
                PsiElement right;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                OCArgumentList argumentList = OCCallExpressionImpl.this.getArgumentList();
                TextRange argListRange = OCElementUtil.getRangeInParent(argumentList);
                PsiElement left = argumentList.getLeftPar();
                if (left != null) {
                    result.add(OCElementUtil.getRangeInParent(left).shiftRight(argListRange.getStartOffset()));
                }
                if ((right = argumentList.getRightPar()) != null) {
                    result.add(OCElementUtil.getRangeInParent(right).shiftRight(argListRange.getStartOffset()));
                }
                return result;
            }
        }
        return new OCCallOperatorReference(this, exprs, types);
    }

    @Override
    @NotNull
    public OCExpression getFunctionReferenceExpression() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCArgumentList getArgumentList() {
        return (OCArgumentList)this.findNotNullChildByType(OCElementTypes.ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<OCExpression> getArguments() {
        return this.getArgumentList().getArguments();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCType unresolvedType = this.getType(context);
        OCType resolvedType = unresolvedType.resolve(context);
        if (resolvedType instanceof OCStructType) {
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(this.getArguments());
            return OCTypeUtils.deduceClassTemplateArguments((OCStructType)resolvedType, unresolvedType, arguments, true, context, this.getContainingFile().getVirtualFile(), this.getComplexOffset());
        }
        return resolvedType;
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCType funType;
        OCExpression funRef = this.getFunctionReferenceExpression();
        OCOperatorReference reference = this.createReference(funRef, funType = this.getCalleeType(context));
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        OCSymbol callerSymbol = null;
        if (funRef instanceof OCReferenceExpression) {
            OCReferenceElement referenceElement = ((OCReferenceExpression)funRef).getReferenceElement();
            callerSymbol = referenceElement != null ? referenceElement.resolveToSymbol(context) : null;
        }
        OCType result = OCCallExpressionImpl.getCallExprType(funType, callerSymbol, context);
        OCType guessedType = this.getGuessedType();
        return guessedType != null ? result.cloneWithGuessedType(guessedType) : result;
    }

    @Override
    @Nullable
    public OCType getCalleeType(@NotNull OCResolveContext context) {
        OCType funType = this.getFunctionReferenceExpression().getResolvedType(context);
        if (OCTypeUtils.isUnresolvedLambdaAutoType(funType)) {
            funType = OCTypeUtils.resolveLambdaAutoType(funType, context, OCArgumentsList.getArgumentList(this.getArguments()), false);
        }
        return funType;
    }

    @NotNull
    public static OCType getCallExprType(@Nullable OCType funType, @Nullable OCSymbol callerSymbol, @NotNull OCResolveContext context) {
        OCType result = OCUnknownType.INSTANCE;
        if (callerSymbol instanceof OCStructSymbol) {
            result = callerSymbol.getType();
        } else if (callerSymbol != null && callerSymbol.getKind() == OCSymbolKind.TYPEDEF && !(funType instanceof OCFunctionType)) {
            result = funType;
        } else if (funType != null) {
            if ((funType = funType.getTerminalType()) instanceof OCStructType) {
                result = funType;
            } else if (funType instanceof OCFunctionType) {
                result = ((OCFunctionType)funType).getReturnType();
            } else if (funType.isMagicInside(context) && !funType.isUnresolved(context)) {
                result = new OCMagicType();
            }
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(callerSymbol != null ? context.getProject() : null);
        }
        return result;
    }

    @Nullable
    private OCType getGuessedType() {
        VirtualFile containingFile;
        OCSymbol symbol;
        OCExpression function = this.getFunctionReferenceExpression();
        if (function instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)function).resolveToSymbol()) instanceof OCFunctionSymbol && symbol.getName().startsWith("is") && (containingFile = symbol.getContainingFile()) != null && containingFile.getName().equals("ctype.h")) {
            return OCIntType.getAppropriateBool(this);
        }
        return null;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        OCExpression function = this.getFunctionReferenceExpression();
        return function instanceof OCQualifiedExpression ? Collections.singletonList(((OCQualifiedExpression)function).getQualifier()) : Collections.emptyList();
    }
}

