/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;

public class OCCodeFragmentImpl
extends OCFileImpl
implements OCCodeFragment {
    private PsiElement myContext;
    private boolean myPhysical;
    private FileViewProvider myViewProvider;
    private GlobalSearchScope myResolveScope;
    private Condition<OCSymbol> myFilter = null;

    public OCCodeFragmentImpl(@NotNull Project project2, @NotNull OCLanguageKind kind, @NotNull CharSequence text, boolean isPhysical, @NotNull IElementType elementType) {
        super(PsiManagerEx.getInstanceEx((Project)project2).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile("fragment." + kind.getDefaultSourceExtension(), (Language)OCLanguage.getInstance(), text), isPhysical));
        this.myPhysical = isPhysical;
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
        this.init(TokenType.CODE_FRAGMENT, elementType);
    }

    public OCCodeFragmentImpl(FileViewProvider viewProvider, boolean isPhysical, IElementType elementType) {
        super(viewProvider);
        this.myViewProvider = viewProvider;
        this.myPhysical = isPhysical;
        this.init(TokenType.CODE_FRAGMENT, elementType);
    }

    protected OCCodeFragmentImpl clone() {
        OCCodeFragmentImpl clone = (OCCodeFragmentImpl)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    @NotNull
    public PsiFile[] getPsiRoots() {
        return new PsiFile[]{this};
    }

    public PsiElement getContext() {
        OCLog.LOG.assertTrue(this.myContext != this, (Object)"Context cannot be the same element");
        return this.myContext != null && this.myContext.isValid() ? this.myContext : super.getContext();
    }

    @Override
    public void setContext(PsiElement context) {
        this.myContext = context;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            return this.myViewProvider;
        }
        return super.getViewProvider();
    }

    public boolean isPhysical() {
        return super.isPhysical() && this.myPhysical;
    }

    public void forceResolveScope(GlobalSearchScope scope) {
        this.myResolveScope = scope;
    }

    public GlobalSearchScope getForcedResolveScope() {
        return this.myResolveScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        if (this.myResolveScope != null) {
            return this.myResolveScope;
        }
        return super.getResolveScope();
    }

    @Override
    public Condition<OCSymbol> getCompletionFilter() {
        return this.myFilter;
    }

    @Override
    public void setCompletionFilter(Condition<OCSymbol> filter) {
        this.myFilter = filter;
    }
}

