/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCConditionImpl
extends OCElementBase
implements OCCondition {
    public OCConditionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public OCType getResolvedType() {
        List<OCDeclarator> declarators;
        OCExpression expression = this.getExpression();
        if (expression != null) {
            return expression.getResolvedType();
        }
        OCDeclaration declaration = this.getDeclaration();
        if (declaration != null && !(declarators = declaration.getDeclarators()).isEmpty()) {
            return declarators.get(0).getType().resolve(OCResolveContext.forPsi(this));
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCDeclaration getDeclaration() {
        OCDeclarationStatement declStatement = (OCDeclarationStatement)this.findChildByType(OCElementTypes.DECLARATION_STATEMENT);
        return declStatement != null ? declStatement.getDeclaration() : null;
    }

    @Override
    public OCExpression getExpression() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCondition(this);
    }
}

