/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppNamespaceImpl
extends OCElementBase
implements OCCppNamespace {
    public OCCppNamespaceImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Nullable
    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    public OCNamespaceSymbol getSymbol() {
        return this.getContainingOCFile().findSymbol(this, OCNamespaceSymbol.class);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitNamespace(this);
    }

    @Override
    @Nullable
    public PsiElement getOpeningBrace() {
        return this.findChildByType(OCTokenTypes.LBRACE);
    }

    @Override
    @Nullable
    public PsiElement getClosingBrace() {
        return this.findChildByType(OCTokenTypes.RBRACE);
    }
}

