/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCDefineDirectiveImpl
extends OCDirectiveImpl
implements OCDefineDirective {
    public OCDefineDirectiveImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public String getName() {
        OCMacroSymbol def = this.getSymbol();
        return OCSymbolImpl.getSymbolName(def);
    }

    @Override
    public OCMacroSymbol getSymbol() {
        PsiElement identifier;
        if (this.isValid() && (identifier = this.getNameIdentifier()) != null) {
            int offset = identifier.getTextOffset() - super.getTextOffset();
            String text = this.getText();
            if (offset > 0 && offset < text.length()) {
                return OCMacroSymbol.parseFromDirectiveContent(text.substring(offset), OCInclusionContextUtil.getVirtualFile(this.getContainingOCFile()), OCSymbolOffsetUtil.getComplexOffset(identifier));
            }
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @Override
    public OCMacroParameterList getMacroParameters() {
        return (OCMacroParameterList)this.findChildByType(OCElementTypes.MACRO_PARAMETER_LIST);
    }

    @Override
    public int getTextOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getTextOffset();
        }
        return content.getNode().getStartOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement content = this.getNameIdentifier();
        if (content == null) {
            return super.getComplexOffset();
        }
        return OCSymbolOffsetUtil.getComplexOffset(content);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitDefineDirective(this);
    }
}

