/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLabeledStatementImpl
extends OCElementBase
implements OCLabeledStatement {
    public OCLabeledStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getLabel() {
        PsiElement child = this.findChildByType(OCTokenTypes.IDENTIFIER);
        return child != null ? child.getText() : "";
    }

    @Override
    @Nullable
    public PsiElement getLabelElement() {
        return this.getNode().getFirstChildNode().getPsi();
    }

    @Override
    public OCStatement getStatement() {
        return (OCStatement)this.findChildByType(OCElementTypes.STATEMENTS);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(OCTokenTypes.IDENTIFIER);
    }

    @NotNull
    public String getName() {
        return this.getLabel();
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    @Override
    @Nullable
    public OCLabelSymbol getLocalSymbol() {
        OCFile file = this.getContainingOCFile();
        OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCCallable.class});
        ArrayList<String> attributesList = new ArrayList<String>();
        for (PsiElement attributes : this.findChildrenByType(OCElementTypes.ATTRIBUTES)) {
            ASTNode attributesNode = attributes.getNode().getTreeParent();
            OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(attributesNode, file);
            attributesList.addAll(builderDriver.processAttributeList(attributesNode));
        }
        attributesList.trimToSize();
        return new OCLabelSymbol(OCInclusionContextUtil.getVirtualFile(file), OCSymbolOffsetUtil.getComplexOffset(this), this.getName(), callable != null && callable.getBody() != null ? OCSymbolOffsetUtil.getComplexRange(callable.getBody()) : null, attributesList);
    }

    @Override
    public OCLabelSymbol getSymbol() {
        return this.getLocalSymbol();
    }
}

