/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCLocalizedStringImpl
extends ASTWrapperPsiElement
implements OCLocalizedString {
    public OCLocalizedStringImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getKey() {
        return this.getLiteralValue(0);
    }

    @Override
    @NotNull
    public String getValue() {
        return this.getLiteralValue(1);
    }

    @NotNull
    public String getName() {
        return this.getKey();
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        PsiElement literal = this.getFirstChild();
        if (literal != null) {
            OCChangeUtil.changeText(this.getProject(), this.getContainingFile(), literal.getTextOffset() + 1, literal.getTextLength() - 2, name2, false);
        }
        return this;
    }

    @Override
    public OCLocalizedStringSymbol getSymbol() {
        return new OCLocalizedStringSymbol(this.getContainingFile().getVirtualFile(), OCSymbolOffsetUtil.getComplexOffset(this), this.getName(), Collections.emptyList());
    }

    @NotNull
    private String getLiteralValue(int literalIndex) {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type != OCTokenTypes.STRING_LITERAL && type != OCTokenTypes.IDENTIFIER || literalIndex-- != 0) continue;
            return type == OCTokenTypes.STRING_LITERAL ? StringUtil.unquoteString((String)child.getText()) : child.getText();
        }
        assert (false);
        return null;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public Icon getIcon(boolean open) {
                return null;
            }

            public String getPresentableText() {
                return OCLocalizedStringImpl.this.getValue();
            }

            public String getLocationString() {
                return ((OCStringsFile)OCLocalizedStringImpl.this.getContainingFile()).getLocalizationName();
            }
        };
    }
}

