/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDeductionGuide;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDeclarationImpl;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceElementImpl
extends OCElementBase
implements OCNamespaceQualifierOwner,
OCReferenceElement,
OCExpectedTypeUtil.Expectable,
PsiMetaOwner {
    private static final Condition<OCSymbol> IN_HEADER_FILE = symbol -> {
        VirtualFile file = symbol.getContainingFile();
        return file != null && OCFileImpl.isHeaderFile(file.getName());
    };
    public static final PsiElementPattern.Capture<PsiElement> POSSIBLE_TYPE = (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement(OCArgumentList.class).withParent(OCDeclarator.class)).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(OCDeclaration.class).with((PatternCondition)new PatternCondition<OCDeclaration>("one declarator"){

        public boolean accepts(@NotNull OCDeclaration declaration, ProcessingContext context) {
            return declaration.getDeclarators().size() == 1;
        }
    })), PlatformPatterns.psiElement(OCParenthesizedExpression.class)});

    public OCReferenceElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference getReference() {
        return this;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitReferenceElement(this);
    }

    @NotNull
    public OCReferenceElement getElement() {
        return this;
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findNameStartTokenInCall();
    }

    @Override
    @NotNull
    public PsiElement setNameOfIdentifier(@NonNls @NotNull String name2) throws IncorrectOperationException {
        ElementManipulators.handleContentChange((PsiElement)this, (String)name2);
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name2, this);
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getCanonicalText();
    }

    @Override
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType(OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    @Override
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType(OCElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.getRangeInCallElement();
    }

    public PsiElement resolve() {
        Project project2 = this.getProject();
        OCSymbol clangSymbol = ClangResolveUtils.findTargetSymbolViaClang(this);
        ClangResolveUtils.assertClangResolvesSameSymbol(this.getProject(), clangSymbol, () -> this.resolveToSymbol());
        if (clangSymbol != null) {
            PsiElement element = clangSymbol.locateDefinition(project2);
            return element != null ? element : OCSymbolHolderVirtualPsiElement.create(clangSymbol, project2);
        }
        OCSymbol symbol = this.resolveToSymbol();
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        PsiElement element = symbol.locateDefinition(project2);
        return element != null ? element : OCSymbolHolderVirtualPsiElement.create(symbol, project2);
    }

    @Override
    public OCSymbol resolveToSymbol() {
        return this.resolveToSymbol(OCResolveContext.forPsi(this));
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
        Pair pair2 = (Pair)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new MyResolver(context), false, false);
        return pair2 != null && (Boolean)pair2.second != false ? (OCSymbol)pair2.first : null;
    }

    @Override
    public OCSymbol resolveToSymbolIgnoringSymbolContext() {
        Pair pair2 = (Pair)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new MyResolver(OCResolveContext.forPsi(this)), false, false);
        return (OCSymbol)Pair.getFirst((Pair)pair2);
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@Nullable OCSymbolGroupContext context) {
        return this.resolveToSymbol(context, OCResolveContext.forPsi(this), true, false, false);
    }

    @Override
    public boolean isCppThis() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol instanceof OCThisSelfSuperSymbol && ((OCThisSelfSuperSymbol)symbol).getSelfSuperThisKind() == OCThisSelfSuperSymbol.Kind.THIS;
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols() {
        return this.resolveToOverloadsSymbols(this.getSymbolContext(), false, true, OCResolveContext.forPsi(this));
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols(@Nullable OCSymbolGroupContext symbolContext, boolean ignoreImports) {
        return this.resolveToOverloadsSymbols(symbolContext, ignoreImports, true, OCResolveContext.forPsi(this));
    }

    @NotNull
    private Collection<OCSymbol> resolveToOverloadsSymbols(final @Nullable OCSymbolGroupContext symbolContext, boolean ignoreImports, boolean filterByTemplates, @NotNull OCResolveContext context) {
        OCSymbolReference reference;
        OCSymbolReference.SymbolFilter filter;
        PsiElement parent = this.getContext();
        Collection<OCSymbol> result = this.processMacros(symbolContext);
        if (result != null) {
            return result;
        }
        result = this.processSelfSuper(context);
        if (result != null) {
            return result;
        }
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (symbolContext == null || symbolContext.isSuitableSymbol(symbol)) {
                    return symbol instanceof OCClassSymbol && ((OCClassSymbol)symbol).getCategoryName() != null || super.process((Object)symbol);
                }
                return true;
            }
        };
        OCFile containingOCFile = this.getContainingOCFile();
        OCSymbolReference.SymbolFilter symbolFilter = filter = symbolContext == null ? OCSymbolReference.SymbolFilter.NONE : symbolContext::isSuitableSymbol;
        if (parent instanceof OCCppUsingStatement && ((OCCppUsingStatement)parent).isNamespaceUsing() || parent instanceof OCCppNamespaceAlias) {
            filter = OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE;
        }
        if (!this.canBeLocalReference(reference = OCSymbolReference.getLocalReference(this, filter))) {
            reference = OCSymbolReferenceResolver.getGlobalReferenceFromLocal(reference);
        }
        if (ignoreImports) {
            OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(processor2, (Condition<T>[])new Condition[]{IN_HEADER_FILE});
            OCResolveContext context2 = OCResolveContext.forPsi(this);
            context2.setProcessNonImported(true);
            ContainerUtil.process(context2.resolveToSymbols(reference), orderedProcessor);
            orderedProcessor.finish();
        } else {
            reference.processPossibleSymbols((Processor<OCSymbol>)processor2, filterByTemplates, context);
        }
        if (processor2.getResults().size() == 0) {
            return this.processOtherSources(symbolContext, ignoreImports, processor2, context, containingOCFile);
        }
        return processor2.getResults();
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return OCResolveUtil.resolveTemplateDeclarations(this);
    }

    private boolean canBeLocalReference(OCSymbolReference reference) {
        OCElement scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCBlockStatement.class, OCDeclarationImpl.class, OCCallable.class, OCCppUsingStatement.class, OCClassDeclaration.class, OCDeductionGuide.class});
        if (scope instanceof OCCppUsingStatement || PsiTreeUtil.getParentOfType((PsiElement)scope, OCClassDeclaration.class, (boolean)false) != null) {
            return true;
        }
        OCQualifiedName name2 = reference.getQualifiedName();
        while (name2.getQualifier() != null) {
            name2 = name2.getQualifier();
        }
        String qualifier = name2.getName();
        if (scope != null && qualifier != null) {
            OCFile file = this.getContainingOCFile();
            while (file != null) {
                if (OCFileSymbols.canBeLocalSymbol(file, qualifier)) {
                    return true;
                }
                PsiElement context = file.getContext();
                file = context != null ? (OCFile)context.getContainingFile() : null;
            }
        }
        return false;
    }

    @Nullable
    protected Collection<OCSymbol> processMacros(OCSymbolGroupContext symbolContext) {
        OCMacroParameterList macroParameters;
        OCDefineDirective directive;
        if (symbolContext == OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT && (directive = (OCDefineDirective)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCDefineDirective.class})) != null && (macroParameters = directive.getMacroParameters()) != null) {
            for (OCMacroParameter param : macroParameters.getParameters()) {
                if (!this.getText().equals(param.getText())) continue;
                return Collections.singletonList(param.getSymbol());
            }
        }
        return null;
    }

    @Nullable
    protected Collection<OCSymbol> processSelfSuper(@NotNull OCResolveContext context) {
        OCClassDeclaration clazz;
        PsiElement parent = this.getContext();
        String elementName = this.getCanonicalText();
        if (parent instanceof OCReferenceExpression) {
            OCSymbol thisSelfSuper = OCThisSelfSuperSymbol.tryResolveThisSelfSuper(elementName, parent, context);
            if (thisSelfSuper != null) {
                return Collections.singletonList(thisSelfSuper);
            }
        } else if (parent instanceof OCTypeElement && parent.getParent() instanceof OCMethod && "instancetype".equals(elementName) && (clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            return ContainerUtil.createMaybeSingletonList((Object)clazz.getSymbol());
        }
        return null;
    }

    protected Collection<OCSymbol> processOtherSources(OCSymbolGroupContext symbolContext, boolean ignoreImports, CommonProcessors.CollectProcessor<OCSymbol> processor2, @NotNull OCResolveContext context, OCFile containingOCFile) {
        if (containingOCFile.isCpp() && symbolContext == OCSymbolGroupContext.PROTOCOL_CONTEXT) {
            return this.resolveToOverloadsSymbols(OCSymbolGroupContext.typeContext(containingOCFile.getKind()), ignoreImports, true, OCResolveContext.forPsi(this));
        }
        OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(this, OCSymbolReference.SymbolFilter.NONE);
        if (symbolContext == OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT && ref.getQualifiedName().getQualifier() == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.getProject(), processor2, ref.getQualifiedName().getName());
        } else if (containingOCFile.isInLibraries()) {
            boolean oldFlag = OCResolveContext.setNonImportedFlag(context, true);
            ContainerUtil.process(context.resolveToSymbols(ref), processor2);
            OCResolveContext.setNonImportedFlag(context, oldFlag);
        }
        return processor2.getResults();
    }

    public static boolean findArgumentsFromContext(@NotNull OCReferenceElement refElement, @NotNull OCResolveContext context, @NotNull Ref<List<OCExpression>> args, @NotNull Ref<OCArgumentsList<OCExpression>> arguments) {
        PsiElement parent = refElement.getContext();
        if (parent instanceof OCExpression) {
            parent = OCParenthesesUtils.topmostParenthesized((OCExpression)parent);
        }
        if (parent != null) {
            OCType receiverType;
            if (parent.getParent() instanceof OCCallExpression) {
                args.set(((OCCallExpression)parent.getParent()).getArguments());
            } else if (parent.getParent() instanceof OCCastExpression) {
                OCCompoundInitializer initializer = ((OCCastExpression)parent.getParent()).getCompoundInitializer();
                if (initializer != null) {
                    args.set(initializer.getInitializerExpressions());
                }
            } else if (parent.getParent() instanceof OCCppNewExpression) {
                args.set(((OCCppNewExpression)parent.getParent()).getInitializers());
            } else if (parent instanceof OCConstructorFieldInitializer) {
                args.set(((OCConstructorFieldInitializer)parent).getInitializers());
            } else if (parent.getParent() instanceof OCDeclarator && ((OCDeclarator)parent.getParent()).getInitializer() == parent) {
                OCType declaratorType = ((OCDeclarator)parent.getParent()).getResolvedType(context).getTerminalType();
                if (declaratorType instanceof OCFunctionType) {
                    arguments.set(new OCArgumentsList(((OCFunctionType)declaratorType).getParameterTypes(), null));
                }
            } else if ((parent.getParent() instanceof OCArgumentList || parent.getParent() instanceof OCCompoundInitializer) && parent.getParent().getParent() instanceof OCDeclarator) {
                OCType declaratorType;
                OCType unresolvedType = ((OCDeclarator)parent.getParent().getParent()).getType();
                if (!(unresolvedType instanceof OCAutoType) && (declaratorType = unresolvedType.resolve(context).getTerminalType()) instanceof OCFunctionType) {
                    arguments.set(new OCArgumentsList(((OCFunctionType)declaratorType).getParameterTypes(), null));
                }
            } else if (parent.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent.getParent()).getSourceExpression() == parent && (receiverType = ((OCAssignmentExpression)parent.getParent()).getReceiverExpression().getResolvedType(context).getTerminalType()) instanceof OCFunctionType) {
                arguments.set(new OCArgumentsList(((OCFunctionType)receiverType).getParameterTypes(), null));
            }
            if (arguments.isNull()) {
                if (!args.isNull()) {
                    arguments.set(OCArgumentsList.getArgumentList((List)args.get(), context));
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static OCSymbol resolveToConstructors(@NotNull OCReferenceElement refElement, @NotNull Collection<OCSymbol> symbols, @NotNull OCStructType type, @NotNull OCArgumentsList<OCExpression> argumentList, @NotNull OCResolveContext context) {
        SmartList all = new SmartList();
        SmartList nonPredefinition = new SmartList();
        for (OCSymbol symbol : symbols) {
            if (!(symbol instanceof OCStructSymbol)) continue;
            OCFunctionSymbol constructor = ((OCStructSymbol)symbol).findConstructor(argumentList, context, refElement, true, null, false, type).getSymbol();
            all.add(constructor);
            if (((OCStructSymbol)symbol).isPredefinition()) continue;
            nonPredefinition.add(constructor);
        }
        if (!nonPredefinition.isEmpty()) {
            return (OCSymbol)ContainerUtil.getFirstItem((List)nonPredefinition);
        }
        return (OCSymbol)ContainerUtil.getFirstItem((List)all);
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@Nullable OCSymbolGroupContext symbolContext, @NotNull OCResolveContext context, boolean filterByParameters, boolean filterByTemplates, boolean filterAmbigs) {
        boolean isOverloadable;
        ProgressManager.checkCanceled();
        Collection<OCSymbol> symbols = this.resolveToOverloadsSymbols(symbolContext, false, filterByTemplates, context);
        boolean bl = isOverloadable = this.getContainingOCFile().isCpp() || ContainerUtil.exists(symbols, symbol -> symbol.hasAttribute("overloadable"));
        if (isOverloadable) {
            return this.resolveOverloads(symbols, context, filterByParameters, filterAmbigs);
        }
        return OCReferenceElementImpl.findPredeclaration(symbols);
    }

    @Nullable
    private OCSymbol resolveOverloads(Collection<OCSymbol> symbols, @NotNull OCResolveContext context, boolean filterByParameters, boolean filterAmbigs) {
        PsiElement parent = this.getContext();
        if (parent instanceof OCExpression) {
            parent = OCParenthesesUtils.topmostParenthesized((OCExpression)parent);
        }
        if (parent != null) {
            OCSymbolWithQualifiedName owner2;
            List<OCSymbol> qualifierSymbols;
            List classSymbols;
            Ref argumentsRef;
            Ref argsRef = Ref.create();
            if (!OCReferenceElementImpl.findArgumentsFromContext(this, context, (Ref<List<OCExpression>>)argsRef, (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
                return OCReferenceElementImpl.findPredeclaration(symbols);
            }
            List args = (List)argsRef.get();
            OCArgumentsList arguments = (OCArgumentsList)argumentsRef.get();
            assert (arguments != null);
            OCStructType type = null;
            List classes = ContainerUtil.findAll(symbols, OCStructSymbol.class);
            List nonConstructors = ContainerUtil.findAll(symbols, symbol -> !(symbol instanceof OCStructSymbol) && !symbol.getKind().isConstructorOrDestructor());
            if (!classes.isEmpty() && nonConstructors.isEmpty()) {
                type = new OCStructType(classes);
            } else if (!nonConstructors.isEmpty()) {
                symbols = nonConstructors;
            }
            OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol functionSymbol = function != null ? function.getSymbol() : null;
            CVQualifiers cvQualifiers = functionSymbol != null ? functionSymbol.getType().getCVQualifiers() : null;
            OCQualifiedName name2 = OCSymbolReferenceResolver.getQualifiedName(this);
            OCType leftType = null;
            OCCppNamespaceQualifier qualifier = this.getNamespaceQualifier();
            if (qualifier != null && !(classSymbols = ContainerUtil.findAll(qualifierSymbols = qualifier.resolveToSymbols(), OCStructSymbol.class)).isEmpty()) {
                leftType = new OCStructType(classSymbols);
            }
            if (leftType == null && functionSymbol != null && (owner2 = functionSymbol.getResolvedOwner(context, false)) instanceof OCStructSymbol) {
                leftType = owner2.getType().cloneWithCVQualifiers(cvQualifiers, this.getProject());
            }
            if (this.getContext().getParent() instanceof OCCallExpression) {
                symbols = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, arguments.getTypes(), args, name2, context);
            }
            if (type != null) {
                if (type.isEnum() || type.isEnumClass()) {
                    return type.getSymbol();
                }
                OCSymbol result = OCReferenceElementImpl.resolveToConstructors(this, symbols, type, arguments, context);
                if (result != null) {
                    return result;
                }
                OCSymbol structDecl = null;
                OCSymbol structPredecl = null;
                for (OCSymbol oCSymbol : symbols) {
                    if (!(oCSymbol instanceof OCStructSymbol)) continue;
                    boolean isPredecl = oCSymbol.isPredeclaration();
                    if (structDecl == null && !isPredecl) {
                        structDecl = oCSymbol;
                        continue;
                    }
                    if (structPredecl != null || !isPredecl) continue;
                    structPredecl = oCSymbol;
                }
                return structDecl != null ? structDecl : structPredecl;
            }
            return OCResolveOverloadsUtil.resolveOverloads(symbols, arguments, leftType, null, null, filterByParameters, filterAmbigs, context, this);
        }
        return null;
    }

    @Nullable
    public static OCSymbol findPredeclaration(@NotNull Collection<OCSymbol> symbols) {
        List filtered;
        if (symbols.size() != 1 && (filtered = ContainerUtil.filter(symbols, OCSymbol.NON_FANTOM_SYMBOL_CONDITION)).size() != 0) {
            symbols = filtered;
        }
        OCSymbol predeclaration = null;
        OCSymbol definition = null;
        OCSymbol typedef = null;
        for (OCSymbol symbol : symbols) {
            if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                typedef = symbol;
                continue;
            }
            if ((symbol instanceof OCStructSymbol || symbol instanceof OCClassSymbol) && symbol.isPredeclaration()) {
                predeclaration = symbol;
                continue;
            }
            if (definition != null && (definition.getOffset() >= symbol.getOffset() || definition.getKind() != OCSymbolKind.ENUM || symbol.getKind() != OCSymbolKind.ENUM_CONST) && (!definition.getKind().isConstructorOrDestructor() || symbol.getKind() != OCSymbolKind.STRUCT)) continue;
            definition = symbol;
        }
        OCSymbol result = definition != null ? definition : predeclaration;
        return typedef != null && (result == null || !result.getKind().isLocal()) ? typedef : result;
    }

    @Override
    public OCType getExpectedType() {
        OCElement parent = (OCElement)this.getContext();
        OCType expectedType = null;
        if (parent instanceof OCReferenceExpression) {
            if (parent.getContext() instanceof OCCallExpression) {
                return OCQualifiedExpressionImpl.getCallExpectedType((OCCallExpression)parent.getParent());
            }
            expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)((OCReferenceExpression)parent), true);
        } else if (parent instanceof OCSynthesizeProperty) {
            OCReferenceElement ivarRef = ((OCSynthesizeProperty)parent).getInstanceVariableRef();
            OCReferenceElement propertyRef = ((OCSynthesizeProperty)parent).getPropertyRef();
            OCSymbol peerSymbol = null;
            if (this == ivarRef && propertyRef != null) {
                peerSymbol = propertyRef.resolveToSymbol();
            } else if (this == propertyRef && ivarRef != null) {
                peerSymbol = ivarRef.resolveToSymbol();
            }
            if (peerSymbol != null) {
                return peerSymbol.getType();
            }
        }
        if (expectedType == null || expectedType == OCUnknownType.INSTANCE) {
            expectedType = this.getContainingOCFile().getKind().isObjC() ? OCIdType.pointerToID() : OCIntType.INT;
        }
        return expectedType;
    }

    @Override
    public OCSymbolGroupContext getSymbolContext() {
        return this.getSymbolContext(false);
    }

    @Override
    public OCSymbolGroupContext getSymbolContext(boolean isAmbiguous) {
        return this.getSymbolContext(OCResolveContext.forPsi(this), isAmbiguous);
    }

    private OCSymbolGroupContext getSymbolContext(@NotNull OCResolveContext context, boolean isAmbiguous) {
        OCSymbolGroupContext result;
        PsiElement parent = this.getContext();
        OCLanguageKind languageKind = this.getContainingOCFile().getKind();
        boolean cpp = languageKind.isCpp();
        boolean objc = languageKind.isObjC();
        if (this instanceof OCMacroReferenceElementImpl) {
            return OCSymbolGroupContext.MACRO_CONTEXT;
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof OCSuperClassRef) {
            return OCSymbolGroupContext.CLASS_CONTEXT;
        }
        if (parent instanceof OCProtocolList) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCGotoStatement) {
            return OCSymbolGroupContext.LABEL_CONTEXT;
        }
        if (parent instanceof OCReferenceElement && objc) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCCppUsingStatement && ((OCCppUsingStatement)parent).isNamespaceUsing()) {
            return new OCSymbolGroupContext("namespace", OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
        }
        if (parent instanceof OCStructLike) {
            OCSymbolKind kind = ((OCStructLike)parent).getKind();
            return new OCSymbolGroupContext(kind.getNameLowercase(), kind, OCSymbolKind.SYMBOL_USING_SYMBOL, OCSymbolKind.TEMPLATE_TYPE_PARAMETER, OCSymbolKind.BUILTIN_SYMBOL);
        }
        OCReferenceElementImpl scopeKid = this;
        PsiElement scope = null;
        while (scopeKid != null) {
            OCExpression initializer;
            scope = PsiTreeUtil.getContextOfType((PsiElement)scopeKid, (Class[])new Class[]{OCParameterList.class, OCCallable.class, OCClassDeclaration.class, OCDirective.class, OCConstructorFieldInitializer.class, OCStatementExpression.class});
            OCDeclarator declarator = scope instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)scope).getDeclarator() : null;
            OCExpression oCExpression = initializer = declarator != null ? declarator.getInitializer() : null;
            if (!PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)scopeKid, (boolean)true)) break;
            scopeKid = scope;
        }
        if (scope instanceof OCDirective) {
            return OCSymbolGroupContext.MACRO_OR_MACRO_PARAMETER_CONTEXT;
        }
        OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType(scope, OCClassDeclaration.class, (boolean)false);
        OCClassSymbol classSymbol = clazz != null ? clazz.getSymbol() : null;
        OCInterfaceSymbol intfSymbol = classSymbol != null ? classSymbol.getInterface(this.getProject()) : null;
        OCImplementationSymbol implSymbol = classSymbol != null ? classSymbol.getImplementation(this.getProject()) : null;
        OCClassSymbol ivarsParent = intfSymbol;
        if (classSymbol != null && OCCompilerFeatures.supportsIvarsInImplementation()) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.getContainingFile(), OCCodeStyleSettings.class);
            if (settings.PUT_IVARS_TO_IMPLEMENTATION) {
                ivarsParent = implSymbol;
            }
        }
        if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getPropertyRef() == this) {
            return new OCSymbolGroupContext(new OCSymbolContext(this, OCSymbolKind.PROPERTY, intfSymbol));
        }
        if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == this) {
            return new OCSymbolGroupContext(new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ivarsParent));
        }
        if (parent instanceof OCTypeElement && parent.getContext() instanceof OCProtocolExpression) {
            return OCSymbolGroupContext.PROTOCOL_CONTEXT;
        }
        if (parent instanceof OCCompatibilityAlias) {
            return OCSymbolGroupContext.union(OCSymbolGroupContext.CLASS_CONTEXT, OCSymbolKind.TYPEDEF);
        }
        OCCppNamespaceQualifier qualifier = this.getNamespaceQualifier();
        OCSymbol parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(qualifier, context);
        String contextName = parentSymbol != null && parentSymbol.getKind().canBeNamespace() ? parentSymbol.getKind().getNameLowercase() + " member" : (parent instanceof OCCppUsingStatement ? "member" : "variable");
        OCSymbolGroupContext varContext = new OCSymbolGroupContext(contextName, new OCSymbolKind[0]);
        if (parentSymbol != null && parentSymbol.getKind() == OCSymbolKind.NAMESPACE) {
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.FUNCTION_DECLARATION, parentSymbol));
            if (qualifier == null && parent instanceof OCExpression && !OCCodeInsightUtil.isLValue((OCExpression)parent)) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.MACRO, null));
            }
        } else {
            OCSymbolWithQualifiedName owner2;
            boolean staticContext;
            OCFunctionDefinition method = (OCFunctionDefinition)PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class});
            OCFunctionSymbol methodSymbol = method != null ? method.getSymbol() : null;
            boolean bl = staticContext = methodSymbol != null && methodSymbol.resolveIsFriendOrStatic(context);
            if (parentSymbol == null) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE, null));
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, null));
                if (qualifier == null && parent instanceof OCExpression && !OCCodeInsightUtil.isLValue((OCExpression)parent)) {
                    varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.MACRO, null));
                }
                owner2 = methodSymbol != null ? methodSymbol.getResolvedOwner(context) : null;
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.STRUCT_FIELD, staticContext, owner2));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, staticContext, owner2));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_DECLARATION, staticContext, owner2));
                if (!staticContext) {
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, false, owner2));
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, false, owner2));
                }
                if (objc && parent instanceof OCTypeElement && parent.getParent() instanceof OCTemplateArgumentList) {
                    varContext.addSymbolContext(new OCSymbolContext(OCSymbolKind.PROTOCOL));
                }
            } else if (parentSymbol.getKind().isType() && parentSymbol.getKind() != OCSymbolKind.ENUM) {
                if (!staticContext && methodSymbol != null) {
                    owner2 = methodSymbol.getResolvedOwner(context);
                    staticContext = parentSymbol instanceof OCStructSymbol && owner2 instanceof OCStructSymbol ? !OCStructType.isSubstructOf((OCStructSymbol)parentSymbol, (OCStructSymbol)owner2, context) : true;
                }
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.STRUCT_FIELD, staticContext, parentSymbol));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_PREDECLARATION, staticContext, parentSymbol));
                varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.FUNCTION_DECLARATION, staticContext, parentSymbol));
                if (!staticContext) {
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION, false, parentSymbol));
                    varContext.addSymbolContext(new OCSymbolContext.StructMemberContext(this, OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, false, parentSymbol));
                }
            }
        }
        varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.BUILTIN_SYMBOL, parentSymbol));
        if (cpp) {
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.TEMPLATE_VALUE_PARAMETER, parentSymbol));
            varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.SYMBOL_USING_SYMBOL, parentSymbol));
        }
        if (qualifier == null) {
            if (scope instanceof OCCallable || scope instanceof OCStatementExpression) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.LOCAL_VARIABLE, null));
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.CATCH_EXCEPTION_VARIABLE, null));
            }
            if (classSymbol != null) {
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ivarsParent));
            }
            if (scope instanceof OCCallable || scope instanceof OCParameterList || scope instanceof OCConstructorFieldInitializer || scope instanceof OCStatementExpression) {
                OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)scope, OCCallable.class, (boolean)false);
                varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.PARAMETER, callable != null ? callable.getSymbol() : null));
            }
        }
        OCSymbol enumParentSymbol = parentSymbol;
        if (parent instanceof OCReferenceExpression && parent.getParent() instanceof OCCaseStatement) {
            OCType type;
            OCSwitchStatement switchStatement = (OCSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCSwitchStatement.class);
            OCCondition expression = switchStatement != null ? switchStatement.getExpression() : null;
            OCType oCType = type = expression != null ? expression.getResolvedType() : null;
            if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
                enumParentSymbol = ((OCStructType)type).getSymbol();
            }
        }
        varContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.ENUM_CONST, enumParentSymbol));
        if (PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCReferenceExpression.class, OCParenthesizedExpression.class}) instanceof OCSizeofExpression || parent instanceof OCReferenceExpression && ((OCReferenceExpression)parent).isParameterOfBuiltInTrait()) {
            result = new OCSymbolGroupContext("variable or type", OCSymbolKind.TYPEDEF);
            result.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
            result.addSymbolContexts(varContext.getSymbolContexts());
            return result;
        }
        if (parent instanceof OCReferenceExpression && (parent.getContext() instanceof OCSendMessageExpression || parent.getContext() instanceof OCQualifiedExpression && ((OCQualifiedExpression)parent.getContext()).getQualifyingTokenKind() == OCTokenTypes.DOT)) {
            result = new OCSymbolGroupContext("variable or class", OCSymbolKind.TYPEDEF);
            if (objc) {
                result.addSymbolContext(OCSymbolKind.INTERFACE);
                result.addSymbolContext(OCSymbolKind.IMPLEMENTATION);
                result.addSymbolContext(OCSymbolKind.COMPATIBILITY_ALIAS);
            }
            if (cpp) {
                result.addSymbolContext(OCSymbolKind.USING_SYMBOL_ALIAS);
            }
            result.addSymbolContexts(varContext.getSymbolContexts());
            return result;
        }
        if ((parent instanceof OCTypeElement && parent.getParent().getParent() instanceof OCDeclarationStatement || parent instanceof OCReferenceExpression && parent.getParent() instanceof OCExpressionStatement) && !parent.isPhysical()) {
            varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
            return varContext;
        }
        if (parent instanceof OCReferenceExpression) {
            OCSymbolGroupContext fromMacro;
            if (cpp && (parent.getContext() instanceof OCCallExpression || parent.getContext() instanceof OCTemplateArgumentList)) {
                varContext.addSymbolContext(OCSymbolKind.TYPEDEF);
                varContext.addSymbolContext(OCSymbolKind.USING_SYMBOL_ALIAS);
                varContext.addSymbolContext(OCSymbolKind.STRUCT);
                varContext.addSymbolContext(OCSymbolKind.UNION);
                varContext.addSymbolContext(OCSymbolKind.ENUM);
                varContext.addSymbolContext(OCSymbolKind.TEMPLATE_TYPE_PARAMETER);
                varContext.addSymbolContext(OCSymbolKind.SYMBOL_USING_SYMBOL);
                varContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
                varContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION);
            }
            if (isAmbiguous && POSSIBLE_TYPE.accepts((Object)parent.getContext())) {
                return OCSymbolGroupContext.union(varContext, OCSymbolGroupContext.typeContext(languageKind));
            }
            if (parent.getParent() instanceof OCExpressionStatement && parent.getParent().getParent() instanceof OCMacroCallArgument && (fromMacro = this.getSymbolContextFromMacroExpansion((OCMacroCallArgument)parent.getParent().getParent(), isAmbiguous)) != null) {
                return fromMacro;
            }
            return varContext;
        }
        if (parent instanceof OCTypeElement || parent instanceof OCCppBaseClause) {
            PsiElement krFunction;
            OCDeclarator declarator;
            if (isAmbiguous && parent instanceof OCTypeElement && OCReferenceElementImpl.canBeAmbiguousVarDeclarator((OCTypeElement)parent)) {
                return OCSymbolGroupContext.union(varContext, OCSymbolGroupContext.typeContext(languageKind));
            }
            PsiElement parentContext = parent.getContext();
            if (parentContext instanceof OCCppNewExpression) {
                return OCSymbolGroupContext.CONSTRUCTOR_CONTEXT;
            }
            if (parentContext instanceof OCDeclaration && ((OCDeclaration)parentContext).getDeclarators().size() == 0) {
                varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
                return varContext;
            }
            if (parentContext instanceof OCTemplateArgumentList) {
                varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
                return varContext;
            }
            if (parentContext instanceof OCParameterDeclaration && ((OCDeclaration)parentContext).getDeclarators().size() == 1 && (declarator = ((OCDeclaration)parentContext).getDeclarators().get(0)).isEmpty() && (krFunction = PsiTreeUtil.getContextOfType((PsiElement)parentContext, (Class[])new Class[]{OCFunctionDefinition.class})) instanceof OCFunctionDefinition && krFunction.getNode().getElementType() == OCElementTypes.FUNCTION_KR_DEFINITION) {
                return varContext;
            }
            return OCSymbolGroupContext.typeContext(languageKind);
        }
        if (parent instanceof OCCppUsingStatement) {
            varContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
            return varContext;
        }
        return null;
    }

    private static boolean canBeAmbiguousVarDeclarator(@NotNull OCTypeElement element) {
        OCParameterList pl;
        OCFunctionDeclaration fd;
        OCDeclarator declarator;
        PsiElement parentContext = element.getContext();
        return parentContext instanceof OCParameterDeclaration && ((OCDeclaration)parentContext).getDeclarators().size() == 1 && (declarator = ((OCDeclaration)parentContext).getDeclarators().get(0)).isEmpty() && (fd = (OCFunctionDeclaration)PsiTreeUtil.getContextOfType((PsiElement)parentContext, (Class[])new Class[]{OCFunctionDeclaration.class})) != null && fd.getBody() == null && (pl = fd.getParameterList()) != null && pl.getParameterDeclarations().size() == 1;
    }

    @Nullable
    private OCSymbolGroupContext getSymbolContextFromMacroExpansion(OCMacroCallArgument arg, boolean isAmbiguous) {
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)arg, (Class[])new Class[]{OCMacroCall.class});
        if (call == null) {
            return null;
        }
        String myName = this.getName();
        Ref possibleContext = Ref.create();
        call.processExpansionLeaves((Processor<PsiElement>)((Processor)leaf -> {
            if (leaf.getNode().getElementType() != OCTokenTypes.IDENTIFIER || !(leaf.getParent() instanceof OCReferenceElement)) {
                return true;
            }
            OCReferenceElement macroRef = (OCReferenceElement)leaf.getParent();
            if (!myName.equals(macroRef.getName())) {
                return true;
            }
            OCSymbolGroupContext otherContext = macroRef.getSymbolContext(isAmbiguous);
            if (otherContext != null) {
                if (possibleContext.get() == null) {
                    possibleContext.set((Object)otherContext);
                } else {
                    possibleContext.set((Object)OCSymbolGroupContext.union((OCSymbolGroupContext)possibleContext.get(), otherContext));
                }
            }
            return true;
        }));
        return (OCSymbolGroupContext)possibleContext.get();
    }

    public static OCSymbol getAppropriateToAppendSymbol(OCCppNamespaceQualifier qualifier, @NotNull OCResolveContext context) {
        OCSymbol parentSymbol = null;
        if (qualifier != null) {
            OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(qualifier, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            PsiElement parent = qualifier.getParent();
            while (parent instanceof OCCppNamespaceQualifier) {
                parent = parent.getParent();
            }
            List<OCSymbol> symbols = ref.resolveToSymbols(true, true, true, context);
            List parentSymbols = ContainerUtil.filter(symbols, symbol -> OCSymbol.NON_PREDEFINITION_CONDITION.value(symbol) && symbol.getKind().canBeNamespace());
            if (parentSymbols.size() == 0) {
                parentSymbol = null;
            } else if (parentSymbols.size() == 1) {
                parentSymbol = (OCSymbol)parentSymbols.get(0);
            } else {
                for (OCSymbol candidate : parentSymbols) {
                    if (!Comparing.equal((Object)candidate.getContainingOCFile(context.getProject()), (Object)qualifier.getContainingOCFile())) continue;
                    parentSymbol = candidate;
                    break;
                }
                if (parentSymbol == null) {
                    parentSymbol = (OCSymbol)parentSymbols.get(0);
                }
            }
        }
        return parentSymbol;
    }

    @Override
    public OCInstanceVariableSymbol getSymbol() {
        if (!(this.getParent() instanceof OCSynthesizeProperty)) {
            return null;
        }
        return this.getContainingOCFile().findSymbol(this, OCInstanceVariableSymbol.class);
    }

    @NotNull
    public String getCanonicalText() {
        OCStructLike parent;
        String name2 = OCElementUtil.getIdentifierName(this.findReferenceTokenInCall());
        if (this.getParent() instanceof OCStructLike && !(parent = (OCStructLike)this.getParent()).isDeclaration()) {
            return parent.getKind().getNameLowercase() + " " + name2;
        }
        return name2;
    }

    public OCReferenceElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (!newElementName.equals(this.getName())) {
            this.setNameOfIdentifier(newElementName);
            if (PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMacroCall.class}) != null) {
                FileSymbolTablesCache.getInstance(this.getProject()).scheduleReparseFile(this.getContainingOCFile());
            }
        }
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        OCMethod method;
        if (this.getParent() instanceof OCReferenceExpression && ((OCReferenceExpression)this.getParent()).getSelfSuperToken() != null && symbol instanceof OCClassSymbol && ((method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)this, OCMethod.class)) == null || method.isInstanceMethod())) {
            return this;
        }
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return this.handleElementRename(symbol.getName());
        }
        OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(OCResolveContext.forPsi(this));
        if (symbol.getKind().isConstructorOrDestructor() && qualifiedName != null) {
            qualifiedName = qualifiedName.getQualifier();
        }
        if (!(qualifiedName != null && OCBindUtil.setShortestPossibleName(qualifiedName, this, (OCSymbolWithQualifiedName)symbol) || symbol.getKind() != OCSymbolKind.TYPEDEF)) {
            String typeName = symbol.getType().getBestNameInContext(this);
            return OCChangeUtil.replaceHandlingMacros(this, OCElementFactory.typeElementFromText(typeName, this));
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator) || this.getParent() instanceof OCStructLike && !((OCStructLike)this.getParent()).isElaboratedTypeDeclaration()) {
            return false;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        OCSymbol clangSymbol = ClangResolveUtils.findTargetSymbolViaClang(this);
        ClangResolveUtils.assertClangResolvesSameSymbol(this.getProject(), clangSymbol, () -> this.resolveToSymbol());
        OCSymbol thisSymbol = clangSymbol != null ? clangSymbol : (symbol instanceof OCInstanceVariableSymbol && this.getParent() instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)this.getParent()).getInstanceVariableRef() == null ? this.resolveToSymbol(new OCSymbolGroupContext(new OCSymbolContext(null, OCSymbolKind.INSTANCE_VARIABLE, null))) : this.resolveToSymbol());
        if (symbol instanceof OCMacroSymbol && thisSymbol instanceof OCMacroSymbol && symbol.getName().equals(thisSymbol.getName())) {
            return true;
        }
        if (thisSymbol instanceof OCFunctionGroupSymbol) {
            return ((OCFunctionGroupSymbol)thisSymbol).getOverloads().stream().anyMatch(f -> f.isSameSymbol((OCSymbol)symbol, this.getProject()));
        }
        if (thisSymbol instanceof OCCompilerGeneratedConstructorSymbol && symbol instanceof OCStructSymbol) {
            return ((OCCompilerGeneratedConstructorSymbol)thisSymbol).getStruct().isSameSymbol((OCSymbol)symbol, this.getProject());
        }
        if (symbol instanceof OCCompilerGeneratedConstructorSymbol && thisSymbol instanceof OCStructSymbol) {
            return ((OCCompilerGeneratedConstructorSymbol)symbol).getStruct().isSameSymbol(thisSymbol, this.getProject());
        }
        if (symbol instanceof OCStructSymbol && symbol.isPredeclaration() && thisSymbol instanceof OCFunctionSymbol && thisSymbol.getKind().isConstructorOrDestructor()) {
            return symbol.isSameSymbol(((OCFunctionSymbol)thisSymbol).getParent(), this.getProject());
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(this.getProject()) == thisSymbol) {
            return true;
        }
        return thisSymbol != null && thisSymbol.isSameSymbol((OCSymbol)symbol, this.getProject());
    }

    public boolean isSoft() {
        return false;
    }

    public PsiMetaData getMetaData() {
        return new PsiWritableMetaData(){

            public PsiElement getDeclaration() {
                return OCReferenceElementImpl.this;
            }

            public String getName(PsiElement context) {
                return OCReferenceElementImpl.this.getName();
            }

            public String getName() {
                return OCReferenceElementImpl.this.getName();
            }

            public void setName(String name2) throws IncorrectOperationException {
                OCReferenceElementImpl.this.handleElementRename(name2);
            }

            public void init(PsiElement element) {
                throw new UnsupportedOperationException("Not implemented");
            }

            @NotNull
            public Object[] getDependencies() {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
    }

    private static class MyResolver
    implements ResolveCache.AbstractResolver<OCReferenceElement, Pair<OCSymbol, Boolean>> {
        private final OCResolveContext myContext;

        MyResolver(@NotNull OCResolveContext context) {
            this.myContext = context;
        }

        public Pair<OCSymbol, Boolean> resolve(@NotNull OCReferenceElement element, boolean incompleteCode) {
            OCReferenceElementImpl referenceElement = (OCReferenceElementImpl)element;
            OCSymbol symbol = referenceElement.resolveToSymbol(referenceElement.getSymbolContext(this.myContext, false), this.myContext, false, false, false);
            if (symbol != null) {
                return new Pair((Object)symbol, (Object)true);
            }
            return new Pair((Object)referenceElement.resolveToSymbol(null, this.myContext, false, false, false), (Object)false);
        }
    }
}

