/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSwitchStatementImpl
extends OCElementBase
implements OCSwitchStatement {
    public OCSwitchStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCElement getInitStatement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            if (child instanceof OCCondition) {
                return null;
            }
            if (!(child instanceof OCDeclarationStatement) && !(child instanceof OCExpressionStatement)) continue;
            return (OCElement)child;
        }
        return null;
    }

    @Override
    @Nullable
    public OCCondition getExpression() {
        return (OCCondition)this.findChildByType(OCElementTypes.CONDITION);
    }

    @Override
    @NotNull
    public OCElementType getKeywordType() {
        return OCTokenTypes.SWITCH_KEYWORD;
    }

    @Override
    @Nullable
    public OCStatement getBody() {
        boolean conditionPassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode node = child.getNode();
            assert (node != null);
            if (child instanceof OCCondition) {
                conditionPassed = true;
                continue;
            }
            if (!conditionPassed || !(child instanceof OCStatement)) continue;
            return (OCStatement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getSwitchToken() {
        return this.findNotNullChildByType(OCTokenTypes.SWITCH_KEYWORD);
    }

    @Override
    @Nullable
    public ASTNode getLParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
    }

    @Override
    @Nullable
    public ASTNode getRParenth() {
        return this.getNode().findChildByType((IElementType)OCTokenTypes.RPAR);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitSwitchStatement(this);
    }
}

