/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.SLRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SLRUSynchronizedCache<K, V> {
    @NotNull
    private final SLRUCache<K, AtomicNotNullLazyValue<V>> myCache;

    public SLRUSynchronizedCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUCache<K, AtomicNotNullLazyValue<V>>(protectedQueueSize, probationalQueueSize){

            @NotNull
            public AtomicNotNullLazyValue<V> createValue(final K key) {
                return new AtomicNotNullLazyValue<V>(){

                    @NotNull
                    protected V compute() {
                        return SLRUSynchronizedCache.this.createValue(key);
                    }
                };
            }
        };
    }

    public abstract V createValue(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public V get(K key) {
        NotNullLazyValue value;
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            value = (NotNullLazyValue)this.myCache.get(key);
        }
        return (V)value.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V getIfCached(K key) {
        AtomicNotNullLazyValue value;
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            value = (AtomicNotNullLazyValue)this.myCache.getIfCached(key);
        }
        if (value == null) {
            return null;
        }
        if (value.isComputed()) {
            return (V)value.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SLRUCache<K, AtomicNotNullLazyValue<V>> sLRUCache = this.myCache;
        synchronized (sLRUCache) {
            this.myCache.clear();
        }
    }
}

