/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.intentions.OCAddParametersToConstructorIntentionAction;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToConstructorAction
extends OCAddParametersToConstructorIntentionAction {
    private final OCDeclaratorSymbol myField;
    private final OCStructSymbol myParent;
    private final OCFunctionDeclaration myFunction;
    private final OCFunctionSymbol mySymbol;

    public OCAddParametersToConstructorAction(OCDeclaratorSymbol field, OCStructSymbol parent, OCFunctionDeclaration function, OCFunctionSymbol symbol) {
        this.myField = field;
        this.myParent = parent;
        this.myFunction = function;
        this.mySymbol = symbol;
    }

    @Override
    @Nullable
    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file) {
        return this.myField;
    }

    @Override
    @NotNull
    public String getText() {
        return "Add " + this.myField.getNameWithKindLowercase(OCCompilationContext.create(this.myFunction)) + " as a parameter to constructor";
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
        return false;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(this.myParent, (PsiElement)this.myFunction){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                return Collections.singletonList(OCAddParametersToConstructorAction.this.mySymbol);
            }
        };
    }
}

