/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddRawStringSuffix
extends OCPsiElementQuickFix<PsiElement> {
    private final SmartPsiElementPointer<PsiElement> myRawString;

    public OCAddRawStringSuffix(PsiElement element) {
        super(element);
        this.myRawString = OCElementUtil.createPsiElementPointer(element);
    }

    @Override
    protected String getTextInternal() {
        return "Add suffix";
    }

    @NotNull
    public String getFamilyName() {
        return "Check raw string";
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        return OCElementUtil.getElementType(this.myRawString.getElement()) == OCTokenTypes.WRONG_RAW_STRING_LITERAL;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (editor != null) {
            ASTNode node;
            PsiElement element = this.myRawString.getElement();
            ASTNode aSTNode = node = element != null ? element.getNode() : null;
            if (node != null) {
                OCFixer.needCorrectionLiteral(editor, node, true);
            }
        }
    }
}

