/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCElementType myModifier;
    private String mySubject;
    private boolean myProcessSameSymbols = true;

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, @NotNull Project project2, @Nullable String subject, boolean processSameSymbols) {
        super(project2, symbol);
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project2, boolean processSameSymbols) {
        this(symbol, modifier, project2, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project2)), processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project2) {
        this(symbol, modifier, project2, true);
    }

    @Override
    protected String getTextInternal() {
        return "Make " + this.mySubject + " " + this.myModifier.getName();
    }

    @NotNull
    public String getFamilyName() {
        return "Add '" + this.myModifier.getName() + "'";
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isConst() || this.mySymbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable() || this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.VIRTUAL_CPP_KEYWORD || !((OCFunctionSymbol)this.mySymbol).isVirtual();
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        ArrayList nodesToUpdate = new ArrayList();
        Processor processor2 = symbol1 -> {
            PsiElement element = symbol1.locateDefinition(project2);
            if (element == null || !(element.getParent() instanceof OCDeclaration)) {
                return true;
            }
            OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
            if (typeElement == null) {
                return true;
            }
            ASTNode typeNode = typeElement.getNode();
            if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)this.myModifier) == null) {
                nodesToUpdate.add(typeNode);
            }
            return true;
        };
        if (this.myProcessSameSymbols) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)processor2, project2);
        } else {
            processor2.process((Object)this.mySymbol);
        }
        OCFile context = this.mySymbol.getContainingOCFile(project2);
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            CodeEditUtil.addChild((ASTNode)node, (ASTNode)OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), (ASTNode)node.getFirstChildNode());
        }
    }
}

