/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import org.jetbrains.annotations.NotNull;

public class OCChangeARCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private ARCAttribute myAttribute;
    private final String myText;

    public OCChangeARCAttributeIntentionAction(@NotNull OCSymbol symbol, ARCAttribute attribute, @NotNull OCCompilationContext context) {
        super(context.getProject(), symbol);
        this.myAttribute = attribute;
        this.myText = "Make " + this.mySymbol.getNameWithKindLowercase(context) + " " + this.myAttribute.getTokenName();
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return "Change ARC attribute";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        PsiElement declarator = this.mySymbol.locateDefinition(project2);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCDeclaration.class);
        if (declaration == null) {
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement == null) {
            return;
        }
        OCChangeARCAttributeIntentionAction.removeOldAttributes(typeElement);
        OCChangeARCAttributeIntentionAction.removeOldAttributes(declarator);
        OCChangeUtil.changeText(declaration.getProject(), declaration.getContainingFile(), declaration.getTextOffset(), 0, this.myAttribute.getTokenName() + " ", true);
    }

    private static void removeOldAttributes(PsiElement typeElement) {
        for (ASTNode node : typeElement.getNode().getChildren(null)) {
            IElementType elementType = node.getElementType();
            if (elementType != OCTokenTypes.STRONG_KEYWORD && elementType != OCTokenTypes.WEAK_KEYWORD && elementType != OCTokenTypes.UNSAFE_UNRETAINED_KEYWORD && elementType != OCTokenTypes.AUTORELEASING_KEYWORD) continue;
            OCChangeUtil.delete(node.getPsi());
        }
    }
}

