/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionConstAction
extends OCChangeTypeIntentionAction {
    private final OCFunctionSymbol myFunctionSymbol;
    private final boolean myIsConst;

    private OCChangeFunctionConstAction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCFunctionType oldType, boolean isConst, @NotNull OCCompilationContext context) {
        super(functionSymbol, oldType.cloneWithFunctionAttributes(isConst, oldType.isVolatile(), oldType.isLValueRef(), oldType.isRValueRef()), context);
        this.myFunctionSymbol = functionSymbol;
        this.myIsConst = isConst;
    }

    public OCChangeFunctionConstAction(@NotNull OCFunctionSymbol functionSymbol, boolean isConst, @NotNull OCCompilationContext context) {
        this(functionSymbol, functionSymbol.getType(), isConst, context);
    }

    @Override
    protected String getTextInternal() {
        return "Make " + this.myFunctionSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myFunctionSymbol, this.myProject)) + (this.myIsConst ? " const" : " non-const");
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Change const qualifier";
    }
}

