/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionVolatileAction
extends OCChangeTypeIntentionAction {
    private final OCFunctionSymbol myFunctionSymbol;
    private final boolean myIsVolatile;

    private OCChangeFunctionVolatileAction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCFunctionType oldType, boolean isVolatile, @NotNull OCCompilationContext context) {
        super(functionSymbol, oldType.cloneWithFunctionAttributes(oldType.isConst(), isVolatile, oldType.isLValueRef(), oldType.isRValueRef()), context);
        this.myFunctionSymbol = functionSymbol;
        this.myIsVolatile = isVolatile;
    }

    public OCChangeFunctionVolatileAction(@NotNull OCFunctionSymbol functionSymbol, boolean isVolatile, @NotNull OCCompilationContext context) {
        this(functionSymbol, functionSymbol.getType(), isVolatile, context);
    }

    @Override
    protected String getTextInternal() {
        return "Make " + this.myFunctionSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myFunctionSymbol, this.myProject)) + (this.myIsVolatile ? " volatile" : " non-volatile");
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Change volatile qualifier";
    }
}

