/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeGCCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private String myAttribute;
    private String myAttributeText;
    private boolean myEnable;
    private String myText;

    public OCChangeGCCAttributeIntentionAction(@NotNull OCSymbol symbol, String attribute, String attributeText, boolean enable, @NotNull OCCompilationContext context) {
        super(context.getProject(), symbol);
        this.myAttribute = attribute;
        this.myAttributeText = attributeText;
        this.myEnable = enable;
        this.myText = (enable ? "Enable '" : "Disable '") + this.myAttributeText + "' for " + symbol.getNameWithKindLowercase(context);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myEnable ^ this.mySymbol.hasAttribute(this.myAttribute);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return "Change attribute '" + this.myAttributeText + "'";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        ArrayList definitions = new ArrayList();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            PsiElement definition = symbol1.locateDefinition(project2);
            if (definition != null) {
                definitions.add(definition);
            }
            return true;
        }), project2);
        for (PsiElement definition : definitions) {
            this.importFileContainingAttribute(definition);
            int offset = -1;
            if (definition instanceof OCDeclarator) {
                offset = definition.getTextRange().getStartOffset();
            } else if (definition instanceof OCStructLike) {
                offset = definition.getParent().getTextRange().getEndOffset();
            } else if (definition instanceof OCMethod) {
                List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                if (!parameters.isEmpty()) {
                    offset = parameters.get(parameters.size() - 1).getTextRange().getEndOffset();
                }
            } else if (definition instanceof OCMethodSelectorPart) {
                OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
                if (typeElement != null) {
                    offset = typeElement.getTextOffset();
                }
            } else if (definition instanceof OCLabeledStatement) {
                offset = definition.getTextOffset();
            } else assert (false) : definition.getClass();
            if (offset == -1) continue;
            if (this.myEnable) {
                OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), offset, 0, " " + this.myAttributeText + " ", true);
                continue;
            }
            int index = definition.getText().indexOf(this.myAttributeText);
            if (index == -1) continue;
            OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), definition.getTextRange().getStartOffset() + index, this.myAttributeText.length(), "", true);
        }
    }

    private void importFileContainingAttribute(PsiElement definition) {
        PsiFile file = definition.getContainingFile();
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        context.setProcessNonImported(true);
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.with(this.myAttributeText));
        List<OCSymbol> unusedSymbols = context.resolveToSymbols(ref);
        for (OCSymbol unused : unusedSymbols) {
            if (unused.getKind() == OCSymbolKind.MACRO && new OCImportSymbolFix((PsiElement)definition.getContainingFile(), unused).fixFirstItem(file.getProject(), file)) break;
        }
    }
}

