/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCChangeTextIntentionAction
extends OCPsiElementQuickFix<PsiFile> {
    private int myOffset;
    private int myLength;
    private String mySubstitution;
    private String myIntentionName;
    private String myFamilyName;

    public OCChangeTextIntentionAction(@NotNull PsiFile file, int offset, int length, String substitution, String intentionName) {
        this(file, offset, length, substitution, intentionName, intentionName);
    }

    public OCChangeTextIntentionAction(@NotNull PsiFile file, int offset, int length, String substitution, String intentionName, String familyName) {
        super(file);
        this.myOffset = offset;
        this.myLength = length;
        this.mySubstitution = substitution;
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiFile file) {
        return this.mySubstitution != null;
    }

    @Override
    protected void invoke(PsiFile curFile, @NotNull PsiFile file) {
        OCChangeUtil.changeText(file.getProject(), file, this.myOffset, this.myLength, this.mySubstitution, true);
    }
}

