/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCreateDefaultConstructorFix
implements IntentionAction {
    private final OCStructSymbol myClass;
    private boolean myAddParametersForBaseClasses;
    private final Project myProject;

    public OCCreateDefaultConstructorFix(OCStructSymbol symbol, boolean addParametersForBaseClasses, Project project2) {
        this.myClass = symbol;
        this.myAddParametersForBaseClasses = addParametersForBaseClasses;
        this.myProject = project2;
    }

    @NotNull
    public String getText() {
        if (this.myAddParametersForBaseClasses) {
            return "Create new constructor in " + this.myClass.getName() + " matching base class(es)";
        }
        return "Create new constructor '" + this.myClass.getName() + "()'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.myClass, project2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        new OCGenerateConstructorHandler(){

            @Override
            @NotNull
            protected List<? extends OCStructSymbol> getParents(@NotNull PsiElement at) {
                return Collections.singletonList(OCCreateDefaultConstructorFix.this.myClass);
            }

            @Override
            protected boolean addParametersForBaseClasses() {
                return OCCreateDefaultConstructorFix.this.myAddParametersForBaseClasses;
            }

            @Override
            protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
                return false;
            }

            @Override
            @NotNull
            protected Condition<OCDeclaratorSymbol> getCandidatesFilter(@NotNull OCGenerateConstructorContext actionContext) {
                return Conditions.alwaysFalse();
            }
        }.invoke(project2, null, file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

