/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class OCImplementMethodIntentionAction
extends OCImplementOCMethodsHandler
implements IntentionAction {
    private OCMethodSymbol myMethod;
    private final Project myProject;

    public OCImplementMethodIntentionAction(OCMethodSymbol method, Project project2) {
        this.myMethod = method;
        this.myProject = project2;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        if (this.myMethod == null) {
            return "Invalid";
        }
        return "Implement " + this.myMethod.getNameWithKindLowercase(OCCompilationContext.create(this.myMethod, this.myProject));
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.myMethod, project2);
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean selectAllCandidates() {
        return false;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        return this.myMethod.getParent();
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                return Collections.singletonList(OCImplementMethodIntentionAction.this.myMethod);
            }
        };
    }
}

