/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCIncludeSuggester;
import com.jetbrains.cidr.lang.quickfixes.OCNewImportLocation;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSymbolFix
implements HintAction,
HighPriorityAction {
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final OCFile myCurrentFile;
    private final boolean myForceIncludeMode;
    private final boolean myIgnoreFileScopeCheck;
    @NotNull
    private final List<AutoImportItem> myItems = new ArrayList<AutoImportItem>();

    public OCImportSymbolFix(@NotNull OCReferenceElement reference) {
        this(reference, (OCSymbolGroupContext)null);
    }

    public OCImportSymbolFix(@NotNull OCReferenceElement reference, @Nullable OCSymbolGroupContext symbolContext) {
        this.myElement = reference;
        this.myCurrentFile = reference.getContainingOCFile();
        this.myForceIncludeMode = false;
        this.myIgnoreFileScopeCheck = false;
        if (symbolContext == null) {
            symbolContext = OCSymbolGroupContext.union(reference.getSymbolContext(), OCSymbolKind.MACRO);
        }
        if (this.myCurrentFile != null && reference.resolveToSymbol(symbolContext) == null) {
            THashSet addedFiles = new THashSet();
            ArrayList<AutoImportItem> possibleItems = new ArrayList<AutoImportItem>();
            for (OCSymbol symbol : reference.resolveToOverloadsSymbols(symbolContext, true)) {
                VirtualFile containingFile;
                OCSymbol toImport = OCImportSymbolFix.getSymbolToImport(symbol);
                if (toImport == null || (containingFile = toImport.getContainingFile()) == null || !addedFiles.add(containingFile)) continue;
                this.collectPossibleItems(toImport, null, this.myCurrentFile, false, possibleItems);
            }
            this.myItems.addAll(OCImportSymbolFix.prepareAutoImportItems(possibleItems, this.myCurrentFile, this.myElement, false));
        }
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports) {
        this(element, resolvedSymbolIgnoringImports, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode) {
        this(element, resolvedSymbolIgnoringImports, forceIncludeMode, true);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode, boolean allowInternalHeaders) {
        this(element, resolvedSymbolIgnoringImports, forceIncludeMode, allowInternalHeaders, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode, boolean allowInternalHeaders, boolean ignoreFileScopeCheck) {
        this.myElement = element;
        this.myCurrentFile = element != null ? (OCFile)element.getContainingFile() : null;
        this.myForceIncludeMode = forceIncludeMode;
        this.myIgnoreFileScopeCheck = ignoreFileScopeCheck;
        if (resolvedSymbolIgnoringImports != null) {
            OCSymbol toImport = OCImportSymbolFix.getSymbolToImport(resolvedSymbolIgnoringImports);
            if (this.myCurrentFile != null && toImport != null && !OCFileSymbols.isSymbolImported(this.myCurrentFile, toImport, element)) {
                ArrayList<AutoImportItem> possibleItems = new ArrayList<AutoImportItem>();
                PsiElement insertBefore = this.calculateInsertBefore(toImport);
                this.collectPossibleItems(toImport, insertBefore, this.myCurrentFile, allowInternalHeaders, possibleItems);
                this.myItems.addAll(OCImportSymbolFix.prepareAutoImportItems(possibleItems, this.myCurrentFile, this.myElement, false));
            }
        }
    }

    private void collectPossibleItems(@NotNull OCSymbol toImport, @Nullable PsiElement insertBefore, @NotNull OCFile currentFile, boolean allowInternalHeaders, @NotNull List<AutoImportItem> result) {
        Collection<VirtualFile> filesToImport = OCImportSymbolFix.getFilesToImport(toImport, allowInternalHeaders, currentFile);
        for (VirtualFile file : filesToImport) {
            OCAutoImportHelper.ImportSpecification spec = OCImportSymbolFix.getFileNameToImport(file, currentFile);
            if (spec == null) continue;
            result.add(new AutoImportItem(toImport, insertBefore, file, spec, OCCompilationContext.create(currentFile)));
        }
    }

    @Nullable
    private static OCSymbol getSymbolToImport(@Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        if (symbol.isSynthetic()) {
            return null;
        }
        if (symbol.isPredeclaration() && (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol)) {
            return null;
        }
        while (true) {
            OCSymbol parent;
            OCSymbol oCSymbol = parent = symbol instanceof OCSymbolWithParent ? ((OCSymbolWithParent)symbol).getParent() : null;
            if (parent == null || parent.getKind() == OCSymbolKind.NAMESPACE) {
                symbol = symbol.getContainingFile() == null ? null : symbol;
                break;
            }
            if (symbol instanceof OCNamespaceSymbol) break;
            symbol = parent;
        }
        if (symbol != null && !symbol.isGlobal()) {
            return null;
        }
        return symbol;
    }

    @Nullable
    private PsiElement calculateInsertBefore(@NotNull OCSymbol symbolToImport) {
        if (this.myElement != null) {
            OCFile file = (OCFile)this.myElement.getContainingFile();
            OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file.getProject()).forFile(file);
            Pair<OCSymbol, VirtualFile> pair2 = symbols.getUndefinedClasses().get(symbolToImport.getName());
            if (pair2 == null) {
                pair2 = symbols.getUndefinedProtocols().get(symbolToImport.getName());
            }
            if (pair2 != null) {
                return file.findIncludeDirective((VirtualFile)pair2.getSecond());
            }
        }
        return null;
    }

    public boolean hasAutoImportItems() {
        return !this.getAutoImportItems().isEmpty();
    }

    private boolean hasDifferentSymbolKinds() {
        OCSymbolKind prevKind = null;
        for (AutoImportItem each : this.getAutoImportItems()) {
            OCSymbolKind eachKind = each.mySymbolToImport.getKind();
            if (prevKind != null && prevKind != eachKind) {
                return true;
            }
            prevKind = eachKind;
        }
        return false;
    }

    @NotNull
    public synchronized List<AutoImportItem> getAutoImportItems() {
        return this.myItems;
    }

    @NotNull
    private static List<AutoImportItem> prepareAutoImportItems(@NotNull List<AutoImportItem> items, @NotNull OCFile currentFile, @NotNull PsiElement element, boolean forceIncludeMode) {
        THashSet addedFiles = new THashSet();
        ArrayList<AutoImportItem> toProcess = new ArrayList<AutoImportItem>(items);
        ArrayList<AutoImportItem> result = new ArrayList<AutoImportItem>(items.size());
        while (!toProcess.isEmpty()) {
            AutoImportItem each = (AutoImportItem)toProcess.remove(0);
            ImportStyle importStyle = OCImportSymbolFix.getImportStyle(each, element, forceIncludeMode);
            if (OCImportSymbolFix.isFromSameFile(each, element) && (importStyle == ImportStyle.INCLUDE || each.mySymbolToImport.getOffset() <= element.getTextOffset() || each.mySymbolToImport instanceof OCImplementationSymbol)) continue;
            OCAutoImportHelper.ImportSpecification fileSpec = each.getFileSpecToImport();
            String textToInsert = importStyle == ImportStyle.INCLUDE ? fileSpec.getImportText() : each.mySymbolToImport.getName();
            if (!OCImportSymbolFix.isImportRequired(currentFile, textToInsert, element) || !addedFiles.add(each.getFileToImport())) continue;
            result.add(each);
        }
        Collections.sort(result, (o1, o2) -> {
            VirtualFile f1 = o1.getFileToImport();
            VirtualFile f2 = o2.getFileToImport();
            int result11 = Comparing.compare((Comparable)((Object)((AutoImportItem)o1).getFileSpecToImport().getKind()), (Comparable)((Object)((AutoImportItem)o2).getFileSpecToImport().getKind()));
            if (result11 != 0) {
                return result11;
            }
            OCSymbolKind k1 = ((AutoImportItem)o1).mySymbolToImport.getKind();
            OCSymbolKind k2 = ((AutoImportItem)o2).mySymbolToImport.getKind();
            result11 = Comparing.compare((boolean)k1.isClass(), (boolean)k2.isClass());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isStructLike(), (boolean)k2.isStructLike());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isTypedefOrAlias(), (boolean)k2.isTypedefOrAlias());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((k1 == OCSymbolKind.MACRO ? 1 : 0) != 0, (k2 == OCSymbolKind.MACRO ? 1 : 0) != 0);
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isCallable(), (boolean)k2.isCallable());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isVariable(), (boolean)k2.isVariable());
            if (result11 != 0) {
                return -result11;
            }
            result11 = k1.ordinal() - k2.ordinal();
            if (result11 != 0) {
                return result11;
            }
            return StringUtil.compare((String)f1.getPath(), (String)f2.getPath(), (boolean)true);
        });
        return result;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (!OCCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        OCLog.LOG.assertTrue(this.myElement != null);
        Pair<String, Boolean> text = this.getText(true);
        String hintText = ShowAutoImportPass.getMessage((boolean)((Boolean)text.second), (String)StringUtil.escapeXmlEntities((String)((String)text.first)));
        TextRange range = OCElementUtil.getRangeWithMacros(this.myElement);
        PsiFile file = this.myElement.getContainingFile();
        Project project2 = file.getProject();
        HintManager.getInstance().showQuestionHint(editor, hintText, range.getStartOffset(), range.getEndOffset(), () -> {
            if (this.myElement.isValid() && this.isAvailable(project2, editor, file)) {
                this.invoke(project2, editor, file);
            }
            return true;
        });
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return "Import symbol";
    }

    @NotNull
    public String getText() {
        if (!this.hasAutoImportItems()) {
            return this.getFamilyName();
        }
        return (String)this.getText((boolean)false).first;
    }

    @NotNull
    public Pair<String, Boolean> getText(boolean forPopup) {
        List<AutoImportItem> items = this.getAutoImportItems();
        String text = this.hasDifferentSymbolKinds() ? (forPopup ? "which" : "symbol") + " '" + items.get(0).mySymbolToImport.getName() + "'" : (String)items.get((int)0).getTitleAndLocation().first;
        if (!forPopup) {
            text = "Import " + text;
        }
        if (items.size() == 1) {
            text = text + " from " + (String)items.get((int)0).getTitleAndLocation().second;
        }
        return Pair.create((Object)text, (Object)(items.size() > 1 ? 1 : 0));
    }

    @NotNull
    private static String getTextToInsert(@NotNull AutoImportItem item, @NotNull ImportStyle importStyle, @NotNull PsiElement element) {
        if (!element.isValid()) {
            return "";
        }
        if (importStyle == ImportStyle.PREDECLARE) {
            return (item.mySymbolToImport instanceof OCProtocolSymbol ? "@protocol " : "@class ") + item.mySymbolToImport.getName() + ";";
        }
        PsiFile targetFile = element.getContainingFile();
        String directive = targetFile instanceof OCFile && ((OCFile)targetFile).getKind().isObjC() ? "#import" : "#include";
        return directive + " " + item.getFileSpecToImport().getImportText();
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull AutoImportItem item, @NotNull PsiElement element, boolean forceIncludeMode) {
        if (forceIncludeMode || !(item.mySymbolToImport instanceof OCClassSymbol)) {
            return ImportStyle.INCLUDE;
        }
        boolean isSuperclass = element.getParent() instanceof OCSuperClassRef;
        boolean isSuperProtocol = element.getParent() instanceof OCProtocolList;
        if (isSuperclass || isSuperProtocol) {
            return ImportStyle.INCLUDE;
        }
        if (OCImportSymbolFix.isFromSameFile(item, element)) {
            return ImportStyle.PREDECLARE;
        }
        boolean isInclude = OCCodeInsightSettings.getInstance().HEADER_IMPORT_STYLE == OCCodeStyleSettings.HeaderImportStyle.IMPORT || !((OCFile)element.getContainingFile()).isHeader();
        return isInclude ? ImportStyle.INCLUDE : ImportStyle.PREDECLARE;
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, PsiFile file) {
        if (!(file instanceof OCFile) || file instanceof OCCodeFragment) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (!this.myIgnoreFileScopeCheck && !OCSearchScope.isInProjectSources(this.myElement)) {
            return false;
        }
        return this.hasAutoImportItems();
    }

    private static boolean isImportRequired(@NotNull PsiFile file, @NotNull String textToInsert, @NotNull PsiElement unresolvedElement) {
        for (PsiElement element : file.getChildren()) {
            if (element instanceof OCIncludeDirective && element.getText().contains(textToInsert)) {
                return false;
            }
            if (element instanceof OCClassPredeclarationList) {
                for (OCClassPredeclaration predefinition : ((OCClassPredeclarationList)element).getPredeclarations()) {
                    if (!textToInsert.equals(predefinition.getName())) continue;
                    return false;
                }
            }
            if (element.getTextOffset() >= unresolvedElement.getTextOffset()) break;
        }
        return true;
    }

    private static boolean isFromSameFile(@NotNull AutoImportItem item, @NotNull PsiElement element) {
        return element.isValid() && Comparing.equal((Object)item.mySymbolToImport.getContainingFile(), (Object)element.getContainingFile().getVirtualFile());
    }

    private static boolean accumulateImportCandidates(@NotNull Project project2, @NotNull VirtualFile mainCandidate, @NotNull Map<VirtualFile, Boolean> acc, boolean isProxy) {
        if (acc.containsKey(mainCandidate)) {
            return false;
        }
        acc.put(mainCandidate, isProxy);
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        for (VirtualFile includer : OCImportSymbolFix.getIncludingFiles(mainCandidate, project2)) {
            if (includer == null || !includer.isValid() || !OCFileImpl.isHeaderFile(includer.getName()) || acc.containsKey(includer)) continue;
            boolean includerIsProxy = isProxy && OCImportSymbolFix.isUmbrellaFile(cache, includer);
            OCImportSymbolFix.accumulateImportCandidates(project2, includer, acc, includerIsProxy);
        }
        return true;
    }

    private static boolean isUmbrellaFile(@NotNull FileSymbolTablesCache cache, @NotNull VirtualFile includer) {
        Ref proxyFile = new Ref((Object)true);
        for (FileSymbolTable table : cache.allTablesForFile(includer)) {
            table.shallowProcessSymbols((Processor<? super OCSymbol>)((Processor)symbol -> {
                OCSymbolKind kind = symbol.getKind();
                if (kind != OCSymbolKind.MACRO && kind != OCSymbolKind.UNDEF_MACRO && kind != OCSymbolKind.SYMBOL_USING_SYMBOL && kind != OCSymbolKind.NAMESPACE_USING_SYMBOL && kind != OCSymbolKind.NAMESPACE_ALIAS && kind != OCSymbolKind.IMPORT && kind != OCSymbolKind.TYPEDEF) {
                    proxyFile.set((Object)false);
                    return false;
                }
                return true;
            }));
            if (((Boolean)proxyFile.get()).booleanValue()) continue;
            break;
        }
        return (Boolean)proxyFile.get();
    }

    @NotNull
    private static Collection<VirtualFile> getIncludingFiles(@NotNull VirtualFile file, @NotNull Project project2) {
        return OCImportGraph.findImmediateIncludingFiles(project2, file, false);
    }

    public void invoke(final @NotNull Project project2, @NotNull Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (this.getAutoImportItems().size() == 1) {
            this.getAutoImportItems().get(0).invoke(project2, file);
            return;
        }
        BaseListPopupStep<AutoImportItem> step = new BaseListPopupStep<AutoImportItem>("Symbol to Import", this.getAutoImportItems()){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(AutoImportItem selectedValue, boolean finalChoice) {
                if (finalChoice && selectedValue != null) {
                    this.doFinalStep(() -> selectedValue.invoke(project2, file));
                }
                return FINAL_CHOICE;
            }

            public boolean hasSubstep(AutoImportItem item) {
                return false;
            }

            @NotNull
            public String getTextFor(AutoImportItem item) {
                Pair<String, String> titleAndLocation = item.getTitleAndLocation();
                return (String)titleAndLocation.first + " @ " + (String)titleAndLocation.second;
            }

            public Icon getIconFor(AutoImportItem item) {
                return item.mySymbolToImport.getIcon(project2);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){

            protected ListCellRenderer getListElementRenderer() {
                return new MyRenderer(this.mySpeedSearch, project2);
            }
        };
        popup.showInBestPositionFor(editor);
    }

    @NotNull
    public static OCNewImportLocation calcNewImportLocation(@NotNull OCFile file, int beforeOffset, @NotNull String insertText, @NotNull ImportStyle importStyle, @Nullable OCIncludeDirective.Delimiters delimiters) {
        PsiElement sibling;
        OCDirective beginIfndefDirective;
        PsiElement firstImport = null;
        PsiElement lastImport = null;
        PsiElement lastLibraryImport = null;
        PsiElement lastProjectImport = null;
        PsiElement lastClassPredef = null;
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findHeaderGuard(file, false);
        OCDirective oCDirective = beginIfndefDirective = headerGuardInfo != null ? headerGuardInfo.getBeginIfndefDirective() : null;
        PsiElement firstScanNode = beginIfndefDirective != null ? ((sibling = OCElementUtil.getNextNonWhitespaceSibling(beginIfndefDirective)) == null ? null : sibling.getNextSibling()) : file.getFirstChild();
        boolean skipInessentialNodes = true;
        PsiElement lastInessential = null;
        for (PsiElement kid = firstScanNode; kid != null && (beforeOffset == -1 || kid.getTextOffset() < beforeOffset); kid = kid.getNextSibling()) {
            if (skipInessentialNodes) {
                if (OCElementUtil.isEssentialNode(kid)) {
                    skipInessentialNodes = false;
                } else {
                    lastInessential = kid;
                }
            }
            if (kid instanceof OCIncludeDirective) {
                if (kid.getText().contains(insertText)) {
                    return new OCNewImportLocation(null, false, kid);
                }
                lastImport = kid;
                if (firstImport == null) {
                    firstImport = kid;
                }
                if (((OCIncludeDirective)kid).isAngleBrackets()) {
                    lastLibraryImport = kid;
                } else {
                    lastProjectImport = kid;
                }
            }
            if (!(kid instanceof OCClassPredeclarationList)) continue;
            lastClassPredef = kid;
        }
        PsiElement insertAnchor = lastImport;
        boolean insertBefore = false;
        if (importStyle == ImportStyle.INCLUDE) {
            if (delimiters == OCIncludeDirective.Delimiters.ANGLE_BRACKETS) {
                if (lastLibraryImport != null) {
                    insertAnchor = lastLibraryImport;
                } else {
                    insertAnchor = firstImport;
                    insertBefore = true;
                }
            } else if (lastProjectImport != null) {
                insertAnchor = lastProjectImport;
            }
        } else {
            insertAnchor = lastClassPredef;
            if (insertAnchor == null) {
                insertAnchor = lastImport;
            }
        }
        if (insertAnchor == null) {
            insertAnchor = lastInessential;
            insertBefore = false;
        }
        if (insertAnchor == null) {
            insertAnchor = file.getFirstChild();
            insertBefore = true;
        }
        return new OCNewImportLocation(insertAnchor, insertBefore, null);
    }

    public static PsiElement addImportToFile(OCFile file, String insertText, @NotNull ImportStyle importStyle, int beforeOffset) {
        PsiElement newElement = OCElementFactory.topLevelDeclarationFromText(insertText, file);
        OCIncludeDirective.Delimiters delimiters = newElement instanceof OCIncludeDirective ? ((OCIncludeDirective)newElement).getDelimiters() : null;
        OCNewImportLocation location = OCImportSymbolFix.calcNewImportLocation(file, beforeOffset, insertText, importStyle, delimiters);
        if (location.getExisting() != null) {
            return location.getExisting();
        }
        PsiElement newImport = OCChangeUtil.addHandlingMacros(file, newElement, location.getInsertAnchor(), location.getInsertBefore());
        OCChangeUtil.addNewLineAfterIfNeed(newImport);
        return newImport;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void fixAfterCompletionAtCaret(Editor editor, PsiFile file, OCSymbol symbol) {
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0) {
            OCImportSymbolFix.fixAfterCompletionAtOffset(editor, file, offset, symbol);
        }
    }

    public static void fixAfterCompletionAtCaret(Editor editor, PsiFile file, OCSymbolGroupContext symbolContext) {
        OCReferenceElement ref;
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0 && (ref = (OCReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, OCReferenceElement.class, (boolean)false)) != null) {
            new OCImportSymbolFix(ref, symbolContext).fixFirstItem(file.getProject(), file);
        }
    }

    private static int calculateOffset(Editor editor) {
        CharSequence text = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        if (offset >= text.length()) {
            return -1;
        }
        while (offset > 0 && Character.isJavaIdentifierPart(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        return offset;
    }

    public static void fixAfterCompletionAtOffset(Editor editor, PsiFile file, int offset, OCSymbol symbol) {
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        OCElement ref = (OCElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, OCElement.class, (boolean)false);
        new OCImportSymbolFix(ref, symbol).fixFirstItem(file.getProject(), file);
    }

    public static void fixAllSymbolsRecursively(PsiElement element) {
        OCImportSymbolFix.fixAllSymbolsRecursively(element, null);
    }

    public static void fixAllSymbolsRecursively(PsiElement element, @Nullable TextRange range) {
        final PsiFile containingFile = element.getContainingFile();
        final Project project2 = containingFile.getProject();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(range){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                new OCImportSymbolFix(referenceElement).fixFirstItem(project2, containingFile);
            }
        });
    }

    public boolean fixFirstItem(@NotNull Project project2, @NotNull PsiFile file) {
        AutoImportItem item;
        if (this.isAvailable(project2, null, file) && (item = (AutoImportItem)ContainerUtil.getFirstItem(this.getAutoImportItems())) != null) {
            item.invoke(project2, file);
            return true;
        }
        return false;
    }

    @Nullable
    public static OCAutoImportHelper.ImportSpecification getFileNameToImport(@NotNull VirtualFile fileToImport, @NotNull PsiFile currentFile) {
        if (!OCFileTypeHelpers.isHeaderFile(fileToImport.getName())) {
            return null;
        }
        Ref result = Ref.create(null);
        VirtualFile targetFile = currentFile.getVirtualFile();
        OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(currentFile.getVirtualFile(), currentFile.getProject());
        OCIncludeHelpers.processImportSpecifications(currentFile.getProject(), rootAndConfiguration, targetFile, fileToImport, (Processor<OCAutoImportHelper.ImportSpecification>)((Processor)specification -> {
            result.set(specification);
            return false;
        }));
        return (OCAutoImportHelper.ImportSpecification)result.get();
    }

    @NotNull
    private static Collection<VirtualFile> getFilesToImport(@NotNull OCSymbol symbol, boolean allowInternalHeaders, @NotNull PsiFile currentFile) {
        Collection<String> recommended;
        String idealName;
        Set<VirtualFile> best;
        THashMap acc = new THashMap();
        Project project2 = currentFile.getProject();
        OCFile file = symbol.getContainingOCFile(project2);
        if (file == null) {
            return Collections.emptyList();
        }
        VirtualFile vf = file.getVirtualFile();
        if (vf != null) {
            OCImportSymbolFix.accumulateImportCandidates(file.getProject(), vf, (Map<VirtualFile, Boolean>)acc, true);
        }
        if (!(best = ContainerUtil.filter((Map)acc, arg_0 -> OCImportSymbolFix.lambda$getFilesToImport$4(idealName = symbol.getName(), recommended = OCIncludeSuggester.getRecommendedHeaderNames(symbol, currentFile), arg_0)).keySet()).isEmpty()) {
            return best;
        }
        ArrayList candidates = new ArrayList();
        for (Map.Entry entry : acc.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            candidates.add(entry.getKey());
        }
        VirtualFile shortestNameFile = null;
        int shortestName = Integer.MAX_VALUE;
        for (VirtualFile candidate : candidates) {
            int length;
            OCAutoImportHelper.ImportSpecification importSpecification;
            if (!allowInternalHeaders && candidate.getName().startsWith("_") && OCSearchScope.isInLibraries(candidate, project2) || (importSpecification = OCImportSymbolFix.getFileNameToImport(candidate, currentFile)) == null || (length = importSpecification.getImportPath().length()) >= shortestName) continue;
            shortestNameFile = candidate;
            shortestName = length;
        }
        return shortestNameFile == null ? Collections.emptyList() : Collections.singletonList(shortestNameFile);
    }

    private static /* synthetic */ boolean lambda$getFilesToImport$4(String idealName, Collection recommended, VirtualFile virtualFile) {
        String name2 = virtualFile.getName();
        String nameBase = FileUtil.getNameWithoutExtension((String)name2);
        return nameBase.equals(idealName) || recommended.contains(name2);
    }

    private static class MyRenderer
    extends JPanel
    implements ListCellRenderer<AutoImportItem> {
        final ColoredListCellRenderer<AutoImportItem> myLeft;
        final ColoredListCellRenderer<AutoImportItem> myRight;
        @NotNull
        final Project myProject;

        MyRenderer(final SpeedSearch speedSearch, @NotNull Project project2) {
            super(new BorderLayout());
            this.myProject = project2;
            this.myLeft = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    myLeft.clear();
                    Pair<String, String> titleAndLocation = value.getTitleAndLocation();
                    myLeft.setIcon(value.mySymbolToImport.getIcon(myProject));
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.first), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)this.getBackground(), (boolean)selected);
                }
            };
            this.myRight = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    Pair<String, String> titleAndLocation = value.getTitleAndLocation();
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.second), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)this.getBackground(), (boolean)selected);
                }
            };
            this.add((Component)this.myLeft, "Center");
            this.add((Component)this.myRight, "East");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fileColor;
            FileColorManager colorManager;
            PsiFile file;
            Color bgColor;
            Color color = bgColor = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
            if (!isSelected && value != null && (file = value.mySymbolToImport.getContainingPsiFile(this.myProject)) != null && (colorManager = FileColorManager.getInstance((Project)this.myProject)).isEnabled() && (fileColor = colorManager.getRendererBackground(file)) != null) {
                bgColor = fileColor;
            }
            this.setBackground(bgColor);
            this.myLeft.getListCellRendererComponent(list, (Object)value, index, isSelected, false);
            this.myRight.getListCellRendererComponent(list, (Object)value, index, isSelected, false);
            return this;
        }
    }

    public class AutoImportItem {
        @NotNull
        private final OCSymbol mySymbolToImport;
        @Nullable
        private final PsiElement myInsertBefore;
        @NotNull
        private final VirtualFile myFileToImport;
        @NotNull
        private final OCAutoImportHelper.ImportSpecification myFileNameToImport;
        @NotNull
        private final OCCompilationContext myCompilationContext;
        @Nullable
        private Pair<String, String> myCachedTitleAndLocation;

        public AutoImportItem(@Nullable OCSymbol symbolToImport, @NotNull PsiElement insertBefore, @NotNull VirtualFile fileToImport, @NotNull OCAutoImportHelper.ImportSpecification fileNameToImport, OCCompilationContext context) {
            this.mySymbolToImport = symbolToImport;
            this.myInsertBefore = insertBefore;
            this.myFileToImport = fileToImport;
            this.myFileNameToImport = fileNameToImport;
            this.myCompilationContext = context;
        }

        public String toString() {
            Pair<String, String> titleAndLocation = this.getTitleAndLocation();
            return (String)titleAndLocation.first + "@" + (String)titleAndLocation.second;
        }

        @NotNull
        public Pair<String, String> getTitleAndLocation() {
            OCResolveContext context;
            OCQualifiedName resolvedName;
            if (this.myCachedTitleAndLocation != null) {
                return this.myCachedTitleAndLocation;
            }
            String kind = this.mySymbolToImport.getKindLowercase(this.myCompilationContext);
            if (this.mySymbolToImport instanceof OCClassSymbol) {
                kind = "@" + kind;
            }
            String name2 = this.mySymbolToImport.getName();
            if (this.mySymbolToImport instanceof OCSymbolWithQualifiedName && (resolvedName = ((OCSymbolWithQualifiedName)this.mySymbolToImport).getResolvedQualifiedName(true, false, context = OCResolveContext.forSymbol(this.mySymbolToImport, this.myCompilationContext.getProject()))) != null) {
                name2 = resolvedName.getCanonicalName(OCType.Presentation.FULL, false, context, 0);
            }
            this.myCachedTitleAndLocation = Pair.create((Object)(kind + " '" + name2 + "'"), (Object)this.getFileSpecToImport().getImportText());
            return this.myCachedTitleAndLocation;
        }

        @NotNull
        private OCAutoImportHelper.ImportSpecification getFileSpecToImport() {
            return this.myFileNameToImport;
        }

        @NotNull
        public VirtualFile getFileToImport() {
            return this.myFileToImport;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file) throws IncorrectOperationException {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            VirtualFile fileToImport = this.getFileToImport();
            VirtualFile targetFile = file.getVirtualFile();
            for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
                each.addHeaderSearchPath(project2, targetFile, fileToImport);
            }
            PsiElement element = OCImportSymbolFix.this.myElement;
            assert (element != null);
            ImportStyle importStyle = OCImportSymbolFix.getImportStyle(this, element, OCImportSymbolFix.this.myForceIncludeMode);
            OCFile associatedFile = importStyle == ImportStyle.PREDECLARE ? ((OCFile)file).getAssociatedFile() : null;
            WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{file, associatedFile}).withName("Import " + (String)this.getTitleAndLocation().first).run(() -> {
                int beforeOffset = element.getTextOffset();
                if (this.myInsertBefore != null) {
                    beforeOffset = Math.min(beforeOffset, this.myInsertBefore.getTextOffset());
                }
                OCImportSymbolFix.addImportToFile((OCFile)file, OCImportSymbolFix.getTextToInsert(this, importStyle, element), importStyle, beforeOffset);
                if (associatedFile != null) {
                    OCImportSymbolFix.addImportToFile(associatedFile, OCImportSymbolFix.getTextToInsert(this, ImportStyle.INCLUDE, element), ImportStyle.INCLUDE, beforeOffset);
                }
            });
        }
    }

    public static enum ImportStyle {
        INCLUDE,
        PREDECLARE;

    }
}

