/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.NotNull;

public class OCMakeFunctionVirtualFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private boolean isPure;

    public OCMakeFunctionVirtualFix(@NotNull OCFunctionSymbol symbol, boolean pure, @NotNull Project project2) {
        super(project2, symbol);
        this.isPure = pure;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && ((OCFunctionSymbol)this.mySymbol).getParent() != null && !((OCFunctionSymbol)this.mySymbol).isCppConstructor() && !((OCFunctionSymbol)this.mySymbol).isFriendOrStatic();
    }

    @Override
    protected String getTextInternal() {
        return "Make " + ((OCFunctionSymbol)this.mySymbol).getParent().getName() + "::" + ((OCFunctionSymbol)this.mySymbol).getName() + (this.isPure ? " pure virtual" : " virtual");
    }

    @NotNull
    public String getFamilyName() {
        return "Make function virtual";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCFunctionDeclaration function = ((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project2);
        if (function != null) {
            int offset;
            if (this.isPure) {
                offset = function.getDeclarator().getTextRange().getEndOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "= 0", true);
            }
            if (!((OCFunctionSymbol)this.mySymbol).isVirtual()) {
                offset = function.getTextRange().getStartOffset();
                OCChangeUtil.changeText(function.getProject(), function.getContainingFile(), offset, 0, "virtual ", true);
            }
        }
    }
}

