/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public abstract class OCPsiElementQuickFix<T extends PsiElement>
extends OCQuickFix {
    @NotNull
    protected SmartPsiElementPointer<T> myElementPtr;

    protected OCPsiElementQuickFix(@NotNull T element) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
    }

    protected boolean isAvailable(@NotNull T element) {
        return true;
    }

    protected void invoke(PsiFile file, @NotNull T element) {
    }

    @Override
    public final boolean isAvailable() {
        T element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        return element != null && OCCodeInsightUtil.isValid(element) && this.isAvailable(element);
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project2) {
        T element = OCElementUtil.getPsiElementByPointer(this.myElementPtr);
        if (element != null) {
            this.invoke(file, element);
        }
    }

    @NotNull
    protected Project getProject() {
        return this.myElementPtr.getProject();
    }
}

