/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationButInitializerIntentionAction
extends OCRemoveDeclarationIntentionAction
implements HighPriorityAction {
    public OCRemoveDeclarationButInitializerIntentionAction(OCSymbol symbol, @NotNull Project project2) {
        super(symbol, project2);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, OCSymbol symbol, @NotNull Project project2) {
        super(whatToRemove, symbol, project2);
    }

    public OCRemoveDeclarationButInitializerIntentionAction(String whatToRemove, @Nullable PsiElement element, @NotNull Project project2) {
        super(whatToRemove, element, project2);
    }

    @Override
    @NotNull
    public String getText() {
        return super.getText() + " and leave initializer";
    }

    @Override
    public boolean isAvailable() {
        PsiElement element = this.getValidElementOrNull();
        if (element == null) {
            return false;
        }
        if (this.mySymbol != null && this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return false;
        }
        return OCRemoveDeclarationButInitializerIntentionAction.canLeaveInitializer(element) && OCRemoveDeclarationButInitializerIntentionAction.canTransformElement(element);
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement myElement;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement psiElement = myElement = this.mySymbol != null ? this.mySymbol.locateDefinition(project2) : this.myElementPtr.getElement();
        if (myElement == null || !FileModificationService.getInstance().prepareFileForWrite(myElement.getContainingFile())) {
            return;
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getContextOfType((PsiElement)myElement, OCStatement.class, (boolean)false);
        PsiElement initializerStatement = OCRemoveDeclarationButInitializerIntentionAction.getInitializerStatement(myElement, project2);
        if (parentStatement == null) {
            return;
        }
        OCRemoveDeclarationButInitializerIntentionAction.deleteUsages(myElement);
        if (!(parentStatement instanceof OCDeclarationStatement) || ((OCDeclarationStatement)parentStatement).getDeclaration().getDeclarators().size() == 1) {
            OCChangeUtil.replaceHandlingMacros(parentStatement, initializerStatement);
        } else {
            parentStatement.getParent().addAfter(initializerStatement, (PsiElement)parentStatement);
            OCChangeUtil.delete((PsiElement)(myElement instanceof OCDeclarator ? myElement : parentStatement));
        }
    }

    @NotNull
    private static PsiElement getInitializerStatement(@NotNull PsiElement element, @NotNull Project project2) {
        OCExpressionStatement initializer;
        if (element instanceof OCAssignmentExpression) {
            initializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(element);
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            OCChangeUtil.replaceHandlingMacros(initializer.getExpression(), assignmentExpression.getSourceExpression());
        } else if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
            OCType declaratorType = declarator.getType().resolve(resolveContext);
            initializer = declaratorType instanceof OCStructType ? OCRemoveDeclarationButInitializerIntentionAction.buildStructTypeInitializer(declarator, project2) : OCRemoveDeclarationButInitializerIntentionAction.buildBuiltinTypeInitializer(declarator);
        } else {
            initializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(element);
        }
        return OCCodeInsightUtil.insideLoopHeader(element) || OCCodeInsightUtil.insideConditionalHeader(element) ? initializer.getExpression() : initializer;
    }

    @NotNull
    private static OCExpressionStatement buildStructTypeInitializer(@NotNull OCDeclarator declarator, @NotNull Project project2) {
        OCExpression initializer = declarator.getInitializer();
        if (initializer == null) {
            initializer = declarator.getInitializerList();
        }
        if (initializer instanceof OCCompoundInitializer) {
            String declaratorTypeName = OCRemoveDeclarationButInitializerIntentionAction.getTypeName(declarator, project2);
            String initializerText = declaratorTypeName + initializer.getText();
            return (OCExpressionStatement)OCElementFactory.statementFromText(initializerText, declarator);
        }
        if (initializer != null) {
            OCExpressionStatement resultInitializer = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(declarator);
            OCChangeUtil.replaceHandlingMacros(resultInitializer.getExpression(), initializer);
            return resultInitializer;
        }
        String declaratorTypeName = OCRemoveDeclarationButInitializerIntentionAction.getTypeName(declarator, project2);
        OCArgumentList argumentList = declarator.getArgumentList();
        String ctorCallText = argumentList == null ? declaratorTypeName + "()" : "(" + declaratorTypeName + argumentList.getText() + ")";
        return (OCExpressionStatement)OCElementFactory.statementFromText(ctorCallText, declarator);
    }

    @NotNull
    private static OCExpressionStatement buildBuiltinTypeInitializer(@NotNull OCDeclarator declarator) {
        List<OCExpression> initializers = declarator.getInitializers();
        OCExpression initializer = initializers.get(0);
        if (initializer instanceof OCCompoundInitializer) {
            initializer = ((OCCompoundInitializer)initializer).getInitializerExpressions().get(0);
        }
        OCExpressionStatement result = OCRemoveDeclarationButInitializerIntentionAction.getDefaultInitializer(declarator);
        OCChangeUtil.replaceHandlingMacros(result.getExpression(), initializer);
        return result;
    }

    @NotNull
    private static OCExpressionStatement getDefaultInitializer(@NotNull PsiElement context) {
        return (OCExpressionStatement)OCElementFactory.statementFromText("1", context);
    }

    private static boolean canLeaveInitializer(@NotNull PsiElement element) {
        if (element instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            OCExpression sourceExpression = assignmentExpression.getSourceExpression();
            return sourceExpression != null && OCCodeInsightUtil.hasSideEffects(sourceExpression);
        }
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
            OCType declaratorType = declarator.getType().resolve(resolveContext);
            if (declaratorType.isUnknown() || declaratorType instanceof OCArrayType) {
                return false;
            }
            List<OCExpression> initializers = declarator.getInitializers();
            if (declaratorType instanceof OCStructType) {
                if (!initializers.isEmpty()) {
                    return true;
                }
                OCFunctionSymbol ctorSymbol = OCResolveUtil.resolveCtorCall(initializers, (OCStructType)declaratorType, resolveContext, element);
                return ctorSymbol != null && !ctorSymbol.isDefault() && !(ctorSymbol instanceof OCCompilerGeneratedConstructorSymbol);
            }
            if (initializers.size() != 1) {
                return false;
            }
            OCExpression initializer = initializers.get(0);
            if (!OCCodeInsightUtil.hasSideEffects(initializer)) {
                return false;
            }
            if (!(initializer instanceof OCCompoundInitializer)) {
                return true;
            }
            OCCompoundInitializer compoundInitializer = (OCCompoundInitializer)initializer;
            return compoundInitializer.getInitializerExpressions().size() == 1;
        }
        return false;
    }

    private static boolean canTransformElement(@NotNull PsiElement element) {
        if (element instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)element;
            return !OCElementUtil.isPartOfMacroSubstitution(assignmentExpression);
        }
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            OCExpression initializer = declarator.getInitializerList();
            if (initializer == null) {
                initializer = declarator.getInitializer();
            }
            if (initializer instanceof OCCompoundInitializer) {
                return !OCElementUtil.isPartOfMacroSubstitution(initializer) && !OCElementUtil.isPartOfMacroSubstitution(initializer.getFirstChild());
            }
            OCArgumentList argumentList = declarator.getArgumentList();
            if (argumentList != null && OCElementUtil.isPartOfMacroSubstitution(argumentList)) {
                return false;
            }
            return !OCElementUtil.isPartOfMacroSubstitution(declarator);
        }
        return false;
    }

    private static String getTypeName(@NotNull OCDeclarator declarator, @NotNull Project project2) {
        return declarator.getType().cloneWithoutCVQualifiers(project2).getBestNameInContext(declarator);
    }
}

