/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationIntentionAction
extends OCQuickFix {
    private final String myText;
    private final String myFamilyName;
    private final Project myProject;
    protected final OCSymbol mySymbol;
    protected final SmartPsiElementPointer<PsiElement> myElementPtr;

    public OCRemoveDeclarationIntentionAction(String whatToRemove, OCSymbol symbol, @NotNull Project project2) {
        this.myElementPtr = null;
        this.mySymbol = symbol;
        this.myFamilyName = "Remove " + (whatToRemove != null ? whatToRemove : "declaration of");
        this.myText = this.myFamilyName + " " + this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, project2));
        this.myProject = project2;
    }

    public OCRemoveDeclarationIntentionAction(String whatToRemove, @Nullable PsiElement element, @NotNull Project project2) {
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myText = "Remove " + whatToRemove;
        this.myFamilyName = "Remove " + whatToRemove;
        this.myProject = project2;
        this.mySymbol = null;
    }

    public OCRemoveDeclarationIntentionAction(OCSymbol symbol, @NotNull Project project2) {
        this(null, symbol, project2);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    public boolean startInWriteAction() {
        return this.mySymbol == null || this.mySymbol.getKind() != OCSymbolKind.PARAMETER;
    }

    @Override
    public boolean isAvailable() {
        PsiElement element = this.getValidElementOrNull();
        if (element == null) {
            return false;
        }
        if (this.mySymbol == null) {
            return true;
        }
        if (OCCodeInsightUtil.insideConditionalHeader(element)) {
            return false;
        }
        if (OCCodeInsightUtil.insideLoopHeader(element)) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCForStatement.class) != null;
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (this.mySymbol != null) {
            element = this.mySymbol.locateDefinition(project2);
        } else {
            PsiElement el = this.myElementPtr.getElement();
            PsiElement psiElement = element = el != null ? el.getContext() : null;
        }
        if (element == null || !FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        if (element instanceof OCLabeledStatement) {
            OCStatement statement2 = ((OCLabeledStatement)element).getStatement();
            if (statement2 != null) {
                element.replace((PsiElement)statement2);
            } else {
                OCChangeUtil.delete(element);
            }
        } else if (this.mySymbol != null && this.mySymbol.getKind() == OCSymbolKind.PARAMETER) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            if (callable == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> OCRemoveDeclarationIntentionAction.deleteUsages(element));
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, callable, true);
            handler.removeParameter(this.mySymbol.getName(), true);
            handler.invoke();
        } else {
            OCRemoveDeclarationIntentionAction.deleteUsages(element);
            OCChangeUtil.delete(element);
        }
    }

    protected static void deleteUsages(PsiElement element) {
        Collection usages = ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).findAll();
        for (PsiReference reference : usages) {
            OCChangeUtil.safeDeleteReference(reference.getElement());
        }
    }

    @Nullable
    protected PsiElement getValidElementOrNull() {
        if (this.mySymbol != null) {
            PsiElement element = this.mySymbol.locateDefinition(this.myProject);
            return element != null && OCSearchScope.isInProjectSources(this.mySymbol, this.myProject) && OCCodeInsightUtil.isValid(element) ? element : null;
        }
        PsiElement element = this.myElementPtr.getElement();
        return element != null && OCCodeInsightUtil.isValid(element) && element.getContext() instanceof OCStatement ? element : null;
    }
}

