/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OCRemoveTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCElementType myModifier;
    private final String myText;

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithParent symbol, OCElementType modifier, @NotNull Project project2) {
        this(symbol, modifier, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project2)), project2);
    }

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithParent symbol, OCElementType modifier, String subject, @NotNull Project project2) {
        super(project2, symbol);
        this.myModifier = modifier;
        this.myText = "Make " + subject + " non-" + this.myModifier.getName();
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return "Remove '" + this.myModifier.getName() + "'";
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (!(this.myModifier != OCTokenTypes.CONST_KEYWORD || ((OCDeclaratorSymbol)this.mySymbol).isConst() && this.mySymbol.getKind() != OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.BLOCK_KEYWORD || ((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable();
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)collector, project2);
        List psiSmartPointers = collector.getResults().stream().map(symbol1 -> symbol1.locateDefinition(project2)).filter(Objects::nonNull).map(OCElementUtil::createPsiElementPointer).collect(Collectors.toList());
        for (SmartPsiElementPointer pointer : psiSmartPointers) {
            OCTypeElement typeElement;
            PsiElement element = pointer.getElement();
            if (element == null || this.findAndRemove(element) || !(element instanceof OCDeclarator) || !(element.getParent() instanceof OCDeclaration) || (typeElement = ((OCDeclaration)element.getParent()).getTypeElement()) == null || this.findAndRemove(typeElement)) continue;
            this.findAndRemove(typeElement.getParent());
        }
    }

    private boolean findAndRemove(PsiElement element) {
        ASTNode[] children = element.getNode().getChildren(null);
        for (int i = children.length - 1; i >= 0; --i) {
            if (children[i].getElementType() != this.myModifier) continue;
            PsiElement psi = children[i].getPsi();
            if (psi != null) {
                OCChangeUtil.delete(psi);
            }
            return true;
        }
        return false;
    }
}

