/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;

public class OCRenameSymbolIntentionAction
extends OCSymbolQuickFix<OCSymbol>
implements HighPriorityAction {
    private final String myText;

    public OCRenameSymbolIntentionAction(@NotNull OCSymbol symbol, @NotNull OCCompilationContext context) {
        super(context.getProject(), symbol);
        this.myText = "Rename " + this.mySymbol.getNameWithKindLowercase(context);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return "Rename symbol";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCInplaceRenamer renamer;
        PsiElement element;
        if (editor != null && (element = this.mySymbol.locateDefinition(project2)) != null && (renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor)) != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                renamer.performRenameInner(element, "renamed");
            } else {
                renamer.performInplaceRename();
            }
        }
    }
}

