/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSetSuperclassIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCSymbol mySuperClass;
    private OCVisibility myVisibility;
    private final String myText;

    public OCSetSuperclassIntentionAction(@NotNull OCSymbol classSymbol, OCSymbol superClass, @Nullable OCVisibility visibility, @NotNull OCCompilationContext context) {
        super(context.getProject(), classSymbol);
        this.mySuperClass = superClass;
        this.myVisibility = visibility;
        this.myText = this.getTextImpl(context);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    private String getTextImpl(@NotNull OCCompilationContext context) {
        String superTypeName;
        if (this.mySymbol instanceof OCInterfaceSymbol && !(superTypeName = ((OCInterfaceSymbol)this.mySymbol).getSuperClassName()).isEmpty() && this.mySuperClass != null) {
            return "Change superclass of " + this.mySymbol.getNameWithKindLowercase(context) + " from '" + superTypeName + "' to '" + this.mySuperClass.getPresentableName() + "'";
        }
        assert (this.mySuperClass != null);
        return "Set '" + this.mySuperClass.getPresentableName() + "' as a " + (this.myVisibility != null ? this.myVisibility.toString() + " " : "") + "superclass of " + this.mySymbol.getNameWithKindLowercase(context);
    }

    @NotNull
    public String getFamilyName() {
        return "Change superclass";
    }

    @Override
    public boolean isAvailable() {
        return !(!super.isAvailable() || this.mySymbol.isPredeclaration() || !(this.mySymbol instanceof OCInterfaceSymbol) && !(this.mySymbol instanceof OCStructSymbol) || !(this.mySuperClass instanceof OCInterfaceSymbol) && !(this.mySuperClass instanceof OCStructSymbol));
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCSymbolDeclarator declaration = (OCSymbolDeclarator)this.mySymbol.locateDefinition(project2);
        if (this.mySuperClass instanceof OCInterfaceSymbol) {
            if (declaration != null) {
                new OCElementsMover().setSuperClass((OCClassDeclaration)declaration, this.mySuperClass.getName());
            }
        } else {
            new OCElementsMover().removeBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, false);
            new OCElementsMover().addBaseClass((OCStruct)declaration, (OCStructSymbol)this.mySuperClass, this.myVisibility, false);
        }
    }
}

