/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionUtil {
    private static final NamingConvention EMPTY_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.NONE, "");

    public static boolean shouldIgnoreNamingConventionForSymbol(@Nullable OCSymbol symbol) {
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            return functionSymbol.isUDL() || functionSymbol.isCppOperator() || functionSymbol.isMainFunction();
        }
        return false;
    }

    public static String applyNamingConvention(@NotNull String name2, @Nullable OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.applyNamingConvention(name2, symbolKind, null, null, project2);
    }

    public static String applyNamingConvention(@NotNull String name2, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project2) {
        NamingConvention namingConvention = OCNamingConventionUtil.getNamingConventionForSymbol(symbolKind, symbol, context, project2);
        return namingConvention.apply(name2);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.applyNamingConvention(names, symbolKind, null, null, project2);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project2) {
        NamingConvention namingConvention = OCNamingConventionUtil.getNamingConventionForSymbol(symbolKind, symbol, context, project2);
        return ContainerUtil.map(names, name2 -> namingConvention.apply((String)name2));
    }

    public static boolean matchesToNamingConvention(@NotNull String name2, @NotNull OCSymbolKind symbolKind, @NotNull Project project2) {
        return OCNamingConventionUtil.matchesToNamingConvention(name2, symbolKind, null, null, project2);
    }

    public static boolean matchesToNamingConvention(@NotNull String name2, @NotNull OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project2) {
        NamingConvention namingConvention = OCNamingConventionUtil.getNamingConventionForSymbol(symbolKind, symbol, context, project2);
        return namingConvention.match(name2);
    }

    static NamingConvention getNamingConventionForSymbol(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project2) {
        if (symbolKind != null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
            if (symbolKind == OCSymbolKind.NAMESPACE || symbolKind == OCSymbolKind.NAMESPACE_ALIAS) {
                return settings.NAMESPACES_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.MACRO) {
                return settings.MACROS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.STRUCT) {
                return settings.CLASSES_AND_STRUCTS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.ENUM) {
                return settings.ENUMS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.ENUM_CONST) {
                return settings.ENUMERATORS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.TYPEDEF) {
                return settings.TYPEDEFS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.UNION) {
                return settings.UNIONS_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.STRUCT_FIELD) {
                return settings.FIELDS_NAMING_CONVENTION;
            }
            if (symbolKind.isFunction()) {
                return symbol != null && context != null && (OCNamingConventionUtil.isMemberFunction(symbol, context) || OCNamingConventionUtil.hasStructOwner(symbol, context)) ? settings.METHODS_NAMING_CONVENTION : settings.GLOBAL_FUNCTIONS_NAMING_CONVENTION;
            }
            if (symbolKind.isGlobalVariable()) {
                return settings.GLOBAL_VARIABLES_NAMING_CONVENTION;
            }
            if (symbolKind == OCSymbolKind.PARAMETER) {
                return settings.PARAMETERS_NAMING_CONVENTION;
            }
            if (symbolKind.isLocal()) {
                return settings.LOCAL_VARIABLES_NAMING_CONVENTION;
            }
        }
        return EMPTY_NAMING_CONVENTION;
    }

    private static boolean isMemberFunction(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMember(context, true);
    }

    private static boolean hasStructOwner(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        return symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context) instanceof OCStructSymbol;
    }
}

