/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandler;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSafeDeleteProcessorDelegate
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element) {
        return true;
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> result) {
        ArrayList usages = new ArrayList();
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, usages, (PsiElement[])allElementsToDelete);
        result.addAll(ContainerUtil.map(usages, info -> {
            final PsiElement usageElement = info.getElement();
            if (OCSafeDeleteProcessorDelegate.isSafeToDelete(usageElement, element)) {
                return new SafeDeleteReferenceSimpleDeleteUsageInfo(usageElement, ((SafeDeleteUsageInfo)info).getReferencedElement(), true){

                    public void deleteElement() throws IncorrectOperationException {
                        OCChangeUtil.safeDeleteReference(usageElement);
                    }
                };
            }
            return info;
        }));
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, list);
            for (Pair pair2 : list) {
                result.add((UsageInfo)new SafeDeleteUsageInfo((PsiElement)pair2.getFirst(), element));
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    public static boolean isSafeToDelete(PsiElement usageElement, @Nullable PsiElement element) {
        if (element instanceof OCStructLike || element instanceof OCCppNamespace) {
            List<OCDeclarator> declarators;
            Object structSymbol = ((OCSymbolDeclarator)element).getSymbol();
            OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class, OCDeclarator.class, OCDeclaration.class});
            if (parent instanceof OCDeclaration) {
                declarators = ((OCDeclaration)parent).getDeclarators();
            } else if (parent instanceof OCDeclarator) {
                declarators = Collections.singletonList((OCDeclarator)parent);
            } else {
                return element.equals(parent);
            }
            OCResolveContext context = OCResolveContext.forPsi(element);
            for (OCDeclarator declarator : declarators) {
                OCSymbolWithQualifiedName owner2;
                OCSymbol symbol = declarator.getSymbol();
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = owner2 = symbol instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context) : null;
                while (owner2 != null && !owner2.equals(structSymbol)) {
                    owner2 = owner2.getResolvedOwner(context);
                }
                if (owner2 != null) continue;
                return false;
            }
            return true;
        }
        if (new OCReadWriteAccessDetector().getExpressionAccess(usageElement) == ReadWriteAccessDetector.Access.Write) {
            return !(element instanceof OCMethod);
        }
        return false;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        OCFindUsagesHandler handler = new OCFindUsagesHandler(element, true);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement psiElement : handler.getPrimaryElements()) {
            if (psiElement == null) continue;
            result.add(psiElement);
        }
        for (PsiElement psiElement : handler.getSecondaryElements()) {
            if (psiElement == null) continue;
            result.add(psiElement);
        }
        Collections.sort(result, new Comparator<PsiElement>(){

            private int order(PsiElement element) {
                return element instanceof OCSynthesizeProperty ? 1 : 0;
            }

            @Override
            public int compare(PsiElement el1, PsiElement el2) {
                return this.order(el1) - this.order(el2);
            }
        });
        return result.isEmpty() ? null : result;
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element instanceof OCFile && ((OCFile)element).hasExtraTopLevelDefinitions()) {
            return Collections.singleton("File \"" + ((PsiFile)element).getName() + "\" has several top level declarations.");
        }
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, list);
            if (!list.isEmpty()) {
                return Collections.singletonList(((OCSymbol)((Pair)list.get(0)).getSecond()).getNameWithKindUppercase(OCCompilationContext.create(element)) + " has usage without arguments");
            }
        }
        return Collections.emptyList();
    }

    public UsageInfo[] preprocessUsages(Project project2, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
        Object symbol;
        PsiElement parent;
        if (!element.isValid()) {
            return;
        }
        if (element instanceof OCMethodSelectorPart) {
            OCMethod method = (OCMethod)element.getParent();
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(method, element, true);
            handler.removeParameter(method.getParameters().indexOf(element));
            handler.invokeSynchronously();
        }
        if (element.getParent() instanceof OCParameterDeclaration && (parent = element.getParent().getParent()) instanceof OCParameterList) {
            OCParameterList paramList = (OCParameterList)parent;
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)paramList.getParent().getParent(), element, true);
            handler.removeParameter(paramList.getParameters().indexOf(element));
            handler.invokeSynchronously();
        }
        if ((element instanceof OCStruct || element instanceof OCCppNamespace) && ((OCElement)element).getContainingOCFile().isCpp() && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCNamespaceSymbol) {
            ArrayList elementsToDelete = new ArrayList();
            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol1 -> {
                PsiElement definition;
                Project project2 = element.getProject();
                OCSymbol definitionSymbol = symbol1.getDefinitionSymbol(project2);
                PsiElement psiElement = definition = definitionSymbol != null ? definitionSymbol.locateDefinition(project2) : null;
                if (definition != null && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)definition, (boolean)true)) {
                    elementsToDelete.add(definition);
                }
                return true;
            }));
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
        if (OCSafeDeleteProcessorDelegate.isTemplateParameter(element)) {
            List<PsiElement> elementsToDelete = OCSafeDeleteProcessorDelegate.getElementsToDeleteForTemplateParameter(element, new ArrayList<Pair<PsiElement, OCSymbol>>());
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
    }

    private static List<PsiElement> getElementsToDeleteForTemplateParameter(PsiElement element, List<Pair<PsiElement, OCSymbol>> usagesWithoutArguments) {
        OCSymbol declaratorSymbol = null;
        PsiElement parameter = element instanceof OCTypeParameterDeclaration ? element : element.getParent();
        OCTemplateParameterList typeParamsList = (OCTemplateParameterList)parameter.getParent();
        PsiElement parent = typeParamsList.getParent();
        int paramIndex = typeParamsList.getParameters().indexOf(parameter);
        int paramsCnt = typeParamsList.getParameters().size();
        ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        if (parent instanceof OCFunctionDeclaration) {
            declaratorSymbol = ((OCFunctionDeclaration)parent).getSymbol();
        } else if (parent instanceof OCDeclaration) {
            OCTypeElement typeElement = ((OCDeclaration)parent).getTypeElement();
            OCType type = typeElement != null ? typeElement.getType().resolve(element) : null;
            OCSymbol oCSymbol = declaratorSymbol = type instanceof OCStructType ? ((OCStructType)type).getSymbol() : null;
        }
        if (paramIndex != -1 && declaratorSymbol != null) {
            OCSymbol finalDeclaratorSymbol = declaratorSymbol;
            declaratorSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                PsiElement definition = symbol.locateDefinition(element.getProject());
                if (definition != null) {
                    ReferencesSearch.search((PsiElement)definition).forEach(reference -> {
                        PsiElement usage = reference.getElement();
                        if (!(usage instanceof OCTemplateArgumentsOwner)) {
                            OCLog.LOG.warn("Bad class: " + usage.getClass());
                            return true;
                        }
                        OCTypeArgumentList arguments = ((OCTemplateArgumentsOwner)usage).getTemplateArgumentList();
                        if (arguments == null) {
                            usagesWithoutArguments.add(Pair.create((Object)usage, (Object)finalDeclaratorSymbol));
                        } else {
                            if (paramIndex < arguments.getArguments().size()) {
                                OCElement argument = (OCElement)arguments.getArguments().get(paramIndex);
                                elementsToDelete.add(argument);
                            }
                            if (paramsCnt == 1) {
                                elementsToDelete.add(arguments);
                            }
                        }
                        return true;
                    });
                }
                return true;
            }), element.getProject());
        }
        return elementsToDelete;
    }

    private static boolean isTemplateParameter(PsiElement element) {
        return element instanceof OCTypeParameterDeclaration || element instanceof OCDeclarator && element.getParent().getParent() instanceof OCTemplateParameterList;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

