/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterTableModel;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCChangeSignatureHandlerImpl
implements OCChangeSignatureHandler {
    protected OCParameterTableModel myParametersTableModel;
    protected OCMethodDescriptor myMethod;
    private String myName;
    protected String myReturnTypeText;
    protected OCType myReturnType;
    protected OCCallableKind myCallableKind;
    protected OCChangeInfo myChangeInfo;
    protected boolean myChangeUsages = true;
    protected boolean myChangeAncestors;
    protected OCGeneratedInfo myGeneratedInfo;
    protected String myTitle;
    protected String myHelpId;
    @NotNull
    private PsiElement myContext;

    OCChangeSignatureHandlerImpl(OCParameterTableModel parametersTableModel, OCMethodDescriptor methodDescriptor, @NotNull PsiElement context) {
        this.myParametersTableModel = parametersTableModel;
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myContext = context;
        this.myGeneratedInfo = new OCGeneratedInfo(context.getProject());
    }

    OCChangeSignatureHandlerImpl(OCMethodDescriptor methodDescriptor, @NotNull PsiElement context) {
        String selector;
        OCParameterInfo firstParam;
        OCCallable method = methodDescriptor.getMethod();
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myParametersTableModel = new OCParameterTableModel(context, method instanceof OCMethod);
        this.myParametersTableModel.setParameterInfos(methodDescriptor.getParameters());
        this.myContext = context;
        this.myGeneratedInfo = new OCGeneratedInfo(context.getProject());
        if (ApplicationManager.getApplication().isUnitTestMode() && (firstParam = this.getFirstParameter()) != null && (selector = firstParam.getSelector()) != null && selector.startsWith("_")) {
            this.renameSelector(0, selector.substring(1));
            this.myName = this.myName.substring(1);
        }
    }

    @Override
    public OCParameterInfo addParameter(String name2, OCType type, int oldIndex) {
        return this.addParameter("", name2, type, oldIndex, false);
    }

    @Override
    public OCParameterInfo addParameter(String selector, String name2, OCType type, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name2, type, -1, oldIndex, isReferenceMode);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name2, OCType type, int index, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name2, type, null, index, oldIndex, isReferenceMode);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name2, OCType type, String typeText, int index, int oldIndex, boolean isReferenceMode) {
        OCParameterInfo firstParam;
        if (this.isMethod() && (firstParam = this.getFirstParameter()) != null && firstParam.getName().isEmpty()) {
            selector = firstParam.getSelector();
            this.myParametersTableModel.removeRow(0);
        }
        OCParameterInfo result = typeText == null ? new OCParameterInfo(selector, name2, type, oldIndex, this.myContext) : new OCParameterInfo(selector, name2, type, typeText, oldIndex, this.myContext);
        result.setReferenceMode(isReferenceMode);
        if (index == -1) {
            this.myParametersTableModel.addLastRow(result);
        } else {
            this.myParametersTableModel.addRow(result, index);
        }
        return result;
    }

    @Override
    public OCParameterInfo insertParameter(String name2, OCType type, int index) {
        return this.insertParameter("", name2, type, index, -1, false);
    }

    @Override
    public void removeParameter(int index) {
        this.removeParameter(index, true);
    }

    private void removeParameter(int index, boolean mergeFirstSelector) {
        if (this.isMethod()) {
            OCParameterInfo firstParam = this.getFirstParameter();
            if (this.myParametersTableModel.getRowCount() == 1 && firstParam != null && !firstParam.getSelector().isEmpty()) {
                String selector = firstParam.getSelector();
                this.myParametersTableModel.removeRow(index, mergeFirstSelector);
                this.addParameter(selector, "", null, -1, false);
                return;
            }
        }
        this.myParametersTableModel.removeRow(index, mergeFirstSelector);
    }

    @Override
    public void removeParameter(String name2, boolean mergeFirstSelector) {
        int rowIndex = 0;
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            if (((OCParameterInfo)item.parameter).getName().equals(name2)) {
                this.removeParameter(rowIndex, mergeFirstSelector);
                return;
            }
            ++rowIndex;
        }
        assert (false) : "Could not find parameter: " + name2;
    }

    @Override
    public void exchangeParameters(int i1, int i2) {
        this.myParametersTableModel.exchangeRows(i1, i2);
    }

    @Override
    public void renameSelector(int index, String newName) {
        ((OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getItems().get((int)index)).parameter).setSelector(newName);
        this.myName = this.calculateMethodName();
    }

    @Override
    public void setName(String name2) {
        this.myName = name2;
        OCParameterInfo firstParam = this.getFirstParameter();
        if (this.isMethod()) {
            if (firstParam == null) {
                this.addParameter(name2, "", null, -1, false);
            } else {
                this.renameSelector(0, name2);
            }
        } else if (firstParam != null && !firstParam.getSelector().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
    }

    @Override
    public void setReturnType(OCType returnType) {
        this.myReturnType = returnType;
        this.myReturnTypeText = returnType.getBestNameInContext(this.myContext);
    }

    @Override
    public void setParentClass(OCSymbol parent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
        this.getGeneratedInfo().setMethodParent(parent, allowChangeCategories, auxParents);
    }

    @Override
    public void setChangeParentClassPossible(boolean possible) {
    }

    @Override
    public void setNameVisible(boolean visible) {
    }

    @Override
    public void setChangeUsages(boolean change) {
        this.myChangeUsages = change;
    }

    @Override
    public void setChangeAncestors(boolean change) {
        this.myChangeAncestors = change;
    }

    @Override
    public OCGeneratedInfo getGeneratedInfo() {
        return this.myGeneratedInfo;
    }

    @Override
    public void invoke() {
        this.createRefactoringProcessor().run();
    }

    @Override
    public void invokeSynchronously() {
        this.createRefactoringProcessor().runSynchronously();
    }

    @Override
    public void setTitle(String title) {
        this.myTitle = title;
    }

    @Override
    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Override
    public String getNewSignature(boolean addInitializers) {
        return this.calculateSignature(null, false, addInitializers);
    }

    @Override
    public void setCallableKind(OCCallableKind callableKind) {
        boolean isMethod;
        this.myCallableKind = callableKind;
        OCParameterInfo firstParam = this.getFirstParameter();
        boolean bl = isMethod = callableKind == OCCallableKind.METHOD;
        if (firstParam != null && firstParam.isSelfParameter() && isMethod) {
            this.myParametersTableModel.removeRow(0);
        }
        if (isMethod && this.myMethod.getMethod() instanceof OCFunctionDeclaration) {
            this.setName(this.myMethod.getName());
        } else if (!isMethod && this.myMethod.getMethod() instanceof OCMethod && this.myParametersTableModel.getRowCount() == 1 && firstParam != null && firstParam.getName().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
        if (!(isMethod || this.myMethod.getSelfReferences().isEmpty() || firstParam != null && firstParam.isSelfParameter())) {
            this.addSelfParameter(this.myMethod.getContainerClass().getName());
        }
    }

    @Override
    public void addSelfParameter(String parentClassName) {
        OCType type = OCReferenceType.resolvedFromText(parentClassName, this.myMethod.getMethod());
        type = OCPointerType.to(type);
        OCParameterInfo parameterInfo = new OCParameterInfo("", "_self", type, -1, this.myContext);
        parameterInfo.setSelfParameter(true);
        this.myParametersTableModel.addFirstRow(parameterInfo);
    }

    @Nullable
    private OCParameterInfo getFirstParameter() {
        int rowCount = this.myParametersTableModel.getRowCount();
        return rowCount > 0 ? (OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getRowValue((int)0)).parameter : null;
    }

    @Override
    public List<OCParameterInfo> getParameters() {
        ArrayList<OCParameterInfo> result = new ArrayList<OCParameterInfo>(this.myParametersTableModel.getRowCount());
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            ((OCParameterInfo)item.parameter).setType(OCElementUtil.getType((PsiElement)item.typeCodeFragment));
            ((OCParameterInfo)item.parameter).setTypeText(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
            result.add((OCParameterInfo)item.parameter);
        }
        return result;
    }

    OCType getReturnType() {
        return this.myReturnType;
    }

    String getReturnTypeText() {
        return this.myReturnTypeText;
    }

    String getMethodName() {
        String name2 = this.myName;
        if (this.myMethod.getMethod() instanceof OCBlockExpression) {
            return "block";
        }
        if (this.isFunction()) {
            return name2.indexOf(58) == -1 ? name2 : name2.substring(0, name2.indexOf(58));
        }
        return name2;
    }

    String calculateMethodName() {
        StringBuilder result = new StringBuilder();
        List items = this.myParametersTableModel.getItems();
        for (ParameterTableModelItemBase item : items) {
            result.append(((OCParameterInfo)item.parameter).getSelector());
            if (items.size() == 1 && ((OCParameterInfo)item.parameter).getName().isEmpty()) break;
            result.append(':');
        }
        return result.toString();
    }

    @Nullable
    OCClassDeclaration getContainerClass() {
        return this.myCallableKind == OCCallableKind.METHOD ? this.myMethod.getContainerClass() : null;
    }

    OCChangeSignatureProcessor createRefactoringProcessor() {
        return new OCChangeSignatureProcessor(this.myMethod.getMethod().getProject(), this.getCallableKind(), this.myMethod.getMethod(), this.evaluateChangeInfo(), this.myTitle);
    }

    @Override
    public OCChangeInfo getChangeInfo() {
        if (this.myChangeInfo == null) {
            this.evaluateChangeInfo();
        }
        return this.myChangeInfo;
    }

    private OCChangeInfo evaluateChangeInfo() {
        List<OCParameterInfo> parameters = this.getParameters();
        this.myChangeInfo = new OCChangeInfo(this.myContext, this.myMethod, this.getMethodName(), parameters.toArray(new OCParameterInfo[0]), this.getReturnTypeText(), this.getContainerClass(), this.getCallableKind(), this.calculateSignature(null, false, true), this.calculateSignature(null, false, false), this.myChangeUsages, this.myChangeAncestors, this.myGeneratedInfo){

            @Override
            public String getNewInheritedSignature(OCCallable oldCallable, boolean addInitializers) {
                return OCChangeSignatureHandlerImpl.this.calculateSignature(oldCallable, false, addInitializers);
            }
        };
        return this.myChangeInfo;
    }

    OCCallableKind getCallableKind() {
        return this.myCallableKind;
    }

    @Override
    public List<OCCallable> getNewCallables() {
        return this.myChangeInfo != null ? this.myChangeInfo.getNewMethods() : Collections.emptyList();
    }

    String calculateSignature(@Nullable OCCallable oldCallable, boolean newlines, boolean addInitializers) {
        OCCallable context;
        StringBuilder result = new StringBuilder();
        List params = this.myParametersTableModel.getItems();
        OCCallable method = this.myMethod.getMethod();
        OCCallable oCCallable = context = oldCallable != null ? oldCallable : this.myContext;
        if (this.isMethod()) {
            boolean isInstance = method instanceof OCMethod && ((OCMethod)method).isInstanceMethod();
            result.append(isInstance ? (char)'-' : '+');
            result.append('(');
            result.append(this.getReturnTypeText());
            result.append(')');
            boolean isFirstParam = true;
            for (ParameterTableModelItemBase item : params) {
                result.append(isFirstParam || !newlines ? (char)' ' : '\n');
                isFirstParam = false;
                OCParameterInfo parameter = (OCParameterInfo)item.parameter;
                result.append(parameter.getSelector());
                if (parameter.getName().isEmpty()) break;
                result.append(": (");
                result.append(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
                result.append(") ");
                if (oldCallable != null) {
                    result.append(this.myChangeInfo.getNewParameterName(true, oldCallable, parameter));
                    continue;
                }
                result.append(parameter.getName());
            }
            OCMethod psi = OCElementFactory.methodFromSignature(result.toString(), context, false, false);
            CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)psi);
            String text = psi.getTextWithMacros();
            return text.substring(0, text.length() - 1);
        }
        StringBuilder paramsBuilder = this.buildParams(this.myChangeInfo, params, oldCallable, context, oldCallable != null, newlines, addInitializers);
        if (this.isFunction()) {
            String methodName = this.getMethodName();
            if (methodName.isEmpty()) {
                methodName = "unnamed";
            }
            String methodFullName = methodName;
            List<String> modifiers = Collections.emptyList();
            if (method instanceof OCFunctionDeclaration) {
                OCFunctionType type;
                OCFunctionDeclaration function = (OCFunctionDeclaration)method;
                OCSymbol methodSymbol = this.myMethod.getMethodSymbol();
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                if (function.isStatic() || methodSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)methodSymbol).resolveIsStatic(resolveContext)) {
                    modifiers = Collections.singletonList("static");
                }
                if (function.getNamespaceQualifier() != null) {
                    methodFullName = OCElementUtil.getTextWithMacros(function.getNamespaceQualifier()) + "::" + methodName;
                }
                if ((type = function.getFunctionType()) != null) {
                    result.append(OCCallableUtil.getFunctionTemplateHeader(type, resolveContext));
                }
            }
            if (this.myMethod.isConstructor()) {
                result.append(methodFullName);
            } else {
                result.append(OCElementFactory.declarationText(modifiers, methodFullName, this.getReturnType(), null, context, this.getReturnTypeText(), false));
            }
            result.insert(result.lastIndexOf(methodName) + methodName.length(), paramsBuilder.toString());
            result.append(";");
            OCDeclaration psi = this.myMethod.isConstructor() ? OCElementFactory.constructorFromText(result.toString(), context) : OCElementFactory.topLevelDeclarationFromText(result.toString(), context);
            CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)psi);
            result.setLength(0);
            result.append(OCElementUtil.getTextWithMacros(psi));
            if (result.charAt(result.length() - 1) == ';') {
                result.setLength(result.length() - 1);
            }
        } else if (this.isBlock()) {
            result.append('^');
            if (!"void".equals(this.getReturnTypeText())) {
                result.append(this.getReturnTypeText());
            }
            result.append((CharSequence)paramsBuilder);
            OCExpression psi = OCElementFactory.expressionFromText(result.toString(), context, false);
            CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)psi);
            result.setLength(0);
            result.append(OCElementUtil.getTextWithMacros(psi));
        }
        if (method instanceof OCFunctionDeclaration) {
            ((OCFunctionDeclaration)method).getCVQualifiers().appendCVQualifiers(result);
        }
        if (this.isBlock()) {
            result.append("{...}");
        }
        return result.toString();
    }

    private StringBuilder buildParams(@Nullable OCChangeInfo changeInfo, @NotNull List<ParameterTableModelItemBase<OCParameterInfo>> params, @Nullable OCCallable oldFunction, @NotNull PsiElement context, boolean isInherited, boolean newlines, boolean addInitializers) {
        boolean isFirstParam = true;
        int index = 0;
        StringBuilder paramsBuilder = new StringBuilder();
        if (params.size() > 0 || this.isFunction()) {
            paramsBuilder.append('(');
        }
        for (ParameterTableModelItemBase<OCParameterInfo> param : params) {
            String name2 = changeInfo != null && oldFunction != null ? changeInfo.getNewParameterName(isInherited, oldFunction, (OCParameterInfo)param.parameter) : ((OCParameterInfo)param.parameter).getName();
            PsiCodeFragment type = param.typeCodeFragment;
            String typeText = OCElementUtil.getTextWithMacros((PsiElement)type);
            if (name2.isEmpty() && typeText.isEmpty()) continue;
            if (!isFirstParam) {
                paramsBuilder.append(",").append(newlines ? (char)'\n' : ' ');
            }
            if (typeText.equals("...")) {
                paramsBuilder.append("...");
            } else {
                int oldIndex = ((OCParameterInfo)param.parameter).getOldIndex();
                OCExpression initializer = ((OCParameterInfo)param.parameter).getInitializer();
                if (!addInitializers || oldFunction instanceof OCFunctionDeclaration && oldIndex >= 0 && oldIndex < oldFunction.getParameters().size() && ((OCDeclarator)oldFunction.getParameters().get(oldIndex)).getInitializer() == null) {
                    initializer = null;
                }
                String initializerText = initializer != null ? initializer.getTextWithMacros() : null;
                paramsBuilder.append(OCElementFactory.declarationText(name2, OCElementUtil.getType((PsiElement)type), typeText, initializerText, context));
            }
            isFirstParam = false;
            ++index;
        }
        if (params.size() > 0 || this.isFunction()) {
            paramsBuilder.append(')');
        }
        return paramsBuilder;
    }

    boolean isBlock() {
        return OCCallableKind.BLOCK == this.getCallableKind();
    }

    boolean isFunction() {
        return OCCallableKind.FUNCTION == this.getCallableKind();
    }

    boolean isMethod() {
        return OCCallableKind.METHOD == this.getCallableKind();
    }

    boolean isMethodGenerated() {
        return this.myMethod.getMethod().getContainingFile() instanceof OCCodeFragment;
    }

    OCCallableKind getOriginalCallableKind() {
        return this.myMethod.getCallableKind();
    }

    @Override
    public OCMethodDescriptor getMethodDescriptor() {
        return this.myMethod;
    }

    @Override
    public void setRefactorButtonText(String text) {
    }
}

