/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCTargetSymbolPanel;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageWithContext;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratedMethodUsage
extends OCUsageWithContext {
    public OCGeneratedMethodUsage(@NotNull PsiElement element) {
        super(element);
    }

    @Nullable
    static OCCallable addMethod(PsiElement parent, OCChangeInfo changeInfo, @Nullable PsiElement anchor, boolean needBody, boolean isBefore) {
        if (parent == null || !OCSearchScope.isInProjectSources(parent)) {
            return null;
        }
        OCCallable newMethod = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), needBody, true, false, false);
        if (newMethod != null) {
            OCCallable insertion = isBefore ? OCChangeUtil.addBefore(parent, newMethod, anchor) : OCChangeUtil.addAfter(parent, newMethod, anchor);
            OCChangeUtil.addNewLineAfterIfNeed(insertion);
            return insertion;
        }
        return null;
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project2) {
        OCTargetSymbolPanel.TargetSymbolsMode mode = changeInfo.getGenerated().getTargetSymbolsMode();
        OCSymbol parentClass = changeInfo.getGenerated().getMethodParent();
        OCCallable newMethod = null;
        if (changeInfo.willBeBlock()) {
            newMethod = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false, false);
        } else if (parentClass instanceof OCClassSymbol) {
            PsiElement implementation;
            ArrayList<Object> parents = new ArrayList<Object>();
            OCImplementationSymbol implementationSymbol = ((OCClassSymbol)parentClass).getImplementation(project2);
            PsiElement psiElement = implementation = implementationSymbol != null ? implementationSymbol.locateDefinition(project2) : null;
            if (mode == OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE) {
                OCClassSymbol symbol = ((OCClassSymbol)parentClass).getInterfaceOrProtocol(project2);
                parents.add(symbol != null ? symbol.locateDefinition(project2) : null);
                OCImportSymbolFix oCImportSymbolFix = new OCImportSymbolFix(element, symbol);
                oCImportSymbolFix.fixFirstItem(project2, element.getContainingFile());
            } else if (mode == OCTargetSymbolPanel.TargetSymbolsMode.PRIVATE_CATEGORY && implementation instanceof OCClassDeclarationBase) {
                Object privateCategory = OCCodeInsightUtil.getPrivateCategory((OCClassDeclarationBase)implementation);
                if (privateCategory == null) {
                    privateCategory = OCElementFactory.interfaceByName(parentClass.getName() + "()", implementation);
                    parents.add(OCChangeUtil.addBefore((PsiElement)implementation.getContainingFile(), privateCategory, implementation));
                } else {
                    parents.add(privateCategory);
                }
            }
            parents.add(implementation);
            for (PsiElement psiElement2 : parents) {
                boolean before = !OCCompilerFeatures.supportsLaterMethodDeclaration();
                OCCallable method = OCGeneratedMethodUsage.addMethod(psiElement2, changeInfo, element, psiElement2 instanceof OCImplementation, before);
                newMethod = method != null ? method : newMethod;
            }
        } else {
            PsiElement parent;
            boolean isBefore = true;
            if (!(parentClass instanceof OCStructSymbol)) {
                OCSymbolKind symbolKind = changeInfo.getNewCallableKind().getSymbolKind();
                parent = OCChangeUtil.getAppropriateParent(symbolKind, changeInfo.getContext());
                if (changeInfo.getMethod() instanceof OCFunctionDefinition) {
                    if (((OCFunctionDefinition)changeInfo.getMethod()).getNamespaceQualifier() == null) {
                        if (mode == OCTargetSymbolPanel.TargetSymbolsMode.INTERFACE && parent != null) {
                            isBefore = false;
                            if (!(parent instanceof OCStruct)) {
                                OCGeneratedMethodUsage.addMethod(parent, changeInfo, element, false, true);
                            }
                        }
                    } else {
                        isBefore = false;
                    }
                }
            } else {
                parent = parentClass.locateDefinition(project2);
            }
            newMethod = OCGeneratedMethodUsage.addMethod(parent, changeInfo, element, true, isBefore);
        }
        if (newMethod != null) {
            Editor editor;
            OCBlockStatement body = newMethod.getBody();
            List<PsiElement> statements = changeInfo.getGenerated().getMethodStatements();
            if (body != null && statements != null) {
                if ((statements = OCGeneratedMethodUsage.prepareStatements(changeInfo, statements)).size() == 1 && statements.get(0) instanceof OCBlockStatement) {
                    body = (OCBlockStatement)body.replace(statements.get(0));
                } else {
                    for (PsiElement statement2 : statements) {
                        if (statement2 instanceof OCExpression) {
                            if (changeInfo.getNewReturnType().equals("void")) {
                                OCExpressionStatement oCExpressionStatement = (OCExpressionStatement)OCElementFactory.statementFromText("x();", changeInfo.getContext());
                                OCChangeUtil.replaceHandlingMacros(oCExpressionStatement.getExpression(), statement2);
                                OCChangeUtil.add(body, oCExpressionStatement);
                                continue;
                            }
                            OCReturnStatement oCReturnStatement = (OCReturnStatement)OCElementFactory.statementFromText("return x;", changeInfo.getContext());
                            OCChangeUtil.replaceHandlingMacros(oCReturnStatement.getExpression(), statement2);
                            OCChangeUtil.add(body, oCReturnStatement);
                            continue;
                        }
                        if (!statement2.isValid()) continue;
                        OCChangeUtil.add(body, statement2);
                    }
                }
                if (newMethod instanceof OCFunctionDefinition) {
                    OCResolveContext context;
                    OCSymbol parentSymbol;
                    OCCppNamespaceQualifier oCCppNamespaceQualifier;
                    OCSymbol symbol = newMethod.getSymbol();
                    OCDeclarator declarator = ((OCFunctionDefinition)newMethod).getDeclarator();
                    OCCppNamespaceQualifier oCCppNamespaceQualifier2 = oCCppNamespaceQualifier = declarator != null ? declarator.getNamespaceQualifier() : null;
                    if (symbol instanceof OCSymbolWithQualifiedName && oCCppNamespaceQualifier != null && oCCppNamespaceQualifier.getPredeclarationInParent((OCSymbolWithQualifiedName)symbol, true) == null && (parentSymbol = OCReferenceElementImpl.getAppropriateToAppendSymbol(oCCppNamespaceQualifier, context = OCResolveContext.forPsi(oCCppNamespaceQualifier))) != null) {
                        OCSymbolKind kind = ((OCSymbolWithQualifiedName)symbol).getResolvedKind(context);
                        OCCreateNewDefinitionIntentionAction action = new OCCreateNewDefinitionIntentionAction(kind, declarator, null, parentSymbol, declarator.getName(), symbol.getResolvedType(context), changeInfo.getGenerated().isStatic());
                        action.setSilentMode(true);
                        if (action.isAvailable(project2, null, declarator.getContainingFile())) {
                            action.invoke(project2, null, declarator.getContainingFile());
                        }
                    }
                }
                if (!changeInfo.willBeBlock()) {
                    OCBindUtil.decodeContextInfo(body);
                    OCBindUtil.removeRedundantQualifiers(body);
                }
            }
            OCImportSymbolFix.fixAllSymbolsRecursively(newMethod);
            PsiFile file = newMethod.getContainingFile();
            if (parentClass instanceof OCStructSymbol && newMethod instanceof OCFunctionDeclaration) {
                OCSymbol newMethodSymbol = newMethod.getSymbol();
                if (newMethodSymbol instanceof OCFunctionSymbol) {
                    PsiElement parent;
                    OCType oCType = element instanceof OCQualifiedExpression ? ((OCQualifiedExpression)element).getQualifier().getResolvedType() : null;
                    OCVisibility visibility = OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(newMethodSymbol, element, oCType);
                    OCFunctionSymbol functionSymbol = (OCFunctionSymbol)newMethodSymbol;
                    OCChangeVisibilityIntentionAction changeVisibilityAction = new OCChangeVisibilityIntentionAction(functionSymbol, visibility, OCCompilationContext.create(element));
                    if (!OCVisibility.isVisible(newMethodSymbol, visibility, project2) && changeVisibilityAction.isAvailable(project2, null, file)) {
                        newMethod = (OCCallable)((Object)changeVisibilityAction.invokeAndGetNewDeclaration(project2));
                    }
                    if ((parent = parentClass.locateDefinition(project2)) instanceof OCStructLike && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(functionSymbol, false, project2) != OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.NO) {
                        SmartPsiElementPointer newMethodPtr = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)newMethod);
                        OCGenerateUtil.applyReplacements(project2, OCCppDefinitionsUtil.getGenerateDefinitionReplacements(OCCaretLocation.byFile(file), (OCStructSymbol)parentClass, Collections.singletonList(functionSymbol), Collections.singletonList(newMethod), OCCppDefinitionsUtil.InlinePolicy.PREFERRED, false), true);
                        newMethod = (OCCallable)newMethodPtr.getElement();
                    }
                }
            } else if (changeInfo.getGenerated().isSelectMethod() && !changeInfo.willBeBlock() && (editor = EditorHelper.openInEditor((PsiElement)file)) != null) {
                OCCodeInsightUtil.selectBody(editor, body);
            }
        }
        changeInfo.setNewMethod(newMethod);
        changeInfo.addNewMethod(newMethod);
        return true;
    }

    private static List<PsiElement> prepareStatements(final OCChangeInfo changeInfo, List<PsiElement> statements) {
        statements = ContainerUtil.filter(statements, element -> element.isValid());
        statements = OCBindUtil.insertRedundantQualifiers((Collection<PsiElement>)statements, false);
        List physicalStatements = ContainerUtil.filter(statements, element -> element.isPhysical());
        OCBindUtil.encodeContextInfo(physicalStatements, null, false);
        for (PsiElement statement2 : physicalStatements) {
            statement2.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    OCReferenceElement referenceElement;
                    if (expression.getSelfSuperToken() != null && changeInfo.getSelfParameterName() != null && (referenceElement = expression.getReferenceElement()) != null) {
                        referenceElement.setNameOfIdentifier(changeInfo.getSelfParameterName());
                    }
                }
            });
        }
        return statements;
    }

    @Override
    public int getUsageRank() {
        return -1;
    }
}

