/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCEscalateVisibilityHelper;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInlineActionHandlerBase<T extends PsiNamedElement>
extends InlineActionHandler {
    public static final Key<Boolean> SILENT_MODE = Key.create((String)"SILENT_MODE");
    protected static final String SILENT_EXIT = "SILENT_EXIT";

    public boolean isEnabledForLanguage(Language l) {
        return l instanceof OCLanguage;
    }

    public void inlineElement(Project project2, Editor editor, PsiElement psiElement) {
        PsiElement selectedUsage;
        PsiReference selectedUsageRef = TargetElementUtil.findReference((Editor)editor);
        if (selectedUsageRef != null) {
            selectedUsage = selectedUsageRef.getElement();
            if (selectedUsage instanceof OCDeclarator) {
                selectedUsage = null;
            }
        } else {
            selectedUsage = null;
        }
        this.inline(this.getElementToInline(psiElement), selectedUsage, editor, project2.getUserData(SILENT_MODE) == Boolean.TRUE);
    }

    protected T getElementToInline(PsiElement psiElement) {
        return (T)((PsiNamedElement)psiElement);
    }

    public void invokeSilently(T element, PsiElement selectedUsage) {
        this.inline(element, selectedUsage, null, true);
    }

    private void inline(T element, PsiElement selectedUsage, @Nullable Editor editor, boolean silentMode) {
        Object element1;
        Project project2 = element.getProject();
        String elementNameWithKind = this.getElementKind(element) + " \"" + element.getName() + "\"";
        String refactoringName = "Inline " + StringUtil.capitalize((String)elementNameWithKind);
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(element.getProject());
        Object object = element1 = selectedUsage != null ? selectedUsage : element;
        if (!OCSearchScope.isInProjectSources(element1)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)refactoringName, null);
            return;
        }
        if (selectedUsage != null) {
            PsiFile file = selectedUsage.getContainingFile();
            PsiSearchHelper.SearchCostResult enoughToSearch = PsiSearchHelper.getInstance((Project)element.getProject()).isCheapEnoughToSearch(element.getName(), scope, file, null);
            if (enoughToSearch == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                scope = new LocalSearchScope((PsiElement)file);
            }
        }
        List<PsiElement> usages = this.findUsages(element, (SearchScope)scope);
        ArrayList<PsiElement> usagesInCurrentFile = new ArrayList<PsiElement>();
        boolean previewMode = false;
        boolean deleteElement = true;
        Ref elementData = new Ref();
        ArrayList<String> warnings = new ArrayList<String>();
        String notValidMessage = this.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, (Ref<PsiElement>)elementData, warnings, silentMode);
        if (notValidMessage != null) {
            if (!silentMode && !notValidMessage.equals(SILENT_EXIT)) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)notValidMessage, (String)refactoringName, null);
            }
            return;
        }
        if (!silentMode) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                String[] stringArray;
                PsiFile currentFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                for (PsiElement usage : usages) {
                    if (!usage.getContainingFile().equals(currentFile)) continue;
                    usagesInCurrentFile.add(usage);
                }
                OCInlineActionHandlerBase.highlightUsages(project2, editor, usagesInCurrentFile, EditorColors.SEARCH_RESULT_ATTRIBUTES);
                String message = "Do you want to inline " + usages.size() + " usage" + (usages.size() == 1 ? "" : "s") + " of " + elementNameWithKind + "?";
                if (this.allowInlineSingleUsage() && selectedUsage != null && usages.size() > 1) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = "Inline &current usage";
                    stringArray2[1] = "Inline &all usages" + (scope instanceof LocalSearchScope ? " in file" : "");
                    stringArray2[2] = "&View usages";
                    stringArray = stringArray2;
                    stringArray2[3] = "&Cancel";
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "&Inline";
                    stringArray3[1] = "&View usages";
                    stringArray = stringArray3;
                    stringArray3[2] = "&Cancel";
                }
                String[] options = stringArray;
                int answer = Messages.showDialog((String)message, (String)refactoringName, (String[])options, (int)0, (Icon)Messages.getQuestionIcon(), null);
                if (answer == options.length - 1 || answer == -1) {
                    OCInlineActionHandlerBase.showHighlightRemovalStatus(project2);
                    return;
                }
                if (answer == options.length - 2) {
                    previewMode = true;
                } else if (answer == 0 && options.length == 4) {
                    usages = Collections.singletonList(selectedUsage);
                    deleteElement = false;
                }
                if (selectedUsage != null && this.allowInlineSingleUsage() && scope instanceof LocalSearchScope) {
                    deleteElement = false;
                }
            } else if (this.allowInlineSingleUsage() && selectedUsage != null && usages.size() > 1) {
                usages = Collections.singletonList(selectedUsage);
                deleteElement = false;
            }
        }
        if (usages.size() > 1) {
            this.sortUsages(usages);
        }
        InlineRefactoringProcessor processor2 = new InlineRefactoringProcessor(this, refactoringName, (PsiNamedElement)element, (PsiElement)elementData.get(), usages, deleteElement, warnings, silentMode);
        processor2.setPreviewUsages(previewMode);
        processor2.execute();
        if (!silentMode && processor2.getFailMessage() != null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)processor2.getFailMessage(), (String)refactoringName, null);
        }
    }

    protected List<PsiElement> findUsages(T element, SearchScope scope) {
        ArrayList<PsiElement> usages = new ArrayList<PsiElement>();
        for (PsiReference reference : ReferencesSearch.search(element, (SearchScope)scope, (boolean)false).findAll()) {
            PsiElement usage = reference.getElement();
            if (!OCSearchScope.isInProjectSources(usage)) continue;
            usages.add(usage);
        }
        return usages;
    }

    protected static void showHighlightRemovalStatus(Project project2) {
        WindowManager.getInstance().getStatusBar(project2).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected static void highlightUsages(Project project2, Editor editor, List<PsiElement> usages, TextAttributesKey textAttributes) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributes);
        highlightManager.addOccurrenceHighlights(editor, usages.toArray(PsiElement.EMPTY_ARRAY), attributes, true, null);
    }

    protected boolean allowInlineSingleUsage() {
        return true;
    }

    protected void sortUsages(List<PsiElement> usages) {
        Collections.sort(usages, (element1, element2) -> element2.getTextOffset() - element1.getTextOffset());
    }

    @Nullable
    protected String checkValidness(T element, List<PsiElement> usages, PsiElement selectedUsage, String elementNameWithKind, Editor editor, Ref<PsiElement> elementData, List<String> warnings, boolean silentMode) {
        if (usages.isEmpty() && !silentMode) {
            return StringUtil.capitalize((String)elementNameWithKind) + " is never used";
        }
        return null;
    }

    @Nullable
    protected String checkUsageValid(PsiElement usage, T element) {
        return null;
    }

    protected List<T> getElementsToWrite(T element) {
        return Collections.singletonList(element);
    }

    protected abstract String getElementKind(T var1);

    protected abstract void inlineUsage(PsiElement var1, T var2, PsiElement var3, Project var4, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> var5);

    protected void deleteElement(T element, PsiElement elementData) {
        OCChangeUtil.delete(element);
    }

    @NotNull
    protected abstract String getFeatureID();

    private class InlineRefactoringProcessor
    extends BaseRefactoringProcessor {
        private final String myRefactoringName;
        private final T myElement;
        private final UsageInfo[] myUsageInfos;
        private String myFailMessage;
        private final boolean mySilentMode;
        private final boolean myDeleteElement;
        private boolean myWasConflict;
        private final PsiElement myElementData;
        private final List<String> myWarnings;
        private final Set<PsiFile> myFilesToReparse;
        final /* synthetic */ OCInlineActionHandlerBase this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private InlineRefactoringProcessor(String refactoringName, T element, PsiElement elementData, List<PsiElement> usages, boolean deleteElement, List<String> warnings, boolean silentMode) {
            this.this$0 = (OCInlineActionHandlerBase)n;
            super(element.getProject(), EmptyRunnable.INSTANCE);
            this.myFilesToReparse = new HashSet<PsiFile>();
            this.myRefactoringName = refactoringName;
            this.myElement = element;
            this.myElementData = elementData;
            this.myDeleteElement = deleteElement;
            this.mySilentMode = silentMode;
            this.myUsageInfos = new UsageInfo[usages.size()];
            this.myWarnings = warnings;
            for (int i = 0; i < this.myUsageInfos.length; ++i) {
                this.myUsageInfos[i] = new UsageInfo(usages.get(i));
            }
            this.myWasConflict = false;
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
            return new OCUsageViewDescriptor((PsiElement)this.myElement, "elements to " + this.myRefactoringName);
        }

        @NotNull
        protected UsageInfo[] findUsages() {
            return this.myUsageInfos;
        }

        @NotNull
        protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
            if (this.myDeleteElement && OCSearchScope.isInProjectSources(this.myElement)) {
                return this.this$0.getElementsToWrite(this.myElement);
            }
            return Collections.emptyList();
        }

        protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
            ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
            MultiMap conflicts = new MultiMap();
            for (String warning : this.myWarnings) {
                conflicts.putValue(this.myElement, (Object)warning);
            }
            for (UsageInfo info : (UsageInfo[])refUsages.get()) {
                PsiElement usage = info.getElement();
                String message = this.this$0.checkUsageValid(usage, this.myElement);
                if (message != null) {
                    if (((UsageInfo[])refUsages.get()).length == 1) {
                        this.myFailMessage = message;
                        return false;
                    }
                    conflicts.putValue((Object)usage, (Object)message);
                    this.myWasConflict = true;
                    continue;
                }
                if (usage == null) continue;
                if (PsiTreeUtil.getParentOfType((PsiElement)usage, OCMacroCallArgument.class) != null) {
                    this.myFilesToReparse.add(usage.getContainingFile());
                }
                filteredUsages.add(info);
            }
            refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
            return this.mySilentMode || this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }

        protected void performRefactoring(@NotNull UsageInfo[] usages) {
            String featureID = this.this$0.getFeatureID();
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureID);
            HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility = new HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>>();
            for (UsageInfo usage : usages) {
                this.this$0.inlineUsage(usage.getElement(), this.myElement, this.myElementData, this.myProject, elemsToEscalateVisibility);
            }
            OCEscalateVisibilityHelper.ALL_ELEMENTS_TO_ESCALATE_VISIBILITY.set((UserDataHolder)this.myProject, elemsToEscalateVisibility);
            if (this.myDeleteElement && !this.myWasConflict && OCSearchScope.isInProjectSources(this.myElement)) {
                this.this$0.deleteElement(this.myElement, this.myElementData);
            }
            for (PsiFile file : this.myFilesToReparse) {
                FileSymbolTablesCache.getInstance(this.myProject).scheduleReparseFile((OCFile)file);
            }
        }

        protected void performPsiSpoilingRefactoring() {
            OCBindUtil.escalateVisibilities(this.myProject, new VirtualFile[0]);
        }

        public void execute() {
            if (this.mySilentMode) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    Ref refUsages = Ref.create((Object)this.findUsages());
                    if (this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
                        this.performRefactoring((UsageInfo[])refUsages.get());
                    }
                });
            } else {
                this.run();
            }
        }

        @NotNull
        protected String getCommandName() {
            return this.myRefactoringName;
        }

        public String getFailMessage() {
            return this.myFailMessage;
        }
    }
}

