/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineLocalVarHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInlineMethodHandler
extends OCInlineActionHandlerBase<OCCallable> {
    @Override
    protected String getElementKind(OCCallable element) {
        return element.getKind().toStringLowercase();
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof OCCallable || element instanceof OCDeclarator && element.getParent() instanceof OCFunctionDeclaration;
    }

    @Override
    protected OCCallable getElementToInline(PsiElement psiElement) {
        OCSymbol symbol;
        OCCallable oCCallable = psiElement = psiElement instanceof OCCallable ? (OCCallable)psiElement : (OCCallable)psiElement.getParent();
        if (((OCCallable)psiElement).getBody() == null && (symbol = ((OCCallable)psiElement).getSymbol()) != null && symbol.isPredeclaration()) {
            PsiElement definition;
            Project project2 = psiElement.getProject();
            OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project2);
            PsiElement psiElement2 = definition = definitionSymbol != null ? definitionSymbol.locateDefinition(project2) : null;
            if (definition instanceof OCMethod) {
                return (OCCallable)definition;
            }
            if (definition instanceof OCDeclarator) {
                return (OCCallable)definition.getParent();
            }
        }
        return (OCCallable)psiElement;
    }

    @Override
    protected List<PsiElement> findUsages(OCCallable callable, SearchScope scope) {
        if (callable instanceof OCMethod) {
            ArrayList<PsiElement> usages = new ArrayList<PsiElement>();
            ReferencesSearch.search((PsiElement)callable, (SearchScope)scope, (boolean)false).forEach(reference -> {
                usages.add(reference.getElement());
                return true;
            });
            return usages;
        }
        return super.findUsages(callable, scope);
    }

    @Override
    protected String checkValidness(OCCallable callable, List<PsiElement> usages, PsiElement selectedUsage, String elementNameWithKind, Editor editor, Ref<PsiElement> elementData, List<String> warnings, boolean silentMode) {
        if (callable.getKind() == OCCallableKind.BLOCK) {
            return "Cannot inline blocks";
        }
        if (callable.getBody() == null) {
            if (callable instanceof OCMethod) {
                OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class);
                if (clazz instanceof OCProtocol) {
                    return "Cannot inline a protocol method";
                }
                if (clazz instanceof OCInterface) {
                    return "Interface " + elementNameWithKind + " was not implemented";
                }
            }
            if (callable.getBody() == null) {
                return "Cannot inline a " + callable.getKind().toStringLowercase() + " with an empty body";
            }
        }
        if (usages.isEmpty() && !silentMode) {
            return "There are no calls of " + elementNameWithKind + " in the project";
        }
        OCInlineMethodHandler.checkMethodsHierarchy(callable, elementNameWithKind, warnings);
        return OCInlineMethodHandler.checkBadReturns(callable);
    }

    static void checkMethodsHierarchy(OCCallable callable, String elementNameWithKind, List<String> warnings) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)callable.getSymbol(), finder, false, true, false, callable.getProject());
        if (finder.isFound()) {
            warnings.add(StringUtil.capitalize((String)elementNameWithKind) + " has inheritor " + (callable instanceof OCMethod ? "methods" : "functions"));
        } else {
            OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)callable.getSymbol(), finder, true, false, false, callable.getProject());
            if (finder.isFound()) {
                warnings.add(StringUtil.capitalize((String)elementNameWithKind) + " inherits a method from " + ((OCSymbolWithParent)finder.getFoundValue()).getParent().getNameWithKindLowercase(OCCompilationContext.create(callable)));
            }
        }
    }

    @Nullable
    private static String checkBadReturns(OCCallable callable) {
        String message = "Cannot inline methods with return statements interrupting the execution flow";
        final Ref error = new Ref();
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, null);
        analyzer.buildControlFlowGraph();
        if (analyzer.getUnreachableCodeFinder().isDeadEndReached() && analyzer.getUnreachableCodeFinder().isExitNodeReached()) {
            return "Cannot inline methods with return statements interrupting the execution flow";
        }
        new OCDataFlowAlgorithm(analyzer.getGraph()){

            @Override
            public void process() {
                for (OCNode node : this.myCfg.getExitNodes()) {
                    OCNode nodeAfterReturn = node.getNodeAfterReturn();
                    if (nodeAfterReturn == null) continue;
                    this.traverse(nodeAfterReturn, null, null, true);
                }
            }

            @Override
            protected boolean processNode(@NotNull OCNode node, OCSymbol symbol, boolean isForward, @Nullable OCInstruction startInstruction, OCInstruction endInstruction) {
                OCElementsRange range = node.getRange();
                if (range != null && !range.isEmpty()) {
                    error.set((Object)"Cannot inline methods with return statements interrupting the execution flow");
                    return false;
                }
                return true;
            }
        }.process();
        return (String)error.get();
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCCallable element) {
        if (usage instanceof OCSelectorExpression) {
            return "Cannot inline method reference in '@selector' expression";
        }
        if (usage instanceof XmlElement) {
            return "Cannot inline method reference in XML file";
        }
        if (usage instanceof OCPropertyAttribute) {
            return "Cannot inline method reference in property attribute";
        }
        if (usage instanceof OCReferenceElement && !(usage.getParent().getParent() instanceof OCCallExpression)) {
            return "Cannot inline function reference in non-call expression";
        }
        if ("Swift".equals(usage.getLanguage().getDisplayName())) {
            return "Cannot inline usage in Swift code";
        }
        if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)usage, (boolean)true)) {
            return "Cannot inline recursive " + element.getKind().toStringLowercase() + " call";
        }
        return null;
    }

    @Override
    protected void sortUsages(List<PsiElement> usages) {
        Collections.sort(usages, (element1, element2) -> {
            if (Comparing.equal((Object)element1.getContainingFile(), (Object)element2.getContainingFile())) {
                OCExpression call1 = OCInlineMethodHandler.getCallExpression(element1);
                OCExpression call2 = OCInlineMethodHandler.getCallExpression(element2);
                if (call1 != null && call2 != null) {
                    if (PsiTreeUtil.isAncestor((PsiElement)call1, (PsiElement)call2, (boolean)true)) {
                        return 1;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)call2, (PsiElement)call1, (boolean)true)) {
                        return -1;
                    }
                }
            }
            return element1.getTextOffset() - element2.getTextOffset();
        });
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCCallable callable, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        TextRange callableRange = callable.getTextRange();
        PsiFile fileCopy = (PsiFile)callable.getContainingFile().copy();
        OCCallable callableCopy = (OCCallable)OCCodeInsightUtil.findElementAtRange(fileCopy, callableRange, callable.getClass(), true);
        List<PsiNamedElement> parameters = callableCopy.getParameters();
        Map<PsiNamedElement, List<PsiElement>> declaratorUsages = OCCodeInsightUtil.collectDeclarators(callableCopy).stream().collect(Collectors.toMap(declarator -> declarator, declarator -> OCCodeInsightUtil.getReferences(declarator)));
        boolean isDotCall = callable instanceof OCFunctionDeclaration && usage instanceof OCQualifiedExpression && ((OCQualifiedExpression)usage).getQualifyingTokenKind() == OCTokenTypes.DOT;
        OCBindUtil.insertRedundantQualifiers(callableCopy.getBody(), isDotCall);
        OCBindUtil.encodeContextInfo(callableCopy.getBody(), false);
        OCExpression usageExpr = OCInlineMethodHandler.getCallExpression(usage);
        OCStatement anchor = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)usageExpr, OCStatement.class);
        if (anchor == null || usageExpr == null) {
            return;
        }
        TextRange usageRange = usageExpr.getTextRange().shiftRight(-anchor.getTextOffset());
        anchor = OCChangeUtil.ensureParentIsBlockStatement(anchor);
        usageExpr = (OCExpression)OCCodeInsightUtil.findElementAtRange(anchor.getContainingFile(), usageRange.shiftRight(anchor.getTextOffset()), usageExpr.getClass(), true);
        PsiElement parent = anchor.getParent();
        List<OCExpression> arguments = OCInlineMethodHandler.getArguments(usageExpr);
        OCExpression receiver = OCInlineMethodHandler.getReceiverExpression(usageExpr);
        boolean receiverHasSideEffects = receiver != null && OCCodeInsightUtil.hasSideEffects(receiver);
        ArrayList<OCDeclarator> newParamDeclarators = new ArrayList<OCDeclarator>();
        OCBlockStatement body = callableCopy.getBody();
        assert (body != null);
        assert (parameters != null);
        assert (parameters.size() >= arguments.size());
        if (callable instanceof OCMethod && !((OCMethod)callable).isInstanceMethod() && receiver != null) {
            OCSendMessageExpression classExpr = OCElementFactory.sendMessageExpression(Collections.singletonList("class"), usage);
            OCChangeUtil.replaceHandlingMacros(classExpr.getReceiverExpression(), receiver);
            receiver = classExpr;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            OCExpression argument;
            PsiNamedElement parameter = parameters.get(i);
            if (i < arguments.size()) {
                argument = arguments.get(i);
            } else {
                if (!(parameter instanceof OCDeclarator) || ((OCDeclarator)parameter).getInitializer() == null) break;
                argument = ((OCDeclarator)parameter).getInitializer();
            }
            OCType paramType = parameter instanceof OCDeclarator ? ((OCDeclarator)parameter).getType() : ((OCMethodSelectorPart)parameter).getType();
            OCDeclarator declarator2 = OCInlineMethodHandler.addVariable(parameter.getName(), paramType, argument, parent, anchor);
            if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                newParamDeclarators.add(declarator2);
            }
            OCCodeInsightUtil.renameDeclaratorAndUsages(parameter, declarator2.getName(), declaratorUsages.get(parameter));
        }
        OCInlineMethodHandler.assignTemplateParameters(callableCopy, usageExpr, anchor, parent, declaratorUsages, newParamDeclarators);
        OCDeclarator receiverDeclarator = receiver != null ? OCInlineMethodHandler.addVariable("receiver", receiver.getResolvedType().getGuessedType(), receiver, parent, anchor) : null;
        OCDeclarator resultDeclarator = !callable.getReturnType().resolve(parent).isVoid() ? OCInlineMethodHandler.addVariable("result", callable.getReturnType(), null, parent, anchor) : null;
        String resultName = resultDeclarator != null ? resultDeclarator.getName() : "nullResult";
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        HashSet<PsiElement> elementsInBlocks = new HashSet<PsiElement>();
        OCInlineMethodHandler.collectElements(body, elements, elementsInBlocks);
        for (PsiElement psiElement : elements) {
            OCSymbol symbol;
            if (psiElement instanceof OCReturnStatement && !elementsInBlocks.contains(psiElement)) {
                OCExpression returnExpr = ((OCReturnStatement)psiElement).getExpression();
                if (returnExpr != null) {
                    OCStatement assignStmt = OCElementFactory.statementFromText(resultName + "=b;", psiElement);
                    OCAssignmentExpression expression = (OCAssignmentExpression)((OCExpressionStatement)assignStmt).getExpression();
                    OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), returnExpr);
                    OCChangeUtil.replaceHandlingMacros(psiElement, assignStmt);
                    continue;
                }
                OCChangeUtil.replaceHandlingMacros(psiElement, OCElementFactory.statementFromText(";", psiElement));
                continue;
            }
            if (psiElement instanceof OCReferenceExpression) {
                OCReferenceExpression refExpr = (OCReferenceExpression)psiElement;
                if (!refExpr.isSelfSuperOrThis() || receiverDeclarator == null) continue;
                refExpr.getReferenceElement().setNameOfIdentifier(receiverDeclarator.getName());
                continue;
            }
            if (!(psiElement instanceof OCDeclarator) || !((symbol = ((OCDeclarator)psiElement).getSymbol()) instanceof OCDeclaratorSymbol)) continue;
            OCCodeInsightUtil.renameDeclaratorAndUsages((OCDeclarator)psiElement, OCNameSuggester.suggestUniqueName(symbol, parent, project2), declaratorUsages.get((OCDeclarator)psiElement));
        }
        PsiElement[] elementsToCopy = OCCodeInsightUtil.findStatementsAtRange(fileCopy, body.getTextRange().getStartOffset() + 1, body.getTextRange().getEndOffset() - 1, true);
        assert (elementsToCopy != null);
        for (PsiElement statement2 : elementsToCopy) {
            OCChangeUtil.addBefore(parent, statement2, anchor);
        }
        OCInlineLocalVarHandler oCInlineLocalVarHandler = new OCInlineLocalVarHandler();
        PsiElement usageParent = OCParenthesesUtils.topmostParenthesized(usageExpr).getParent();
        if (usageExpr instanceof OCQualifiedExpression && usageParent instanceof OCAssignmentExpression && resultDeclarator == null || callable instanceof OCFunctionDeclaration && usageExpr.getParent() instanceof OCCallExpression) {
            usageParent = OCParenthesesUtils.topmostParenthesized((OCExpression)usageParent).getParent();
        }
        if (usageParent instanceof OCExpressionStatement) {
            OCChangeUtil.delete(usageParent);
        } else {
            OCReferenceExpression resultExpr = (OCReferenceExpression)OCElementFactory.expressionFromText(resultName, parent);
            OCExpression usageToReplace = OCInlineMethodHandler.getUsageToReplace(usageExpr);
            resultExpr = (OCReferenceExpression)OCChangeUtil.replaceHandlingMacros(usageToReplace, resultExpr);
            if (resultDeclarator != null) {
                oCInlineLocalVarHandler.invokeSilently(resultDeclarator, resultExpr.getReferenceElement());
            }
        }
        if (receiverDeclarator != null && !receiverHasSideEffects) {
            oCInlineLocalVarHandler.invokeSilently(receiverDeclarator, receiverDeclarator);
        }
        for (OCDeclarator declarator3 : newParamDeclarators) {
            oCInlineLocalVarHandler.invokeSilently(declarator3, declarator3);
        }
        OCImportSymbolFix.fixAllSymbolsRecursively(parent);
        OCBindUtil.decodeContextInfo(parent, null, elemsToEscalateVisibility);
        OCBindUtil.removeRedundantQualifiers(parent);
    }

    private static void collectElements(OCBlockStatement body, final List<PsiElement> elements, final Set<PsiElement> elementsInBlocks) {
        final Stack blocksStack = new Stack();
        body.accept(new OCVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
                elements.add(element);
                if (!blocksStack.isEmpty()) {
                    elementsInBlocks.add(element);
                }
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                blocksStack.push((Object)blockExpression);
                blockExpression.acceptChildren(this);
                blocksStack.pop();
            }
        });
    }

    @Nullable
    private static OCExpression getCallExpression(PsiElement usage) {
        OCExpression usageExpr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCExpression.class, (boolean)false);
        if (usageExpr instanceof OCReferenceExpression) {
            usageExpr = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)usageExpr, OCCallExpression.class);
        }
        return usageExpr;
    }

    private static OCDeclarator addVariable(String baseName, OCType type, @Nullable OCExpression initializer, PsiElement parent, PsiElement anchor) {
        String name2 = OCNameSuggester.suggestUniqueName(OCSymbolKind.LOCAL_VARIABLE, baseName, parent, parent.getProject());
        OCDeclarationStatement declStatement = OCElementFactory.declarationStatement(name2, type, initializer, parent);
        declStatement = OCChangeUtil.addBefore(parent, declStatement, anchor);
        return declStatement.getDeclaration().getDeclarators().get(0);
    }

    @Nullable
    private static OCExpression getReceiverExpression(OCExpression usage) {
        if (usage instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)usage).getReceiverExpression();
        }
        if (usage instanceof OCQualifiedExpression) {
            return ((OCQualifiedExpression)usage).getQualifier();
        }
        return null;
    }

    private static OCExpression getUsageToReplace(OCExpression usage) {
        if (usage instanceof OCQualifiedExpression && usage.getParent() instanceof OCCallExpression) {
            return (OCCallExpression)usage.getParent();
        }
        return usage;
    }

    private static List<OCExpression> getArguments(OCExpression usage) {
        if (usage instanceof OCCallExpression) {
            return ((OCCallExpression)usage).getArguments();
        }
        if (usage instanceof OCSendMessageExpression) {
            return ((OCSendMessageExpression)usage).getArgumentExpressions();
        }
        if (usage instanceof OCQualifiedExpression) {
            OCExpression receiver = OCParenthesesUtils.topmostParenthesized(usage);
            PsiElement parent = receiver.getParent();
            if (parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == receiver) {
                return Collections.singletonList(((OCAssignmentExpression)parent).getSourceExpression());
            }
            if (parent instanceof OCCallExpression) {
                return ((OCCallExpression)parent).getArguments();
            }
            return Collections.emptyList();
        }
        assert (false) : usage.getClass();
        return null;
    }

    private static List<OCElement> getTemplateParameters(OCCallable callable) {
        OCTemplateParameterList parametersList;
        if (callable instanceof OCDeclaration && (parametersList = ((OCDeclaration)((Object)callable)).getTemplateParameterList()) != null) {
            return parametersList.getParameters();
        }
        return Collections.emptyList();
    }

    private static List<? extends OCElement> getTemplateArguments(OCExpression usageExpr) {
        OCTypeArgumentList argumentList;
        if (usageExpr instanceof OCCallExpression) {
            OCTypeArgumentList argumentList2;
            OCReferenceElement referenceElement;
            OCExpression call = ((OCCallExpression)usageExpr).getFunctionReferenceExpression();
            if (call instanceof OCReferenceExpression && (referenceElement = ((OCReferenceExpression)call).getReferenceElement()) != null && (argumentList2 = referenceElement.getTemplateArgumentList()) != null) {
                return argumentList2.getArguments();
            }
        } else if (usageExpr instanceof OCQualifiedExpression && (argumentList = ((OCQualifiedExpression)usageExpr).getTemplateArgumentList()) != null) {
            return argumentList.getArguments();
        }
        return Collections.emptyList();
    }

    private static void assignTemplateParameters(OCCallable callableCopy, OCExpression usageExpr, OCStatement anchor, PsiElement parent, Map<PsiNamedElement, List<PsiElement>> declaratorUsages, List<OCDeclarator> newParamDeclarators) {
        List<OCElement> parameters = OCInlineMethodHandler.getTemplateParameters(callableCopy);
        List<? extends OCElement> arguments = OCInlineMethodHandler.getTemplateArguments(usageExpr);
        for (int i = 0; i < parameters.size(); ++i) {
            OCType paramType;
            OCDeclarator paramDeclarator;
            OCElement parameter = parameters.get(i);
            if (!(parameter instanceof OCParameterDeclaration) || (paramDeclarator = ((OCParameterDeclaration)parameter).getDeclarator()) == null || (paramType = paramDeclarator.getType()).isVariadic()) continue;
            OCExpression argument = null;
            if (i < arguments.size()) {
                OCElement argElement = arguments.get(i);
                if (argElement instanceof OCExpression) {
                    argument = (OCExpression)argElement;
                }
            } else {
                argument = paramDeclarator.getInitializer();
            }
            if (argument == null) continue;
            OCDeclarator declarator = OCInlineMethodHandler.addVariable(paramDeclarator.getName(), paramType, argument, parent, anchor);
            if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                newParamDeclarators.add(declarator);
            }
            OCCodeInsightUtil.renameDeclaratorAndUsages(paramDeclarator, declarator.getName(), declaratorUsages.get(paramDeclarator));
        }
    }

    @Override
    protected void deleteElement(OCCallable element, PsiElement elementData) {
        List<OCCallable> callables = OCInlineMethodHandler.collectSameDefinitions(element);
        for (OCCallable callable : callables) {
            OCChangeUtil.delete(callable);
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineMethod";
    }

    @Override
    protected List<OCCallable> getElementsToWrite(OCCallable element) {
        return OCInlineMethodHandler.collectSameDefinitions(element);
    }

    private static List<OCCallable> collectSameDefinitions(OCCallable callable) {
        ArrayList<OCCallable> callables = new ArrayList<OCCallable>();
        OCSymbol symbol = callable.getSymbol();
        if (symbol != null) {
            Project project2 = callable.getProject();
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                PsiElement element;
                PsiElement psiElement = element = symbol1 != null ? symbol1.locateDefinition(project2) : null;
                if (element instanceof OCCallable) {
                    callables.add((OCCallable)element);
                } else if (element != null && element.getParent() instanceof OCCallable) {
                    callables.add((OCCallable)element.getParent());
                }
                return true;
            }), project2);
        } else {
            callables.add(callable);
        }
        return callables;
    }
}

