/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCInlineTypedefHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "typedef";
    }

    public boolean canInlineElement(PsiElement element) {
        PsiElement parent;
        if (element instanceof OCDeclarator && (parent = element.getParent()) instanceof OCDeclaration) {
            return ((OCDeclaration)parent).isTypedef();
        }
        return false;
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCDeclarator typedefDeclarator) {
        OCStructLike structDefinition;
        OCType typedefType = typedefDeclarator.getType();
        OCTypeElement usageTypeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        if (typedefType.getTerminalType() instanceof OCFunctionType) {
            return "Can't inline function type";
        }
        OCCallExpression callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCCallExpression.class);
        if (callExpression != null && (typedefType.getCVQualifiers() != CVQualifiers.EMPTY || !(typedefType instanceof OCReferenceType) && !(typedefType instanceof OCNumericType))) {
            return "Can't inline constructor expression";
        }
        OCDeclaration typedefDeclaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)typedefDeclarator, OCDeclaration.class);
        if (typedefDeclaration != null && (structDefinition = (OCStructLike)ContainerUtil.getFirstItem((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)typedefDeclaration.getTypeElement(), OCStructLike.class))) != null && structDefinition.isDeclaration()) {
            return "Can't inline " + StringUtil.wrapWithDoubleQuote((String)StringUtil.toLowerCase((String)structDefinition.getKind().getName())) + " definition";
        }
        return null;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (usage instanceof OCCppNamespaceQualifier) {
            OCResolveContext context = OCResolveContext.forPsi(usage);
            OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + element.getType().getCanonicalName(context) + "::x;", usage).getDeclarators().get(0).getNamespaceQualifier();
            OCChangeUtil.replaceHandlingMacros(usage, qualifier);
            return;
        }
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCTypeElement usageTypeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        OCSymbol typedefSymbol = element.getSymbol();
        OCType typedefType = element.getType();
        PsiFile containingFile = element.getContainingFile();
        if (usageTypeElement == null || typedefSymbol == null) {
            OCCallExpression callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCCallExpression.class);
            if (callExpression == null) {
                return;
            }
            OCExpression newExpression = OCElementFactory.expressionFromText(typedefType.getBestNameInContext(usage), usage, false);
            if (newExpression != null) {
                OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), newExpression);
            }
            return;
        }
        if (usageTypeElement.getParent() instanceof OCParameterDeclaration) {
            OCParameterDeclaration paramDeclaration = (OCParameterDeclaration)usageTypeElement.getParent();
            OCDeclarator paramDeclarator = paramDeclaration.getDeclarators().get(0);
            OCType newParamType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, paramDeclarator.getType(), containingFile, project2);
            OCParameterDeclaration newParamDeclaration = OCElementFactory.paramDeclarationByNameAndType(paramDeclarator.getName(), newParamType, paramDeclarator.getInitializer(), paramDeclarator);
            OCInlineTypedefHandler.replaceDeclaration(paramDeclaration, newParamDeclaration);
        } else if (usageTypeElement.getParent() instanceof OCFunctionDeclaration) {
            OCFunctionDeclaration functionDeclaration = (OCFunctionDeclaration)usageTypeElement.getParent();
            OCType newType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, functionDeclaration.getReturnType(), containingFile, project2);
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newType.getBestNameInContext(usage), usage);
            OCInlineTypedefHandler.replaceReturnType(functionDeclaration, newTypeElement);
        } else if (usageTypeElement.getParent() instanceof OCDeclaration) {
            for (OCDeclaration declaration : OCNormalizeUtil.normalizeDeclaration((OCDeclaration)usageTypeElement.getParent())) {
                OCDeclarator declarator = declaration.getDeclarators().get(0);
                OCType newDeclType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, declarator.getType(), containingFile, project2);
                OCDeclaration newDeclaration = OCElementFactory.declarationStatement(null, declarator.getName(), newDeclType, declarator.getInitializer(), declarator.getInitializerList(), declarator.getArgumentList(), declarator).getDeclaration();
                OCInlineTypedefHandler.replaceDeclaration(declaration, newDeclaration);
            }
        } else {
            OCType newType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, usageTypeElement.getType(), usageTypeElement.getContainingFile(), project2);
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newType.getBestNameInContext(usage), usage);
            OCChangeUtil.replaceHandlingMacros(usageTypeElement, newTypeElement);
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineTypedef";
    }

    private static void replaceReturnType(@NotNull OCFunctionDeclaration functionDeclaration, @NotNull OCTypeElement newReturnTypeElement) {
        ASTNode node;
        IElementType elementType;
        OCDeclarator functionDeclarator = functionDeclaration.getDeclarator();
        if (functionDeclarator == null) {
            return;
        }
        ASTNode[] aSTNodeArray = functionDeclarator.getNode().getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n && (elementType = (node = aSTNodeArray[i]).getElementType()) != OCTokenTypes.IDENTIFIER; ++i) {
            if (!OCTokenTypes.DECLARATOR_MODIFIERS.contains(elementType)) continue;
            functionDeclarator.getNode().removeChild(node);
        }
        OCChangeUtil.replaceHandlingMacros(functionDeclaration.getReturnTypeElement(), newReturnTypeElement);
    }

    private static void replaceDeclaration(@NotNull OCDeclaration oldDeclaration, @NotNull OCDeclaration newDeclaration) {
        OCElementUtil.replaceDeclarationQualifiers(newDeclaration, oldDeclaration);
        OCElementUtil.replaceDeclarationQualifiers(newDeclaration.getTypeElement(), oldDeclaration.getTypeElement());
        OCChangeUtil.replaceHandlingMacros(oldDeclaration, newDeclaration);
    }

    private static OCType transformType(final OCSymbol symbol, final OCType elementType, OCType usageType, final PsiFile containingFile, final @NotNull Project project2) {
        return usageType.transformType(new OCTypeCloneVisitor(false){

            @Override
            public OCType visitReferenceType(OCReferenceType type) {
                List<OCSymbol> symbols = type.getReference(containingFile).resolveToSymbols(OCResolveContext.forPsi((PsiElement)containingFile));
                if (symbols.contains(symbol)) {
                    return type.isConst() ? elementType.cloneWithConstModifier(project2) : elementType;
                }
                return super.visitReferenceType(type);
            }
        });
    }
}

