/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConstantInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myStaticCB;

    public OCConstantInplaceIntroducer(Project project2, Editor editor, OCExpression expression, List<OCExpression> occurrences, String refactoringName) {
        super(project2, editor, expression, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        this.myStaticCB = this.createCheckBox("Declare &static", settings.INTRODUCE_STATIC_CONSTS, () -> {
            settings.INTRODUCE_STATIC_CONSTS = this.myStaticCB.isSelected();
            this.rebuildDeclaration();
        });
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            OCDeclaration newDeclaration = this.createDeclaration(declarator.getName(), declarator.getInitializer());
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), newDeclaration);
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.GLOBAL_VARIABLE;
    }

    @Override
    @Nullable
    protected String checkExpression(OCExpression expression) {
        String message = this.checkType();
        if (message != null) {
            return message;
        }
        if (!new OCConstantExpressionVisitor(){

            @Override
            protected boolean isConstDeclarator(OCReferenceExpression expression, OCSymbol symbol) {
                return super.isConstDeclarator(expression, symbol) && symbol.isGlobal();
            }
        }.isConstant(expression)) {
            return "Selected expression cannot be a constant initializer";
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private OCDeclaration createDeclaration(String name2, OCExpression initializer) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.myStaticCB.isSelected()) {
            modifiers.add("static");
        }
        String declarationText = OCElementFactory.declarationText(modifiers, name2, this.myExprType.cloneWithConstModifier(this.myProject), "0", initializer, null, false);
        if ((declarationText = OCElementFactory.declarationFromText(declarationText, initializer, true).getTextWithMacros()).endsWith("0;")) {
            declarationText = declarationText.substring(0, declarationText.length() - 2) + initializer.getTextWithMacros() + ";";
        } else {
            LOG.error(declarationText);
        }
        return OCElementFactory.declarationFromText(declarationText, initializer);
    }

    private OCDeclaration doIntroduce(String name2, boolean isPreview) {
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCDeclaration declarationInFragment = this.createDeclaration(name2, mainExpression);
        OCDeclaration declarationInFile = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declarationInFragment, anchor);
        OCChangeUtil.addNewLineAfterIfNeed(declarationInFile);
        if (isPreview) {
            this.setVariable((PsiNameIdentifierOwner)declarationInFile.getDeclarators().get(0));
        }
        return declarationInFile;
    }

    @Override
    protected void introduceForPreview(String name2) {
        this.doIntroduce(name2, true);
    }

    @Override
    protected void introduceForReal(String name2) {
        OCDeclaration declaration = this.doIntroduce(name2, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declaration);
        for (OCExpression expression : (OCExpression[])this.myOccurrences) {
            OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.expressionFromText(name2, expression));
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceConstant";
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

