/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefineInplaceIntroducer
extends OCBaseInplaceIntroducer<OCDefineDirective, OCElement> {
    public OCDefineInplaceIntroducer(Project project2, Editor editor, OCElement expression, List<OCElement> occurrences, String refactoringName) {
        super(project2, editor, expression, occurrences, OCDefineDirective.class, OCElement.class, refactoringName);
    }

    @NotNull
    protected String[] suggestNames(boolean replaceAll, @Nullable OCDefineDirective variable) {
        String nameToSuggest = OCNamingConventionUtil.applyNamingConvention(this.myUsageName != null ? this.myUsageName : "DEF", OCSymbolKind.MACRO, this.myProject);
        return new String[]{nameToSuggest};
    }

    @Override
    protected String checkExpression(OCElement expression) {
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        OCElement parent = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)this.getCommonContext(), (boolean)false, (Class[])new Class[]{OCFile.class});
        return parent != null ? this.findAnchor(parent) : null;
    }

    private void doIntroduce(String name2, boolean isPreview) {
        PsiElement anchor = this.getAnchor();
        OCDefineDirective declaration = (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText(this.getDefineText(name2), anchor);
        OCDefineDirective newDirective = OCChangeUtil.addBefore(this.getAnchorParent(anchor, isPreview), declaration, anchor);
        OCChangeUtil.addNewLineAfterIfNeed(newDirective);
        if (isPreview) {
            this.setVariable(newDirective);
        }
    }

    @Override
    protected OCDefineDirective getVariable() {
        OCDefineDirective variable = (OCDefineDirective)super.getVariable();
        if (variable != null && variable.getNameIdentifier() == null) {
            return null;
        }
        return variable;
    }

    @Override
    protected void introduceForPreview(String name2) {
        this.doIntroduce(name2, true);
    }

    @Override
    protected void introduceForReal(String name2) {
        this.doIntroduce(name2, false);
        OCElement mainExpression = (OCElement)this.getMainExpression();
        Document document2 = this.myEditor.getDocument();
        this.initOccurrencesMarkers();
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document2);
        for (RangeMarker marker : this.myOccurrenceMarkers) {
            String macroCallText = name2 + (mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration ? ";" : "");
            document2.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)macroCallText);
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document2);
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.introduceDefine";
    }

    @NotNull
    private static String getTextWithLineCommentsReplacedWithBlockComments(@NotNull OCElement expression) {
        String text = expression.getTextWithMacros().trim();
        int correction = 0;
        for (PsiComment comment : PsiTreeUtil.findChildrenOfType((PsiElement)expression, PsiComment.class)) {
            int offset = comment.getStartOffsetInParent();
            int len = comment.getTextLength();
            if (!comment.getText().startsWith("//") || offset + len >= text.length()) continue;
            text = text.substring(0, offset + correction) + "/*" + comment.getText().substring(2) + "*/" + text.substring(offset + len + correction);
            correction += 2;
        }
        return text;
    }

    private String getDefineText(String name2) {
        OCElement mainExpression = (OCElement)this.getMainExpression();
        String mainText = OCDefineInplaceIntroducer.getTextWithLineCommentsReplacedWithBlockComments((OCElement)this.getMainExpression());
        String[] lines = mainText.split("\n");
        for (int i = 0; i < lines.length - 1; ++i) {
            if (lines[i].trim().endsWith("\\")) continue;
            int n = i;
            lines[n] = lines[n] + "\\";
        }
        String declarationText = "#define " + name2 + " " + String.join((CharSequence)"\n", Arrays.asList(lines));
        if ((mainExpression instanceof OCStatement || mainExpression instanceof OCDeclaration) && declarationText.endsWith(";")) {
            declarationText = declarationText.substring(0, declarationText.length() - 1);
        }
        declarationText = declarationText + "\n\n";
        return declarationText;
    }
}

