/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCMemberInfoStorage
extends AbstractMemberInfoStorage<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
    private MostlySingularMultiMap<OCSymbolDeclarator, Pair<OCSymbol, OCVisibility>> mySuperClassesMap;
    private LinkedHashSet<OCSymbolDeclarator> mySuperClasses;

    public OCMemberInfoStorage(@Nullable PsiElement parent) {
        super(parent, (MemberInfoBase.Filter)new MemberInfoBase.EmptyFilter());
    }

    protected boolean isInheritor(PsiElement baseClass, PsiElement aClass) {
        return this.getSubclasses(baseClass).contains(aClass);
    }

    protected void buildSubClassesMap(PsiElement aClass) {
        if (aClass instanceof OCSymbolDeclarator) {
            this.buildSubClassesMapImpl((OCSymbolDeclarator)aClass, new HashSet<OCSymbolDeclarator>());
        }
    }

    private void buildSubClassesMapImpl(OCSymbolDeclarator aClass, HashSet<OCSymbolDeclarator> visited) {
        if (visited.contains(aClass)) {
            return;
        }
        visited.add(aClass);
        Object symbol = aClass.getSymbol();
        if (symbol == null) {
            return;
        }
        if (symbol instanceof OCClassSymbol) {
            OCType superType = ((OCClassSymbol)symbol).getSuperType().resolve(aClass, true);
            if (superType instanceof OCObjectType) {
                this.processSuperClass(aClass, visited, ((OCObjectType)superType).getClassSymbol(), OCVisibility.PUBLIC);
            }
            for (String protocolName : ((OCClassSymbol)symbol).getProtocolNames()) {
                CommonProcessors.FindFirstProcessor resolver = new CommonProcessors.FindFirstProcessor();
                OCResolveUtil.processGlobalSymbols(protocolName, aClass, new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)resolver, OCProtocolSymbol.class));
                this.processSuperClass(aClass, visited, (OCSymbol)resolver.getFoundValue(), OCVisibility.PUBLIC);
            }
        } else if (symbol instanceof OCStructSymbol) {
            ((OCStructSymbol)symbol).processBaseClasses(OCResolveContext.forPsi(aClass), (symbol1, visibility) -> {
                this.processSuperClass(aClass, visited, symbol1, visibility);
                return true;
            });
        }
    }

    private void processSuperClass(OCSymbolDeclarator aClass, HashSet<OCSymbolDeclarator> visited, OCSymbol superClass, OCVisibility visibility) {
        OCSymbolDeclarator declaration;
        if (this.mySuperClassesMap == null) {
            this.mySuperClassesMap = new MostlySingularMultiMap();
            this.mySuperClasses = new LinkedHashSet();
        }
        Project project2 = aClass.getProject();
        OCSymbolDeclarator oCSymbolDeclarator = declaration = superClass != null ? (OCSymbolDeclarator)superClass.locateDefinition(project2) : null;
        if (declaration != null) {
            if (OCSearchScope.isInProjectSources(superClass, project2)) {
                this.buildSubClassesMapImpl(declaration, visited);
                this.getSubclasses(declaration).add(aClass);
                this.mySuperClasses.add(declaration);
            }
            this.mySuperClassesMap.add((Object)aClass, (Object)Pair.create((Object)superClass, (Object)((Object)visibility)));
        }
    }

    protected void extractClassMembers(PsiElement parent, ArrayList<OCMemberInfo> list) {
        OCMembersContainer<OCSymbol> parentSymbol;
        OCMembersContainer<OCSymbol> oCMembersContainer = parentSymbol = parent instanceof OCFile ? ((OCFile)parent).getMembersContainer(false) : (OCMembersContainer)((OCSymbolDeclarator)parent).getSymbol();
        if (parentSymbol == null) {
            return;
        }
        VirtualFile topLevelFile = parent instanceof OCFile ? ((OCFile)parent).getVirtualFile() : null;
        Project project2 = parent.getProject();
        Processor processor2 = symbol -> {
            OCSymbol definitionSymbol;
            if (topLevelFile != null && !topLevelFile.equals(symbol.getContainingFile())) {
                return true;
            }
            if (symbol instanceof OCSynthesizeSymbol) {
                return true;
            }
            if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null) {
                return true;
            }
            if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() != null) {
                return true;
            }
            if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getParent() instanceof OCInterfaceSymbol) {
                return true;
            }
            if (symbol instanceof OCClassSymbol && symbol.isPredeclaration()) {
                return true;
            }
            if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.ENUM_CONST) {
                return true;
            }
            if ((parent instanceof OCFile || parent instanceof OCCppNamespace) && (definitionSymbol = symbol instanceof OCInterfaceSymbol ? ((OCInterfaceSymbol)symbol).getImplementation(((OCInterfaceSymbol)symbol).getCategoryName(), project2) : (symbol instanceof OCClassSymbol ? symbol : symbol.getDefinitionSymbol(project2))) != null && definitionSymbol != symbol && topLevelFile != null && topLevelFile.equals(definitionSymbol.getContainingFile())) {
                return true;
            }
            if (symbol instanceof OCSymbolWithParent) {
                definitionSymbol = symbol instanceof OCFunctionSymbol ? symbol.getDefinitionSymbol(project2) : symbol;
                list.add(new OCMemberInfo((OCSymbol)symbol, definitionSymbol != null ? definitionSymbol : symbol, false, parentSymbol, project2));
            } else {
                list.add(new OCMemberInfo((OCSymbol)symbol, parentSymbol, project2));
            }
            return true;
        };
        if (parentSymbol instanceof OCClassSymbol) {
            ((OCClassSymbol)parentSymbol).processCategories((Processor<? super OCClassSymbol>)((Processor)category -> {
                if (category.isSameCategory((OCSymbol)((Object)parentSymbol))) {
                    category.processMembers(OCMemberSymbol.class, processor2);
                }
                return true;
            }), false, null, project2);
        } else if (parentSymbol instanceof OCStructSymbol) {
            parentSymbol.processMembers(null, processor2);
        } else if (parent instanceof OCCppNamespace) {
            parentSymbol.processMembers(null, (Processor<OCSymbol>)processor2);
        } else if (parent instanceof OCFile) {
            parentSymbol.processMembers(null, (Processor<OCSymbol>)processor2);
        }
        ArrayList<OCMemberInfo> superInfos = new ArrayList<OCMemberInfo>();
        if (this.mySuperClassesMap != null && parent instanceof OCSymbolDeclarator) {
            for (Pair pair2 : this.mySuperClassesMap.get((Object)((OCSymbolDeclarator)parent))) {
                OCSymbol superSymbol = (OCSymbol)pair2.getFirst();
                if (superSymbol instanceof OCProtocolSymbol) {
                    superInfos.add(new OCMemberInfo(superSymbol, parentSymbol, project2));
                    continue;
                }
                if (!(superSymbol instanceof OCStructSymbol)) continue;
                superInfos.add(new OCMemberInfo((OCStructSymbol)superSymbol, (OCVisibility)((Object)pair2.getSecond()), parentSymbol, project2));
            }
        }
        list.sort(Comparator.comparingLong(i -> i.getSymbol().getComplexOffset()));
        list.addAll(0, superInfos);
    }

    public boolean memberConflict(OCSymbolHolderVirtualPsiElement member1, OCSymbolHolderVirtualPsiElement member2) {
        Object symbol1 = member1.getSymbol();
        Object symbol2 = member2.getSymbol();
        Project project2 = member1.getProject();
        if (symbol1 instanceof OCFunctionSymbol && symbol2 instanceof OCFunctionSymbol) {
            return OCMemberInfoStorage.getFunctionSignature((OCFunctionSymbol)symbol1).equals(OCMemberInfoStorage.getFunctionSignature((OCFunctionSymbol)symbol2));
        }
        if (symbol1 instanceof OCMethodSymbol && symbol2 instanceof OCMethodSymbol) {
            return symbol1.getSignature(project2).equals(symbol2.getSignature(project2));
        }
        if (symbol1 instanceof OCSymbolWithParent && !(symbol1 instanceof OCStructSymbol) && symbol2 instanceof OCSymbolWithParent && !(symbol2 instanceof OCStructSymbol)) {
            return symbol1.getName().equals(symbol2.getName());
        }
        return symbol1.equals(symbol2);
    }

    private static String getFunctionSignature(OCFunctionSymbol function) {
        if (function.isCppConstructor()) {
            return function.getParamsSignatureWithoutNames();
        }
        if (function.isCppDestructor()) {
            return "~";
        }
        return function.getName() + function.getParamsSignatureWithoutNames();
    }

    public List<OCSymbolDeclarator> getSuperClasses() {
        return this.mySuperClasses != null ? new ArrayList<OCSymbolDeclarator>(this.mySuperClasses) : Collections.emptyList();
    }
}

