/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.refactoring.move.OCCopyMoveProcessor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveFilesHandlerDelegate<M, R, G extends R, P, RTP, RPP>
extends MoveFilesOrDirectoriesHandler {
    private static Function<MultiMap<PsiElement, String>, Boolean> ourShowConflictsFunction;

    public static void setShowConflictsFunctionInTests(Function<MultiMap<PsiElement, String>, Boolean> conflictsFunction, @NotNull Disposable disposable) {
        ourShowConflictsFunction = conflictsFunction;
        Disposer.register((Disposable)disposable, () -> {
            ourShowConflictsFunction = null;
        });
    }

    public void doMove(final Project project2, final PsiElement[] elements, PsiElement targetContainer, final MoveCallback callback) {
        if (targetContainer == null) {
            for (PsiElement element : elements) {
                if (!this.skipElement(element)) continue;
                return;
            }
            PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(null, (PsiElement[])elements);
            new MoveFilesOrDirectoriesDialog(project2, elements, initialTargetDirectory){

                protected void performMove(@NotNull PsiDirectory targetDirectory) {
                    OCMoveFilesHandlerDelegate.this.doMove(project2, elements, (PsiElement)targetDirectory, callback);
                    this.close(1);
                }
            }.show();
            return;
        }
        new OCCopyMoveProcessor<M, R, G, P>(elements){

            @Override
            protected void doActionForExternalFiles(Project project22, @NotNull P projectFile, @NotNull List<VirtualFile> notInProjectFiles, @Nullable G targetGroup, @NotNull PsiDirectory targetDirectory) {
                WriteCommandAction.writeCommandAction((Project)project22).run(() -> {
                    THashSet paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                    for (VirtualFile file : notInProjectFiles) {
                        VfsUtilCore.processFilesRecursively((VirtualFile)file, file1 -> paths.add((Object)file1.getPath()));
                    }
                    OCMoveFilesHandlerDelegate.this.removePaths((THashSet<String>)paths, projectFile);
                });
                ProjectUtil.focusProjectWindow((Project)project22, (boolean)true);
                OCMoveFilesHandlerDelegate.this.addFiles(project22, projectFile, notInProjectFiles, targetGroup, targetDirectory);
            }

            @Override
            protected void doAction(@NotNull OCCopyMoveProcessor.Helper<M, R, G, P> helper, @NotNull P projectFile, final @NotNull PsiDirectory targetDir, final @NotNull G targetGroup, @NotNull List<R> sourceRefs) {
                boolean canRefactor;
                final Object targetProvider = OCMoveFilesHandlerDelegate.this.getTargetProvider(sourceRefs, targetGroup);
                if (targetProvider == null) {
                    return;
                }
                MultiMap conflicts = new MultiMap();
                final Object manipulator = helper.getManipulator(projectFile);
                final Completer completer = new Completer(helper, manipulator);
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)targetDir.getProject());
                for (final Object sourceRef : sourceRefs) {
                    PsiFileSystemItem sourceElement = OCMoveFilesHandlerDelegate.this.findPsiFileItemToMove(sourceRef);
                    if (OCMoveFilesHandlerDelegate.this.isValid(sourceRef) && OCMoveFilesHandlerDelegate.this.isValid(targetGroup)) {
                        final String srcPath = OCMoveFilesHandlerDelegate.this.getPath(sourceRef);
                        if (sourceElement == null || srcPath == null) continue;
                        String errorMessage = 2.checkOperationIsValid(sourceElement, targetDir, sourceElement.getName(), false, true);
                        if (errorMessage == null) {
                            SmartPsiElementPointer pointer = pointerManager.createSmartPsiElementPointer((PsiElement)sourceElement);
                            completer.addTask(() -> {
                                final PsiFileSystemItem validSourceElement = (PsiFileSystemItem)pointer.getElement();
                                if (validSourceElement == null) {
                                    return;
                                }
                                new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{validSourceElement}, targetDir, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, new MoveCallback(){

                                    public void refactoringCompleted() {
                                        VirtualFile dstVFile;
                                        DocumentReference ref = DocumentReferenceManager.getInstance().create(targetDir.getVirtualFile());
                                        UndoManager.getInstance((Project)project2).nonundoableActionPerformed(ref, true);
                                        PsiDirectory newFile = validSourceElement.isDirectory() ? targetDir.findSubdirectory(validSourceElement.getName()) : targetDir.findFile(validSourceElement.getName());
                                        VirtualFile virtualFile = dstVFile = newFile == null ? null : newFile.getVirtualFile();
                                        if (dstVFile != null) {
                                            String dstPath = dstVFile.getPath();
                                            Object pathProvider = OCMoveFilesHandlerDelegate.this.getReferencePathProviderForCopying(dstPath, srcPath);
                                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, pathProvider, targetGroup, targetProvider);
                                        }
                                        WriteAction.run(() -> {
                                            completer.oneTaskExecuted();
                                            if (callback != null) {
                                                callback.refactoringCompleted();
                                            }
                                        });
                                    }
                                }, null).run();
                            });
                            continue;
                        }
                        if (OCMoveFilesHandlerDelegate.this.isFilesView(project2)) {
                            conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved."));
                            continue;
                        }
                        conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved, only reference will be changed."));
                        completer.addTask(() -> WriteAction.run(() -> {
                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                            completer.oneTaskExecuted();
                        }));
                        continue;
                    }
                    completer.addTask(() -> WriteAction.run(() -> {
                        OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                        completer.oneTaskExecuted();
                    }));
                }
                boolean bl = canRefactor = !completer.isEmpty();
                if (!conflicts.isEmpty()) {
                    canRefactor = ourShowConflictsFunction != null ? (canRefactor &= ((Boolean)ourShowConflictsFunction.apply(conflicts)).booleanValue()) : (canRefactor &= new ConflictsDialog(project2, conflicts, null, canRefactor, false).showAndGet());
                }
                if (canRefactor) {
                    completer.executeTasks();
                }
            }

            @Override
            protected OCCopyMoveProcessor.Helper<M, R, G, P> getHelper() {
                return OCMoveFilesHandlerDelegate.this.getHelper();
            }
        }.process(project2, targetContainer);
    }

    protected abstract boolean isFilesView(Project var1);

    protected abstract boolean skipElement(PsiElement var1);

    protected abstract RPP getReferencePathProviderForCopying(String var1, String var2);

    protected abstract RPP getIdPathProvider();

    protected abstract boolean isValid(R var1);

    protected abstract String getPath(R var1);

    protected abstract PsiFileSystemItem findPsiFileItemToMove(R var1);

    protected abstract void addFiles(Project var1, P var2, List<VirtualFile> var3, G var4, PsiDirectory var5);

    protected abstract void removePaths(THashSet<String> var1, P var2);

    protected abstract OCCopyMoveProcessor.Helper<M, R, G, P> getHelper();

    @NotNull
    protected abstract List<?> moveReference(@NotNull M var1, @NotNull R var2, @NotNull RPP var3, @NotNull G var4, @NotNull RTP var5);

    @Nullable
    protected abstract RTP getTargetProvider(@NotNull List<R> var1, @NotNull G var2);

    private class Completer {
        private final ArrayList<Runnable> myRefactorings = new ArrayList();
        private volatile int myCounter = 0;
        private final OCCopyMoveProcessor.Helper<M, R, G, P> myHelper;
        private final M myManipulator;

        Completer(OCCopyMoveProcessor.Helper<M, R, G, P> helper, M manipulator) {
            this.myHelper = helper;
            this.myManipulator = manipulator;
        }

        void addTask(Runnable refactoring) {
            this.myRefactorings.add(refactoring);
            ++this.myCounter;
        }

        boolean isEmpty() {
            return this.myCounter == 0;
        }

        void executeTasks() {
            for (Runnable refactoring : this.myRefactorings) {
                refactoring.run();
            }
        }

        void oneTaskExecuted() {
            --this.myCounter;
            if (this.myCounter == 0) {
                this.myHelper.completeManipulation(this.myManipulator);
            }
        }
    }
}

