/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveTopLevelRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        HashSet<PsiElement> set = new HashSet<PsiElement>(Arrays.asList(elements));
        this.showDialog(elements[0], (Condition<PsiElement>)((Condition)element -> set.contains(element)), editor);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.moveTopLevel");
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        if (element == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element)) {
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            this.showDialog(element, (Condition<PsiElement>)((Condition)element12 -> element12 != null && file.equals(element12.getContainingFile()) && selectionRange.contains(element12.getTextRange())), editor);
        } else {
            this.showDialog(element, (Condition<PsiElement>)((Condition)element1 -> element1 != null && file.equals(element1.getContainingFile()) && element1.getTextRange().containsOffset(offset)), editor);
        }
    }

    protected void showDialog(PsiElement element, Condition<PsiElement> selectedCond, Editor editor) {
        OCAbstractMoveDialog dialog;
        Project project2 = element.getProject();
        if (!OCSearchScope.isInProjectSources(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)this.getTitle(), null);
            return;
        }
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCCppNamespace.class, OCFile.class});
        OCAbstractMoveDialog oCAbstractMoveDialog = dialog = parent instanceof OCCppNamespace ? this.createDialog((OCCppNamespace)parent, selectedCond) : this.createDialog((OCFile)parent, selectedCond);
        if (dialog == null) {
            return;
        }
        if (!dialog.allowsEmptySelection() && dialog.getMemberInfos().isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)((parent instanceof OCCppNamespace ? "Namespace \"" : "File \"") + parent.getName() + "\" has no members to move"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Pair<OCFile[], String> pair2 = dialog.invokeRefactoring();
            this.passToTest((String)pair2.getSecond(), (OCFile[])pair2.getFirst());
            return;
        }
        dialog.show();
    }

    protected void passToTest(String conflicts, OCFile[] newFiles) {
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return true;
    }

    protected abstract String getTitle();

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCFile var1, Condition<PsiElement> var2);

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCCppNamespace var1, Condition<PsiElement> var2);
}

