/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class OCEscalateVisibilityDialog
extends DialogWrapper {
    private static final int CHECKED_COLUMN = 0;
    private static final int MEMBER_COLUMN = 1;
    private static final int FORMER_VISIBILITY_COLUMN = 2;
    private static final int REQUIRED_VISIBILITY_COLUMN = 3;
    private JBTable myTable;
    private List<OCMemberInfo> myMembers = new ArrayList<OCMemberInfo>();
    private Map<OCSymbol, OCVisibility> myRequiredVisibilities = new HashMap();
    private Map<OCSymbol, SmartPsiElementPointer> mySymbolToElementMap = new HashMap();

    public OCEscalateVisibilityDialog(@Nullable Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        super(project2);
        for (SmartPsiElementPointer elementPtr : elemsToEscalateVisibility.keySet()) {
            Pair<OCSymbol, OCVisibility> pair2 = elemsToEscalateVisibility.get(elementPtr);
            OCSymbol symbol = (OCSymbol)pair2.getFirst();
            this.myMembers.add(new OCMemberInfo(symbol, symbol, true, null, project2));
            this.myRequiredVisibilities.put(symbol, (OCVisibility)((Object)pair2.getSecond()));
            this.mySymbolToElementMap.put(symbol, elementPtr);
        }
        Collections.sort(this.myMembers, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        for (OCMemberInfo member : this.myMembers) {
            member.setChecked(true);
        }
        this.setTitle("Escalate Visibility");
        this.getOKAction().putValue("Name", "Yes");
        this.getCancelAction().putValue("Name", "No");
        this.init();
    }

    public List<Pair<SmartPsiElementPointer, OCVisibility>> getCheckedMembers() {
        ArrayList<Pair<SmartPsiElementPointer, OCVisibility>> result = new ArrayList<Pair<SmartPsiElementPointer, OCVisibility>>();
        for (OCMemberInfo member : this.myMembers) {
            if (!member.isChecked()) continue;
            OCSymbol symbol = member.getSymbol();
            result.add((Pair<SmartPsiElementPointer, OCVisibility>)Pair.create((Object)this.mySymbolToElementMap.get(symbol), (Object)((Object)this.myRequiredVisibilities.get(symbol))));
        }
        return result;
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JLabel label = new JLabel();
        label.setText("Do you want to escalate the visibility for the following members?");
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)label, "North");
        box.add(_panel);
        box.add(Box.createVerticalStrut(7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myTable = new JBTable();
        this.myTable.setModel((TableModel)new MyModel());
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new MyTableRenderer()));
        columnModel.getColumn(1).setPreferredWidth(300);
        columnModel.getColumn(3).setCellRenderer((TableCellRenderer)((Object)new MyTableRenderer()));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(630, this.myTable.getRowHeight() * 12));
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new TableSpeedSearch((JTable)this.myTable);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private class MyTableRenderer
    extends ColoredTableCellRenderer {
        private MyTableRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int modelColumn = OCEscalateVisibilityDialog.this.myTable.convertColumnIndexToModel(column);
            OCMemberInfo member = (OCMemberInfo)((Object)OCEscalateVisibilityDialog.this.myMembers.get(row));
            String text = value.toString();
            if (modelColumn == 3 && OCVisibility.shouldBeDeclaredInInterface(member.getSymbol(), (OCVisibility)((Object)value))) {
                text = "declare in interface";
            }
            if (modelColumn == 1) {
                this.setIcon(((OCSymbolHolderVirtualPsiElement)member.getMember()).getIcon(0));
            } else {
                this.setIcon(null);
            }
            this.setIconOpaque(false);
            this.setOpaque(false);
            this.append(text);
        }
    }

    private class MyModel
    extends AbstractTableModel {
        private MyModel() {
        }

        @Override
        public int getRowCount() {
            return OCEscalateVisibilityDialog.this.myMembers.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 1) {
                return OCSymbol.class;
            }
            return OCVisibility.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OCMemberInfo member = (OCMemberInfo)((Object)OCEscalateVisibilityDialog.this.myMembers.get(rowIndex));
            switch (columnIndex) {
                case 0: {
                    return member.isChecked();
                }
                case 1: {
                    return member.getDisplayName();
                }
                case 2: {
                    return member.getVisibility();
                }
                case 3: {
                    return OCEscalateVisibilityDialog.this.myRequiredVisibilities.get(member.getSymbol());
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((OCMemberInfo)((Object)OCEscalateVisibilityDialog.this.myMembers.get(rowIndex))).setChecked((Boolean)aValue);
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Member";
                }
                case 2: {
                    return "Current visibility";
                }
                case 3: {
                    return "Required visibility";
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }
}

