/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveCppProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.ui.OCTypeReferenceEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveMembersDialog
extends OCAbstractMoveDialog {
    private OCTypeReferenceEditor myTargetClassField;
    private DependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> mySameClassModel;
    private DependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myInheritorModel;
    private DependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myAncestorModel;
    private DependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myUnrelatedModel;

    public OCMoveMembersDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, String targetClassName) {
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle(RefactoringBundle.message((String)"move.members.title"));
        this.initModels();
        this.init();
        if (targetClassName != null) {
            this.myTargetClassField.setText(targetClassName);
        }
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveMembers";
    }

    private void initModels() {
        this.mySameClassModel = new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
                return 0;
            }

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCMoveMembersDialog.this.isMemberEnabled(member);
            }
        };
        this.myInheritorModel = new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
                int problem = super.checkForProblems((MemberInfoBase)memberInfo);
                if (problem == 2) {
                    if (memberInfo.isStatic()) {
                        return 1;
                    }
                    for (OCMemberInfo info : OCMoveMembersDialog.this.getSelectedMemberInfos()) {
                        if (info.isStatic()) continue;
                        return problem;
                    }
                    return 1;
                }
                return problem;
            }

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCMoveMembersDialog.this.isMemberEnabled(member);
            }
        };
        this.myAncestorModel = new AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass, null, false){

            protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
                if (problem == 2 && memberInfo.isStatic()) {
                    return 1;
                }
                return problem;
            }

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCMoveMembersDialog.this.isMemberEnabled(member);
            }
        };
        this.myUnrelatedModel = new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
                return Math.max(OCMoveMembersDialog.this.myInheritorModel.checkForProblems((MemberInfoBase)memberInfo), OCMoveMembersDialog.this.myAncestorModel.checkForProblems((MemberInfoBase)memberInfo));
            }

            public void memberInfoChanged(@NotNull MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
                super.memberInfoChanged(event);
                OCMoveMembersDialog.this.myInheritorModel.memberInfoChanged(event);
                OCMoveMembersDialog.this.myAncestorModel.memberInfoChanged(event);
            }

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCMoveMembersDialog.this.isMemberEnabled(member);
            }
        };
        this.myUnrelatedModel.setTooltipProvider((MemberInfoTooltipManager.TooltipProvider)new MemberInfoTooltipManager.TooltipProvider<OCSymbolHolderVirtualPsiElement, OCMemberInfo>(){

            public String getTooltip(OCMemberInfo memberInfo) {
                String text = OCMoveMembersDialog.this.myInheritorModel.getTooltipText((MemberInfoBase)memberInfo);
                return text != null ? text : OCMoveMembersDialog.this.myAncestorModel.getTooltipText((MemberInfoBase)memberInfo);
            }
        });
    }

    @Override
    protected List<? extends MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo>> getAllModels() {
        return Arrays.asList(this.mySameClassModel, this.myInheritorModel, this.myAncestorModel, this.myUnrelatedModel);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel("Move members to class (existing or new):"), "North");
        this.myTargetClassField = OCTypeReferenceEditor.create(null, (Condition<OCSymbol>)((Condition)symbol -> {
            if (this.myClassSymbol instanceof OCClassSymbol) {
                return symbol instanceof OCInterfaceSymbol && !"".equals(((OCInterfaceSymbol)symbol).getCategoryName()) || symbol instanceof OCProtocolSymbol;
            }
            return symbol instanceof OCStructSymbol && symbol.getKind() == OCSymbolKind.STRUCT;
        }), this.mySourceClass, true, this.myProject);
        _panel.add((Component)((Object)this.myTargetClassField), "Center");
        this.myTargetClassField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                OCMoveMembersDialog.this.myMemberInfoModel = OCMoveMembersDialog.this.createModel();
                OCMoveMembersDialog.this.myMemberSelectionPanel.getTable().setMemberInfoModel(OCMoveMembersDialog.this.myMemberInfoModel);
                OCMoveMembersDialog.this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)OCMoveMembersDialog.this.myMemberInfos));
                OCMoveMembersDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                OCMoveMembersDialog.this.validateButtons();
            }
        });
        this.myMemberInfoModel = this.createModel();
        Box box = Box.createVerticalBox();
        box.add(_panel);
        box.add(Box.createVerticalStrut(7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetClassField;
    }

    @Override
    public boolean allowsEmptySelection() {
        return false;
    }

    @Override
    protected void checkCanRun() throws ConfigurationException {
        super.checkCanRun();
        String targetName = this.getTargetName();
        OCSymbol symbol = this.getTargetSymbol();
        if (targetName.isEmpty()) {
            throw new ConfigurationException("No target class is selected");
        }
        if (symbol == null && !StringUtil.isJavaIdentifier((String)targetName)) {
            throw new ConfigurationException("Name of the class is invalid");
        }
        if (symbol != null && !OCSearchScope.isInProjectSources(symbol, this.myProject)) {
            throw new ConfigurationException(symbol.getNameWithKindUppercase(OCCompilationContext.create(symbol, this.myProject)) + " is not located inside the project");
        }
        if (symbol != null && symbol.equals(this.myClassSymbol)) {
            throw new ConfigurationException("Source and target classes should be different");
        }
    }

    @Override
    public boolean checkConflicts() {
        String message = "Target class \"" + this.getTargetName() + "\" doesn't yet exist.";
        return this.getTargetSymbol() != null || OCNewFileActionBase.isNewFileActionSupported() && Messages.showYesNoDialog((Project)this.getProject(), (String)message, (String)this.getTitle(), (String)"Create New Class", (String)"Cancel", (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public String getTargetName() {
        return this.myTargetClassField.getText().trim();
    }

    @Nullable
    private OCSymbol getTargetSymbol() {
        return this.myTargetClassField != null ? this.myTargetClassField.getClassDeclaration(this.myProject) : null;
    }

    @Override
    protected String getOKButtonText() {
        return "&Move";
    }

    @Nullable
    private TargetRelation getTargetRelation() {
        OCSymbol targetSymbol = this.getTargetSymbol();
        if (targetSymbol == null) {
            return TargetRelation.UNRELATED;
        }
        if (targetSymbol == this.myClassSymbol) {
            return TargetRelation.SAME_CLASS;
        }
        if (targetSymbol instanceof OCClassSymbol) {
            OCClassSymbol targetClass = (OCClassSymbol)targetSymbol;
            OCClassSymbol sourceClass = (OCClassSymbol)this.myClassSymbol;
            if (targetClass.isSameCategory(sourceClass)) {
                return TargetRelation.SAME_CLASS;
            }
            if (targetSymbol.isSameSymbol(sourceClass, this.myProject)) {
                String sourceCategory = sourceClass.getCategoryName();
                String targetCategory = targetClass.getCategoryName();
                if (sourceCategory == null || sourceCategory.isEmpty()) {
                    return TargetRelation.INHERITOR;
                }
                if (targetCategory == null || targetCategory.isEmpty()) {
                    return TargetRelation.ANCESTOR;
                }
                return TargetRelation.UNRELATED;
            }
            if (targetClass.isSubclass(sourceClass, this.myProject)) {
                return TargetRelation.INHERITOR;
            }
            if (sourceClass.isSubclass(targetClass, this.myProject)) {
                return TargetRelation.ANCESTOR;
            }
            return TargetRelation.UNRELATED;
        }
        OCStructSymbol targetClass = (OCStructSymbol)targetSymbol;
        OCStructSymbol sourceClass = (OCStructSymbol)this.myClassSymbol;
        if (targetClass.resolvedNamesEqual(this.myProject, sourceClass)) {
            return TargetRelation.SAME_CLASS;
        }
        if (targetClass.isAncestor(sourceClass, OCResolveContext.forSymbol(targetClass, this.myProject))) {
            return TargetRelation.ANCESTOR;
        }
        if (sourceClass.isAncestor(targetClass, OCResolveContext.forSymbol(sourceClass, this.myProject))) {
            return TargetRelation.INHERITOR;
        }
        return TargetRelation.UNRELATED;
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        if (this.myTargetClassField == null) {
            return null;
        }
        OCSymbol target = this.myTargetClassField.getClassDeclaration(this.myProject);
        TargetRelation relation = this.getTargetRelation();
        if (relation == null) {
            return this.myUnrelatedModel;
        }
        switch (relation) {
            case SAME_CLASS: {
                return this.mySameClassModel;
            }
            case INHERITOR: {
                return this.myInheritorModel;
            }
            case ANCESTOR: {
                ((AbstractUsesDependencyMemberInfoModel)this.myAncestorModel).setSuperClass(target.locateDefinition(this.myProject));
                return this.myAncestorModel;
            }
            case UNRELATED: {
                return this.myUnrelatedModel;
            }
        }
        return this.myUnrelatedModel;
    }

    @Override
    protected boolean isMemberEnabled(OCMemberInfo member) {
        boolean targetIsCategory;
        OCSymbol target = this.getTargetSymbol();
        if (target == null) {
            return true;
        }
        boolean bl = targetIsCategory = target instanceof OCClassSymbol && ((OCClassSymbol)target).getCategoryName() != null;
        if ((target instanceof OCProtocolSymbol || targetIsCategory) && member.getSymbol() instanceof OCInstanceVariableSymbol) {
            return false;
        }
        if (targetIsCategory && member.getSymbol() instanceof OCPropertySymbol && !((OCPropertySymbol)member.getSymbol()).processSynthesizes((Processor<? super OCSynthesizeSymbol>)new CommonProcessors.FindFirstProcessor(), this.myProject)) {
            return false;
        }
        return this.myMemberInfoModel != this.myAncestorModel || !this.myStorage.getExtending(target.locateDefinition(this.myProject)).contains(member.getSymbol().locateDefinition(this.myProject));
    }

    @Override
    @Nullable
    protected OCMoveProcessor createProcessor() {
        List<Object> targetSymbols;
        OCSymbol targetSymbol = this.getTargetSymbol();
        List<Object> list = targetSymbols = targetSymbol != null ? Collections.singletonList(targetSymbol) : Collections.emptyList();
        if (this.mySourceClass instanceof OCClassDeclaration) {
            return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), this.getTargetName(), targetSymbols){

                @NotNull
                protected String getCommandName() {
                    return OCMoveMembersDialog.this.getTitle();
                }

                @Override
                @Nullable
                protected OCNewFileActionBase getNewClassAction() {
                    return new OCNewClassAction();
                }
            };
        }
        if (this.mySourceClass instanceof OCStruct) {
            return new OCMoveCppProcessor((OCStruct)this.mySourceClass, this.getSelectedMemberInfos(), this.getTargetName(), targetSymbols){

                @NotNull
                protected String getCommandName() {
                    return OCMoveMembersDialog.this.getTitle();
                }

                @Override
                @Nullable
                protected OCNewFileActionBase getNewClassAction() {
                    return new OCNewCppClassAction();
                }
            };
        }
        assert (false) : this.mySourceClass;
        return null;
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        if (this.myMemberInfoModel == this.myAncestorModel) {
            return symbol.getNameWithKindUppercase(OCCompilationContext.create(symbol, this.myProject)) + " will be inaccessible in the moved code";
        }
        if (this.myMemberInfoModel == this.myInheritorModel) {
            return "Moved code will be inaccessible from the " + symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, this.myProject));
        }
        if (this.myAncestorModel.checkForProblems((MemberInfoBase)info) == 2) {
            return symbol.getNameWithKindUppercase(OCCompilationContext.create(symbol, this.myProject)) + " will be inaccessible in the moved code";
        }
        if (this.myInheritorModel.checkForProblems((MemberInfoBase)info) == 2) {
            return "Moved code will be inaccessible from the " + symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, this.myProject));
        }
        assert (false);
        return null;
    }

    private static enum TargetRelation {
        SAME_CLASS,
        INHERITOR,
        ANCESTOR,
        UNRELATED;

    }
}

