/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardUtil;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardElementManipulator
extends AbstractElementManipulator<OCReferenceElementImpl> {
    @Nullable
    public OCReferenceElementImpl handleContentChange(@NotNull OCReferenceElementImpl element, @NotNull TextRange range, String newName) throws IncorrectOperationException {
        OCHeaderGuardInfo headerGuard;
        OCDirective parentDirective = (OCDirective)PsiTreeUtil.getParentOfType((PsiElement)element, OCDirective.class);
        if (parentDirective == null) {
            return element;
        }
        IElementType elementType = OCElementUtil.getElementType(parentDirective.getHeaderToken());
        if ((elementType == OCTokenTypes.IFNDEF_DIRECTIVE || elementType == OCTokenTypes.IF_DIRECTIVE) && (headerGuard = OCHeaderGuardUtil.findCachedHeaderGuard(parentDirective.getContainingFile(), false)) != null && headerGuard.getBeginIfndefDirective() == parentDirective && headerGuard.getEndifDirective() != null) {
            OCHeaderGuardElementManipulator.tryToReplaceTrailingComment(headerGuard.getEndifDirective(), headerGuard.getHeaderGuardName(), newName);
        }
        return element;
    }

    private static void tryToReplaceTrailingComment(@NotNull OCDirective endifDirective, @NotNull String oldHeaderGuardName, @NotNull String newHeaderGuardName) {
        PsiComment trailingComment = (PsiComment)PsiTreeUtil.findChildOfType((PsiElement)endifDirective, PsiComment.class);
        if (trailingComment == null) {
            return;
        }
        String oldCommentText = OCElementUtil.getCommentText(trailingComment);
        IElementType elementType = trailingComment.getNode().getElementType();
        Language language = trailingComment.getLanguage();
        if (!oldCommentText.equals(oldHeaderGuardName)) {
            return;
        }
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)endifDirective.getProject());
        if (language.getAssociatedFileType() == null) {
            return;
        }
        if (elementType == OCTokenTypes.EOL_COMMENT) {
            PsiComment newComment = parserFacade.createLineCommentFromText(language.getAssociatedFileType(), newHeaderGuardName);
            trailingComment.replace((PsiElement)newComment);
        } else if (elementType == OCTokenTypes.BLOCK_COMMENT) {
            PsiComment newComment = parserFacade.createBlockCommentFromText(language, newHeaderGuardName);
            trailingComment.replace((PsiElement)newComment);
        }
    }
}

