/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameViewDescriptor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class OCInplaceRenamer
extends MemberInplaceRenamer {
    private OCSymbol mySymbol;
    private boolean myCategoryMode;
    private PsiElement mySelectorIdentifier;
    private int mySelectorIndex;
    private boolean myConvertToSetter;

    public OCInplaceRenamer(@NotNull OCMethod elementToRename, @NotNull OCMethodSymbol symbol, PsiElement selectorIdentifier, int selectorIndex, Editor editor, String initialName, String oldName) {
        super((PsiNamedElement)elementToRename, (PsiElement)elementToRename, editor, initialName != null ? initialName : selectorIdentifier.getText(), oldName != null ? oldName : selectorIdentifier.getText());
        this.mySymbol = symbol;
        this.myCategoryMode = false;
        this.mySelectorIdentifier = selectorIdentifier;
        this.mySelectorIndex = selectorIndex;
        boolean bl = this.myConvertToSetter = this.mySelectorIdentifier.getParent() instanceof OCQualifiedExpression && new OCReadWriteAccessDetector().getExpressionAccess(this.mySelectorIdentifier.getParent()) == ReadWriteAccessDetector.Access.Write;
        assert (this.mySelectorIndex != -1);
    }

    public OCInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull OCSymbol symbol, Editor editor, boolean categoryMode, String initialName, String oldName) {
        super(elementToRename, (PsiElement)elementToRename, editor, initialName != null ? initialName : OCInplaceRenamer.getElementName(elementToRename), oldName != null ? oldName : OCInplaceRenamer.getElementName(elementToRename));
        this.mySymbol = symbol;
        this.myCategoryMode = categoryMode;
    }

    private static String getElementName(PsiNamedElement elementToRename) {
        OCSymbolWithQualifiedName symbol;
        if (elementToRename instanceof OCDeclarator && elementToRename.getParent() instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)elementToRename.getParent()).getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
            return symbol.getName().substring(1);
        }
        return elementToRename.getName();
    }

    public Collection<PsiElement> getMarkedElements() {
        ArrayList<Pair<PsiElement, TextRange>> stringUsages = new ArrayList<Pair<PsiElement, TextRange>>();
        Collection<PsiReference> refs = this.collectRefs(this.getReferencesSearchScope(OCInplaceRenamer.getTopLevelVirtualFile((FileViewProvider)this.myElementToRename.getContainingFile().getViewProvider())));
        this.appendAdditionalElement(refs, stringUsages);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        refs.stream().map(ref -> ref.getElement()).forEach(e -> result.add((PsiElement)e));
        stringUsages.stream().map(pair2 -> (PsiElement)pair2.getFirst()).forEach(e -> result.add((PsiElement)e));
        return result;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        return (Boolean)this.executeUnderModalDialog(() -> this.appendAdditionalElementImpl(refs, stringUsages), "Appending Additional Elements", true);
    }

    private boolean appendAdditionalElementImpl(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        boolean showChooser = super.appendAdditionalElement(refs, stringUsages);
        OCInplaceRenamer.filterStringUsages(stringUsages);
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        VirtualFile curVirtualFile = currentFile != null ? currentFile.getVirtualFile() : null;
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCSymbolWithQualifiedName owner2;
            OCFunctionSymbol function;
            if (Comparing.equal((Object)symbol.getContainingFile(), (Object)curVirtualFile)) {
                PsiElement definition = symbol.locateDefinition(this.myProject);
                if (this.myCategoryMode) {
                    if (definition instanceof OCClassDeclaration && Comparing.equal((String)((OCClassSymbol)this.mySymbol).getCategoryName(), (String)((OCClassSymbol)symbol).getCategoryName())) {
                        PsiElement identifier = ((OCClassDeclaration)definition).getCategoryElement().getNameIdentifier();
                        OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
                    }
                } else if (definition instanceof PsiNameIdentifierOwner) {
                    if (definition instanceof OCMethod) {
                        PsiElement selector;
                        List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                        if (this.mySelectorIndex < parameters.size() && (selector = parameters.get(this.mySelectorIndex).getSelectorIdentifier()) != null && this.mySelectorIdentifier != null && selector.getText().equals(this.mySelectorIdentifier.getText())) {
                            OCInplaceRenamer.appendStringUsage(selector, stringUsages);
                        }
                    } else {
                        OCInplaceRenamer.appendStringUsage(((PsiNameIdentifierOwner)definition).getNameIdentifier(), stringUsages);
                    }
                }
                if (symbol instanceof OCLocalizedStringSymbol) {
                    OCInplaceRenamer.appendReference(new OCStringResourceReference(this.myElementToRename.getFirstChild(), FileUtil.getNameWithoutExtension((String)this.myElementToRename.getContainingFile().getName())), refs);
                }
            }
            if (symbol instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)symbol, stringUsages, refs, currentFile);
            } else if (symbol instanceof OCFunctionSymbol && ((function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor()) && (owner2 = function.getResolvedOwner(OCResolveContext.forPsi((PsiElement)currentFile))) instanceof OCStructSymbol) {
                OCInplaceRenamer.appendAdditionalSymbol(owner2, stringUsages, refs, currentFile);
                OCInplaceRenamer.appendAdditionalSymbolsForStruct((OCStructSymbol)owner2, stringUsages, refs, currentFile);
            }
            return true;
        }), this.myProject);
        if (this.mySelectorIdentifier != null) {
            for (PsiReference ref : refs) {
                PsiElement element = ref.getElement();
                PsiElement selector = null;
                if (element instanceof OCSendMessageExpression) {
                    List<OCArgumentSelector> selectors = ((OCSendMessageExpression)element).getArgumentSelectors();
                    if (this.mySelectorIndex < selectors.size()) {
                        selector = selectors.get(this.mySelectorIndex).getSelectorIdentifier();
                    }
                } else if (element instanceof OCQualifiedExpression) {
                    selector = ((OCQualifiedExpression)element).getNameIdentifier();
                } else if (element instanceof OCSelectorExpression) {
                    selector = ((OCSelectorExpression)element).getSelectorParts().get(this.mySelectorIndex);
                }
                if (selector == null || !selector.getText().equals(this.mySelectorIdentifier.getText())) continue;
                OCInplaceRenamer.appendStringUsage(selector, stringUsages);
            }
            refs.clear();
        }
        return showChooser;
    }

    private static void appendStringUsage(PsiElement element, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (element != null && !OCElementUtil.isPartOfMacroSubstitution(element)) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)element, (Object)new TextRange(0, element.getTextLength())));
        }
    }

    private static void filterStringUsages(Collection<Pair<PsiElement, TextRange>> stringUsages) {
        stringUsages.removeIf(elementAndTextRange -> OCElementUtil.isPartOfMacroSubstitution((PsiElement)elementAndTextRange.getFirst()));
    }

    private static void appendAdditionalSymbolsForStruct(OCStructSymbol symbol, Collection<Pair<PsiElement, TextRange>> stringUsages, Collection<PsiReference> refs, @NotNull PsiFile currentFile) {
        Processor processor2 = symbol1 -> {
            OCInplaceRenamer.appendAdditionalSymbol(symbol1, stringUsages, refs, currentFile);
            return true;
        };
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)currentFile);
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
        symbol.processDestructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
        symbol.processDeductionGuides((Processor<? super OCDeductionGuideSymbol>)processor2, context);
    }

    private static void appendAdditionalSymbol(OCSymbol symbol, Collection<Pair<PsiElement, TextRange>> stringUsages, Collection<PsiReference> refs, PsiFile currentFile) {
        PsiElement identifier;
        if (!Comparing.equal((Object)symbol.getContainingFile(), (Object)currentFile.getVirtualFile())) {
            return;
        }
        PsiElement definition = symbol.locateDefinition(currentFile.getProject());
        if (definition instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)definition).getNameIdentifier()) != null) {
            OCInplaceRenamer.appendStringUsage(identifier, stringUsages);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)definition, (SearchScope)new LocalSearchScope((PsiElement)currentFile), (boolean)false).findAll()) {
                if (reference.getElement() instanceof OCDeclarator) continue;
                OCInplaceRenamer.appendReference(reference, refs);
            }
        }
    }

    protected PsiElement checkLocalScope() {
        PsiFile currentFile;
        if (this.mySymbol.getKind() == OCSymbolKind.PARAMETER && this.mySymbol.getAssociatedSymbol(this.myProject) != null && (currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return currentFile;
        }
        return super.checkLocalScope();
    }

    protected PsiNamedElement getVariable() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString ? this.myElementToRename : super.getVariable();
    }

    public PsiElement getSubstituted() {
        return this.myRenameOffset == null || this.myElementToRename instanceof OCLocalizedString ? this.myElementToRename : super.getSubstituted();
    }

    protected JComponent getComponent() {
        if (this.myCategoryMode) {
            return null;
        }
        final OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        OCRenameProcessor.processAssociatedSymbols(this.mySymbol, new OCRenameProcessor.AssociatedElementsProcessor(){

            @Override
            public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                if (ivar.isClang4ImplicitIvar(OCInplaceRenamer.this.myProject)) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, "&Rename " + ivar.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename)), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processPropertyAccessors(OCPropertySymbol property) {
                return false;
            }

            @Override
            public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                if (!(fromSymbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)fromSymbol).isClang4ImplicitIvar(OCInplaceRenamer.this.myProject)) {
                    return true;
                }
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, "&Rename " + property.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename)), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_PROPERTIES_AND_IVARS = selected;
                    return settings2.REFACTOR_PROPERTIES_AND_IVARS;
                }));
                return false;
            }

            @Override
            public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, "&Rename class aliases", settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }

            @Override
            public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                OCBaseInplaceIntroducer.createCheckBox(OCInplaceRenamer.this.myProject, OCInplaceRenamer.this.myTitle, panel, "&Rename " + clazz.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)OCInplaceRenamer.this.myElementToRename)), settings.REFACTOR_PROPERTIES_AND_IVARS, (Processor<Boolean>)((Processor)selected -> {
                    settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES = selected;
                    return settings2.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES;
                }));
                return false;
            }
        }, (SearchScope)OCSearchScope.getProjectSourcesScope(this.myProject), this.myProject);
        return panel.getComponentCount() > 0 ? panel : null;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        Collection references = (Collection)this.executeUnderModalDialog(() -> super.collectRefs(referencesSearchScope), "Collecting References", true);
        this.updateNameSuggestions(references);
        return references;
    }

    public void performRenameInner(final @NotNull PsiElement element, @NotNull String newName) {
        if (this.mySelectorIdentifier != null || this.mySymbol instanceof OCFunctionSymbol && !this.mySymbol.getKind().isConstructorOrDestructor()) {
            PsiElement definition;
            if (this.myConvertToSetter) {
                newName = "set" + StringUtil.capitalize((String)newName);
            }
            if ((definition = OCElementUtil.findRenameTargetDefinition(element, false)) instanceof OCCallable) {
                OCCallable callable = (OCCallable)definition;
                OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, element, false, true, !ApplicationManager.getApplication().isUnitTestMode(), false);
                handler.setTitle(this.getCommandName());
                if (this.mySymbol instanceof OCFunctionSymbol) {
                    handler.setName(newName);
                } else {
                    handler.renameSelector(this.mySelectorIndex, newName);
                }
                handler.invoke();
            }
        } else {
            if (this.mySymbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)this.mySymbol).isClang4ImplicitIvar(this.myProject) && !newName.startsWith("_")) {
                newName = "_" + newName;
            }
            if (this.mySymbol instanceof OCPropertySymbol && newName.startsWith("_")) {
                newName = newName.substring(1);
            }
            final String newNameFinal = newName;
            RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement((PsiElement)element);
            RenameProcessor renameProcessor = new RenameProcessor(this.myProject, element, newName, elementProcessor.isToSearchInComments(element), elementProcessor.isToSearchForTextOccurrences(element)){
                private OCRenameProcessor.RenameUsages myOption;

                public void prepareRenaming(@NotNull PsiElement element2, String newName, LinkedHashMap<PsiElement, String> allRenames) {
                    OCRenameUtil.askToRenameSameEntityIfNeed(element2);
                    OCInplaceRenamer.this.executeUnderModalDialog((ThrowableRunnable<ProcessCanceledException>)() -> super.prepareRenaming(element2, newName, allRenames), "Preparing Rename", true);
                }

                public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                    if (!super.preprocessUsages(refUsages)) {
                        return false;
                    }
                    this.myOption = OCRenameProcessor.validateUsages(OCInplaceRenamer.this.myElementToRename, refUsages);
                    return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
                }

                protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
                    return this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
                }

                @NotNull
                public UsageInfo[] findUsages() {
                    ArrayList<UsageInfo> result = new ArrayList<UsageInfo>(Arrays.asList(super.findUsages()));
                    ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(element, element.getUseScope(), false);
                    new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(parameters, (Processor<? super OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)((Processor)usage -> {
                        PsiElement e = usage.getElement();
                        if (OCElementUtil.getElementType(e) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT) {
                            TextRange range = usage.getTextRange();
                            result.add((UsageInfo)NonCodeUsageInfo.create((PsiFile)e.getContainingFile(), (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)element, (String)newNameFinal));
                        }
                        return true;
                    }));
                    return result.toArray(UsageInfo.EMPTY_ARRAY);
                }

                @NotNull
                protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                    LinkedHashMap renamesMap = new LinkedHashMap();
                    for (PsiElement psiElement : this.myAllRenames.keySet()) {
                        if (!(psiElement instanceof OCSymbolDeclarator) || ((OCSymbolDeclarator)psiElement).getSymbol() == null) continue;
                        renamesMap.put(psiElement, this.myAllRenames.get(psiElement));
                    }
                    return new RenameViewDescriptor(renamesMap);
                }

                public void doRun() {
                    try {
                        super.doRun();
                    }
                    finally {
                        OCInplaceRenamer.this.restoreCaretOffsetAfterRename();
                    }
                }
            };
            renameProcessor.run();
        }
    }

    public boolean performInplaceRename() {
        return this.performInplaceRefactoring(new LinkedHashSet());
    }

    private void updateNameSuggestions(@NotNull Collection<PsiReference> references) {
        if (this.myNameSuggestions == null) {
            this.myNameSuggestions = new LinkedHashSet();
        }
        String originalName = this.myElementToRename.getName();
        if (this.myElementToRename instanceof OCDeclarator) {
            List<String> predefinedNames = originalName == null ? Collections.emptyList() : Collections.singletonList(originalName);
            this.myNameSuggestions.addAll(OCNameSuggester.suggestForDeclaration((OCDeclarator)this.myElementToRename, true, predefinedNames));
        } else if (this.myElementToRename instanceof OCMethodSelectorPart) {
            ArrayList paramNames = new ArrayList();
            OCMethod method = (OCMethod)this.myElementToRename.getParent();
            List<OCMethodSelectorPart> parameters = method.getParameters();
            for (OCMethodSelectorPart part : parameters) {
                String parameterName = part.getParameterName();
                if (parameterName == null) continue;
                paramNames.add(parameterName);
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)this.myElementToRename);
            OCMethodSelectorPart selectorPart = (OCMethodSelectorPart)this.myElementToRename;
            this.myNameSuggestions.addAll(OCNameSuggester.suggestForType(selectorPart.getType(), (PsiElement)selectorPart, paramNames, context));
            this.myNameSuggestions.add(OCNameSuggester.suggestForParameter(paramNames, parameters.get(0) == this.myElementToRename, selectorPart.getSelectorPart(), selectorPart.getType(), (OCMethodSymbol)method.getSymbol(), null, context));
        }
        for (PsiReference ref : references) {
            OCExpression expr = null;
            PsiElement element = ref.getElement();
            if (element instanceof OCQualifiedExpression) {
                expr = (OCExpression)element;
            } else if (element instanceof OCReferenceElement && element.getParent() instanceof OCReferenceExpression) {
                expr = (OCExpression)element.getParent();
            }
            if (expr == null) continue;
            this.myNameSuggestions.addAll(OCNameSuggester.suggestForExpression(this.mySymbol.getKind(), expr));
        }
        Iterator iterator2 = this.myNameSuggestions.iterator();
        while (iterator2.hasNext()) {
            String name2 = (String)iterator2.next();
            if (originalName == null || !name2.startsWith(originalName) || !name2.substring(originalName.length()).matches("[0-9]*")) continue;
            iterator2.remove();
        }
    }

    public void performRefactoringForTest(String newName) {
        this.performRefactoringRename(newName, null);
    }

    protected boolean acceptReference(PsiReference reference) {
        return !OCElementUtil.isPartOfMacroSubstitution(reference.getElement()) && Comparing.equal((String)reference.getCanonicalText(), (String)this.myElementToRename.getName());
    }

    private static void appendReference(PsiReference ref, Collection<PsiReference> refs) {
        if (!OCElementUtil.isPartOfMacroSubstitution(ref.getElement())) {
            refs.add(ref);
        }
    }

    protected boolean isIdentifier(String newName, Language language) {
        return this.myElementToRename instanceof OCLocalizedString && !newName.isEmpty() || this.mySelectorIdentifier != null && newName.isEmpty() || super.isIdentifier(newName, language);
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return OCInplaceRenameHandler.createRenamer((PsiElement)variable, editor, this.myOldName, this.myOldName);
    }

    protected PsiElement getNameIdentifier() {
        PsiElement identifier = this.mySelectorIdentifier != null ? this.mySelectorIdentifier : super.getNameIdentifier();
        return identifier != null && OCElementUtil.isPartOfMacroSubstitution(identifier) ? null : identifier;
    }

    protected String getCommandName() {
        PsiNamedElement variable = this.getVariable();
        return variable != null && !variable.isValid() ? "Rename" : super.getCommandName();
    }

    protected void showDialogAdvertisement(String actionId) {
    }

    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
        return false;
    }

    private <T> T executeUnderModalDialog(final @NotNull ThrowableComputable<T, ProcessCanceledException> computable, @NotNull String title, boolean canBeCancelled) {
        Task.WithResult task = new Task.WithResult<T, ProcessCanceledException>(this.myProject, title, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                indicator.setIndeterminate(true);
                return ReadAction.compute((ThrowableComputable)computable);
            }
        };
        return (T)ProgressManager.getInstance().run(task);
    }

    private void executeUnderModalDialog(final @NotNull ThrowableRunnable<ProcessCanceledException> runnable, @NotNull String title, boolean canBeCancelled) {
        Task.Modal task = new Task.Modal(this.myProject, title, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                ReadAction.run((ThrowableRunnable)runnable);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }
}

