/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedFunctionSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameUtil {
    public static final Key<CachedValue<Ref<Boolean>>> RENAME_SAME_ENTITY_CACHE = Key.create((String)"RENAME_SAME_ENTITY_CACHE");

    @Nullable
    public static OCSymbol getSymbolToRename(@NotNull PsiElement element) {
        OCSymbol symbol = null;
        if (element instanceof OCSymbolDeclarator) {
            symbol = (OCSymbol)((OCSymbolDeclarator)element).getSymbol();
        } else {
            PsiReference maybeOperatorRef = element.getReference();
            if (maybeOperatorRef instanceof OCOperatorReference) {
                symbol = (OCSymbol)((OCOperatorReference)maybeOperatorRef).resolveToSymbol();
            }
        }
        return OCCompilerGeneratedFunctionSymbol.unwrap(symbol);
    }

    public static boolean shouldRenameSameClassOrFileEntity(@NotNull PsiElement element) {
        Ref<Boolean> cache = OCRenameUtil.getRenameSameEntityCache(element);
        return !cache.isNull() && (Boolean)cache.get() != false;
    }

    public static boolean symbolHasSameNameWithFile(@NotNull String symbolName, @NotNull OCSymbolKind symbolKind, @NotNull PsiFile file) {
        String name2 = symbolKind.isConstructorOrDestructor() ? StringUtil.trimStart((String)symbolName, (String)"~") : symbolName;
        return FileUtil.getNameWithoutExtension((String)file.getName()).equals(name2);
    }

    public static void askToRenameSameEntityIfNeed(@NotNull PsiElement element) {
        OCSymbol declaratorSymbol;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PsiFile file = element.getContainingFile();
        Ref<Boolean> cache = OCRenameUtil.getRenameSameEntityCache((PsiElement)file);
        if (element instanceof OCFile) {
            OCFile headerFile;
            OCFile ocFile = (OCFile)element;
            OCFile oCFile = headerFile = ocFile.isHeader() ? ocFile : ocFile.getAssociatedFileWithSameName();
            if (headerFile != null && headerFile.getSameNamedClass() != null) {
                cache.set((Object)OCRenameUtil.askToRenameSameNamedClass());
            }
        } else if (element instanceof OCStructLike) {
            OCStructSymbol structSymbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            if (structSymbol != null && OCRenameUtil.symbolHasSameNameWithFile(structSymbol.getName(), structSymbol.getKind(), file)) {
                cache.set((Object)OCRenameUtil.askToRenameSameNamedFile());
            }
        } else if (element instanceof OCDeclarator && (declaratorSymbol = ((OCDeclarator)element).getSymbol()) != null && declaratorSymbol.getKind().isConstructorOrDestructor() && OCRenameUtil.symbolHasSameNameWithFile(declaratorSymbol.getName(), declaratorSymbol.getKind(), file)) {
            cache.set((Object)OCRenameUtil.askToRenameSameNamedFile());
        }
    }

    public static Ref<Boolean> getRenameSameEntityCacheForTests(@NotNull PsiElement element) {
        return OCRenameUtil.getRenameSameEntityCache(element);
    }

    private static Ref<Boolean> getRenameSameEntityCache(@NotNull PsiElement element) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(element.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{modificationTracker});
        return (Ref)manager.getCachedValue((UserDataHolder)element.getContainingFile(), RENAME_SAME_ENTITY_CACHE, provider2, false);
    }

    private static boolean askToRenameSameNamedFile() {
        int code = Messages.showYesNoDialog((String)OCBundle.message("rename.renameAssociatedFiles", new Object[0]), (String)"Rename", (Icon)Messages.getQuestionIcon());
        return code == 0;
    }

    private static boolean askToRenameSameNamedClass() {
        int code = Messages.showYesNoDialog((String)OCBundle.message("rename.renameAssociatedClass", new Object[0]), (String)"Rename", (Icon)Messages.getQuestionIcon());
        return code == 0;
    }
}

